/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.packageChecker.model.GeneralRepositoryServer;
import com.intellij.packageChecker.model.HttpClientApi;
import com.intellij.packageChecker.model.HttpClientHeadersService;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.ResourceUrl;
import com.intellij.packageChecker.model.dto.HashesDto;
import com.intellij.packageChecker.model.dto.PackageStatus;
import com.intellij.packageChecker.model.dto.RequestDto;
import com.intellij.packageChecker.model.dto.UncheckedPackage;
import com.intellij.packageChecker.model.dto.VulnerablePackageDto;
import com.intellij.packageChecker.model.exceptions.AnalysisException;
import com.intellij.packageChecker.util.GzipUtils;
import com.intellij.packageChecker.util.SerializationUtils;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0084@\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001cH\u0002J$\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020#H\u0082@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00138DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006*"}, d2={"Lcom/intellij/packageChecker/model/GeneralRepositoryServer;", "", "applicationMode", "", "packagesUrlString", "", "dbBaseUrl", "Lcom/intellij/packageChecker/model/ResourceUrl;", "attemptsToCheck", "requestTimeout", "Ljava/time/Duration;", "<init>", "(ILjava/lang/String;Lcom/intellij/packageChecker/model/ResourceUrl;ILjava/time/Duration;)V", "chunkSize", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "httpClient", "Lcom/intellij/packageChecker/model/HttpClientApi;", "getHttpClient", "()Lcom/intellij/packageChecker/model/HttpClientApi;", "httpClient$delegate", "Lkotlin/Lazy;", "gzipHttpClient", "getGzipHttpClient", "gzipHttpClient$delegate", "getStatusForPackages", "", "Lcom/intellij/packageChecker/model/dto/PackageStatus;", "pkgs", "", "Lcom/intellij/packageChecker/model/Package;", "(Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createRequestDto", "Lcom/intellij/packageChecker/model/dto/RequestDto;", "packageChunk", "getPackagesFromServer", "url", "requestData", "(Ljava/lang/String;Lcom/intellij/packageChecker/model/dto/RequestDto;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nGeneralRepositoryServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralRepositoryServer.kt\ncom/intellij/packageChecker/model/GeneralRepositoryServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,114:1\n1391#2:115\n1480#2,2:116\n1586#2:119\n1661#2,3:120\n1482#2,3:123\n1586#2:126\n1661#2,3:127\n375#3:118\n13#4:130\n*S KotlinDebug\n*F\n+ 1 GeneralRepositoryServer.kt\ncom/intellij/packageChecker/model/GeneralRepositoryServer\n*L\n57#1:115\n57#1:116,2\n84#1:119\n84#1:120,3\n57#1:123,3\n89#1:126\n89#1:127,3\n58#1:118\n33#1:130\n*E\n"})
public class GeneralRepositoryServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int applicationMode;
    @NotNull
    private final String packagesUrlString;
    @NotNull
    private final ResourceUrl dbBaseUrl;
    private final int attemptsToCheck;
    @NotNull
    private final Duration requestTimeout;
    private final int chunkSize;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Lazy httpClient$delegate;
    @NotNull
    private final Lazy gzipHttpClient$delegate;
    @NotNull
    private static final Logger logger;

    public GeneralRepositoryServer(int applicationMode, @NotNull String packagesUrlString, @NotNull ResourceUrl dbBaseUrl, int attemptsToCheck, @NotNull Duration requestTimeout) {
        Intrinsics.checkNotNullParameter((Object)packagesUrlString, (String)"packagesUrlString");
        Intrinsics.checkNotNullParameter((Object)dbBaseUrl, (String)"dbBaseUrl");
        Intrinsics.checkNotNullParameter((Object)requestTimeout, (String)"requestTimeout");
        this.applicationMode = applicationMode;
        this.packagesUrlString = packagesUrlString;
        this.dbBaseUrl = dbBaseUrl;
        this.attemptsToCheck = attemptsToCheck;
        this.requestTimeout = requestTimeout;
        this.chunkSize = 4096;
        this.objectMapper = SerializationUtils.INSTANCE.getOm();
        this.httpClient$delegate = LazyKt.lazy(() -> GeneralRepositoryServer.httpClient_delegate$lambda$0(this));
        this.gzipHttpClient$delegate = LazyKt.lazy(() -> GeneralRepositoryServer.gzipHttpClient_delegate$lambda$0(this));
    }

    public /* synthetic */ GeneralRepositoryServer(int n, String string, ResourceUrl resourceUrl, int n2, Duration duration, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n2 = 3;
        }
        if ((n3 & 0x10) != 0) {
            Duration duration2 = Duration.ofMinutes(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMinutes(...)");
            duration = duration2;
        }
        this(n, string, resourceUrl, n2, duration);
    }

    @NotNull
    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    protected final HttpClientApi getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (HttpClientApi)lazy.getValue();
    }

    @NotNull
    protected final HttpClientApi getGzipHttpClient() {
        Lazy lazy = this.gzipHttpClient$delegate;
        return (HttpClientApi)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object getStatusForPackages(@NotNull Iterable<Package> pkgs, @NotNull Continuation<? super List<? extends PackageStatus>> $completion) {
        block20: {
            block19: {
                if (!($completion instanceof getStatusForPackages.1)) ** GOTO lbl-1000
                var25_3 = $completion;
                if ((var25_3.label & -2147483648) != 0) {
                    var25_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        Object L$3;
                        Object L$4;
                        Object L$5;
                        Object L$6;
                        Object L$7;
                        int I$0;
                        int I$1;
                        int I$2;
                        int I$3;
                        /* synthetic */ Object result;
                        final /* synthetic */ GeneralRepositoryServer this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.getStatusForPackages(null, (Continuation<? super List<? extends PackageStatus>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var26_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block2 : switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!(this.attemptsToCheck > 0)) {
                            var4_6 = "Failed requirement.";
                            throw new IllegalArgumentException(var4_6.toString());
                        }
                        $this$flatMap$iv = CollectionsKt.chunked(pkgs, (int)this.chunkSize);
                        $i$f$flatMap = 0;
                        var5_9 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = 0;
                        var8_12 = $this$flatMapTo$iv$iv.iterator();
lbl21:
                        // 2 sources

                        while (var8_12.hasNext()) {
                            element$iv$iv = var8_12.next();
                            pkgChunk = (List)element$iv$iv;
                            $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = 0;
                            var12_17 = $continuation;
                            $i$f$currentCoroutineContext = false;
                            JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                            attempt = 0;
                            exception = null;
lbl32:
                            // 3 sources

                            while (attempt < this.attemptsToCheck) {
                                ++attempt;
                                if (pkgChunk.isEmpty()) {
                                    v0 = CollectionsKt.emptyList();
                                    break block19;
                                }
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)pkgs);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$flatMap$iv);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$flatMapTo$iv$iv);
                                $continuation.L$3 = destination$iv$iv;
                                $continuation.L$4 = var8_12;
                                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                                $continuation.L$6 = pkgChunk;
                                $continuation.L$7 = exception;
                                $continuation.I$0 = $i$f$flatMap;
                                $continuation.I$1 = $i$f$flatMapTo;
                                $continuation.I$2 = $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2;
                                $continuation.I$3 = attempt;
                                $continuation.label = 1;
                                v1 = this.getPackagesFromServer(this.dbBaseUrl.url + this.packagesUrlString, this.createRequestDto(pkgChunk), (Continuation<? super List<? extends PackageStatus>>)$continuation);
                                ** if (v1 != var26_5) goto lbl55
lbl54:
                                // 1 sources

                                return var26_5;
lbl55:
                                // 1 sources

                                ** GOTO lbl75
                            }
                            break block2;
                        }
                        break block20;
                    }
                    case 1: {
                        attempt = $continuation.I$3;
                        $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = $continuation.I$2;
                        $i$f$flatMapTo = $continuation.I$1;
                        $i$f$flatMap = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$7;
                        pkgChunk = (List)$continuation.L$6;
                        element$iv$iv = $continuation.L$5;
                        var8_12 = (Iterator)$continuation.L$4;
                        destination$iv$iv = (Collection)$continuation.L$3;
                        $this$flatMapTo$iv$iv = (Iterable)$continuation.L$2;
                        $this$flatMap$iv = (Iterable)$continuation.L$1;
                        pkgs = (Iterable)$continuation.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl75:
                            // 2 sources

                            v0 = (Iterable)v1;
                            break block19;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = "Failed to check dependencies on server: " + this.dbBaseUrl.url;
                            var16_24 = e;
                            if (var16_24 instanceof IOException || var16_24 instanceof IllegalArgumentException || var16_24 instanceof AnalysisException) {
                                GeneralRepositoryServer.logger.warn(message);
                                GeneralRepositoryServer.logger.debug((Throwable)e);
                                v2 = e instanceof AnalysisException != false ? (AnalysisException)e : null;
                                if (v2 == null) {
                                    v2 = new AnalysisException(message);
                                }
                                exception = v2;
                            }
                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)pkgs);
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$flatMap$iv);
                            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$flatMapTo$iv$iv);
                            $continuation.L$3 = destination$iv$iv;
                            $continuation.L$4 = var8_12;
                            $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                            $continuation.L$6 = pkgChunk;
                            $continuation.L$7 = exception;
                            $continuation.I$0 = $i$f$flatMap;
                            $continuation.I$1 = $i$f$flatMapTo;
                            $continuation.I$2 = $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2;
                            $continuation.I$3 = attempt;
                            $continuation.label = 2;
                            v3 = DelayKt.delay((long)(attempt * 200), (Continuation)$continuation);
                            if (v3 != var26_5) ** GOTO lbl32
                            return var26_5;
                        }
                    }
                    case 2: {
                        attempt = $continuation.I$3;
                        $i$a$-flatMap-GeneralRepositoryServer$getStatusForPackages$2 = $continuation.I$2;
                        $i$f$flatMapTo = $continuation.I$1;
                        $i$f$flatMap = $continuation.I$0;
                        exception = (AnalysisException)$continuation.L$7;
                        pkgChunk = (List)$continuation.L$6;
                        element$iv$iv = $continuation.L$5;
                        var8_12 = (Iterator)$continuation.L$4;
                        destination$iv$iv = (Collection)$continuation.L$3;
                        $this$flatMapTo$iv$iv = (Iterable)$continuation.L$2;
                        $this$flatMap$iv = (Iterable)$continuation.L$1;
                        pkgs = (Iterable)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl32
                    }
                }
                if (exception != null) {
                    v4 = exception.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getStackTrace(...)");
                    v5 = v4;
                    v6 = LineSeparator.getSystemLineSeparator().getSeparatorString();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getSeparatorString(...)");
                    GeneralRepositoryServer.logger.warn(ArraysKt.joinToString$default((Object[])v5, (CharSequence)v6, null, null, (int)0, null, null, (int)62, null));
                }
                $this$map$iv = pkgChunk;
                $i$f$map = false;
                var16_24 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_29 = (Package)item$iv$iv;
                    var22_30 = destination$iv$iv;
                    $i$a$-map-GeneralRepositoryServer$getStatusForPackages$2$1 = false;
                    var22_30.add(new UncheckedPackage((Package)it));
                }
                v0 = (List)destination$iv$iv;
            }
            list$iv$iv = v0;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            ** GOTO lbl21
        }
        return (List)destination$iv$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final RequestDto createRequestDto(List<Package> packageChunk) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = packageChunk;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchKey());
        }
        List packageDTOs = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        return new HashesDto(packageDTOs, this.applicationMode);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object getPackagesFromServer(String url, RequestDto requestData, Continuation<? super List<? extends PackageStatus>> $completion) {
        if (!($completion instanceof getPackagesFromServer.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ GeneralRepositoryServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GeneralRepositoryServer.access$getPackagesFromServer(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                bodyHandler = (HttpResponse.BodyHandler<T>)LambdaMetafactory.metafactory(null, null, null, (Ljava/net/http/HttpResponse$ResponseInfo;)Ljava/net/http/HttpResponse$BodySubscriber;, getPackagesFromServer$lambda$0(com.intellij.packageChecker.model.GeneralRepositoryServer java.net.http.HttpResponse$ResponseInfo ), (Ljava/net/http/HttpResponse$ResponseInfo;)Ljava/net/http/HttpResponse$BodySubscriber;)((GeneralRepositoryServer)this);
                requestDataJson = this.objectMapper.writeValueAsBytes((Object)requestData);
                v0 = this.getGzipHttpClient();
                Intrinsics.checkNotNull((Object)requestDataJson);
                v1 = HttpRequest.BodyPublishers.ofByteArray(GzipUtils.INSTANCE.compressToGzip(requestDataJson));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ofByteArray(...)");
                $continuation.L$0 = url;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)requestData);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(bodyHandler);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)requestDataJson);
                $continuation.label = 1;
                v2 = v0.post(url, v1, bodyHandler, $continuation);
                ** if (v2 != var9_6) goto lbl28
lbl27:
                // 1 sources

                return var9_6;
lbl28:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                requestDataJson = (byte[])$continuation.L$3;
                bodyHandler = (HttpResponse.BodyHandler)$continuation.L$2;
                requestData = (RequestDto)$continuation.L$1;
                url = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl38:
                    // 2 sources

                    var4_12 /* !! */  = ((HttpResponse)v2).body();
                    Intrinsics.checkNotNull(var4_12 /* !! */ );
                    var4_12 /* !! */  = (List)var4_12 /* !! */ ;
                }
                catch (Exception <unused var>) {
                    throw new AnalysisException("Failed to check dependencies on server: " + url);
                }
                return var4_12 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final HttpClientApi httpClient_delegate$lambda$0(GeneralRepositoryServer this$0) {
        return new HttpClientApi(HttpClientHeadersService.Companion.getInstance().getHeaderParams(), this$0.requestTimeout);
    }

    private static final HttpClientApi gzipHttpClient_delegate$lambda$0(GeneralRepositoryServer this$0) {
        return new HttpClientApi(HttpClientHeadersService.Companion.getInstance().getGzipHeadersParam(), this$0.requestTimeout);
    }

    private static final List getPackagesFromServer$lambda$0$0(GeneralRepositoryServer this$0, byte[] it) {
        Intrinsics.checkNotNull((Object)it);
        String originalContent = GzipUtils.INSTANCE.decompressFromGzipOrGetString(it);
        return (List)this$0.objectMapper.readValue(originalContent, (TypeReference)new TypeReference<List<? extends VulnerablePackageDto>>(){});
    }

    private static final List getPackagesFromServer$lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final HttpResponse.BodySubscriber getPackagesFromServer$lambda$0(GeneralRepositoryServer this$0, HttpResponse.ResponseInfo it) {
        return HttpResponse.BodySubscribers.mapping(HttpResponse.BodySubscribers.ofByteArray(), arg_0 -> GeneralRepositoryServer.getPackagesFromServer$lambda$0$1(arg_0 -> GeneralRepositoryServer.getPackagesFromServer$lambda$0$0(this$0, arg_0), arg_0));
    }

    public static final /* synthetic */ Object access$getPackagesFromServer(GeneralRepositoryServer $this, String url, RequestDto requestData, Continuation $completion) {
        return $this.getPackagesFromServer(url, requestData, (Continuation<? super List<? extends PackageStatus>>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GeneralRepositoryServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GeneralRepositoryServer.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/packageChecker/model/GeneralRepositoryServer$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.packageChecker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

