/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jvm.advanced.java.instrumentation;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.InstrumentationBreakpointState;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.jvm.advanced.java.instrumentation.BreakpointInstrumentationOutcome;
import com.intellij.debugger.jvm.advanced.java.instrumentation.DiagnosticInstrumentationData;
import com.intellij.debugger.requests.RequestManager;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006."}, d2={"Lcom/intellij/debugger/jvm/advanced/java/instrumentation/InstrumentationBreakpointStateImpl;", "Lcom/intellij/debugger/engine/InstrumentationBreakpointState;", "instrumentationId", "", "diagnostic", "Lcom/intellij/debugger/jvm/advanced/java/instrumentation/DiagnosticInstrumentationData;", "<init>", "(ILcom/intellij/debugger/jvm/advanced/java/instrumentation/DiagnosticInstrumentationData;)V", "getInstrumentationId", "()I", "getDiagnostic", "()Lcom/intellij/debugger/jvm/advanced/java/instrumentation/DiagnosticInstrumentationData;", "originalRequestor", "Lcom/intellij/debugger/requests/Requestor;", "getOriginalRequestor", "()Lcom/intellij/debugger/requests/Requestor;", "setOriginalRequestor", "(Lcom/intellij/debugger/requests/Requestor;)V", "hitRequestor", "Lcom/intellij/debugger/ui/breakpoints/FilteredRequestor;", "getHitRequestor", "()Lcom/intellij/debugger/ui/breakpoints/FilteredRequestor;", "setHitRequestor", "(Lcom/intellij/debugger/ui/breakpoints/FilteredRequestor;)V", "isInstrumentationModeEnabled", "", "()Z", "setInstrumentationModeEnabled", "(Z)V", "hitMethod", "Lcom/sun/jdi/Method;", "getHitMethod", "()Lcom/sun/jdi/Method;", "setHitMethod", "(Lcom/sun/jdi/Method;)V", "hitStatisticsResult", "Lcom/intellij/debugger/jvm/advanced/java/instrumentation/BreakpointInstrumentationOutcome;", "getHitStatisticsResult$intellij_debugger_jvm_advanced_java", "()Lcom/intellij/debugger/jvm/advanced/java/instrumentation/BreakpointInstrumentationOutcome;", "setHitStatisticsResult$intellij_debugger_jvm_advanced_java", "(Lcom/intellij/debugger/jvm/advanced/java/instrumentation/BreakpointInstrumentationOutcome;)V", "updateInstrumentationModeEnabled", "", "requestManager", "Lcom/intellij/debugger/requests/RequestManager;", "newEnableState", "intellij.debugger.jvm.advanced.java"})
public final class InstrumentationBreakpointStateImpl
implements InstrumentationBreakpointState {
    private final int instrumentationId;
    @NotNull
    private final DiagnosticInstrumentationData diagnostic;
    public Requestor originalRequestor;
    @Nullable
    private FilteredRequestor hitRequestor;
    private boolean isInstrumentationModeEnabled;
    @Nullable
    private Method hitMethod;
    @Nullable
    private BreakpointInstrumentationOutcome hitStatisticsResult;

    public InstrumentationBreakpointStateImpl(int instrumentationId, @NotNull DiagnosticInstrumentationData diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        this.instrumentationId = instrumentationId;
        this.diagnostic = diagnostic;
    }

    public int getInstrumentationId() {
        return this.instrumentationId;
    }

    @NotNull
    public final DiagnosticInstrumentationData getDiagnostic() {
        return this.diagnostic;
    }

    @NotNull
    public final Requestor getOriginalRequestor() {
        Requestor requestor2 = this.originalRequestor;
        if (requestor2 != null) {
            return requestor2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"originalRequestor");
        return null;
    }

    public final void setOriginalRequestor(@NotNull Requestor requestor2) {
        Intrinsics.checkNotNullParameter((Object)requestor2, (String)"<set-?>");
        this.originalRequestor = requestor2;
    }

    @Nullable
    public final FilteredRequestor getHitRequestor() {
        return this.hitRequestor;
    }

    public final void setHitRequestor(@Nullable FilteredRequestor filteredRequestor) {
        this.hitRequestor = filteredRequestor;
    }

    public boolean isInstrumentationModeEnabled() {
        return this.isInstrumentationModeEnabled;
    }

    public void setInstrumentationModeEnabled(boolean bl) {
        this.isInstrumentationModeEnabled = bl;
    }

    @Nullable
    public final Method getHitMethod() {
        return this.hitMethod;
    }

    public final void setHitMethod(@Nullable Method method) {
        this.hitMethod = method;
    }

    @Nullable
    public final BreakpointInstrumentationOutcome getHitStatisticsResult$intellij_debugger_jvm_advanced_java() {
        return this.hitStatisticsResult;
    }

    public final void setHitStatisticsResult$intellij_debugger_jvm_advanced_java(@Nullable BreakpointInstrumentationOutcome breakpointInstrumentationOutcome) {
        this.hitStatisticsResult = breakpointInstrumentationOutcome;
    }

    public void updateInstrumentationModeEnabled(@NotNull RequestManager requestManager, boolean newEnableState) {
        Intrinsics.checkNotNullParameter((Object)requestManager, (String)"requestManager");
        RequestManagerImpl cfr_ignored_0 = (RequestManagerImpl)requestManager;
        if (this.hitRequestor == null) {
            throw new IllegalStateException("Cannot update instrumentation mode when hit requestor is not set".toString());
        }
        if (newEnableState == this.isInstrumentationModeEnabled()) {
            return;
        }
        this.setInstrumentationModeEnabled(newEnableState);
        Method method = this.hitMethod;
        Intrinsics.checkNotNull((Object)method);
        ReferenceType referenceType = method.declaringType();
        Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ClassType");
        ClassType classType = (ClassType)referenceType;
        Field disableField = DebuggerUtils.findField((ReferenceType)classType, (String)"isDisabled");
        classType.setValue(disableField, classType.virtualMachine().mirrorOf(!newEnableState));
        if (newEnableState) {
            RequestManagerImpl requestManagerImpl = (RequestManagerImpl)requestManager;
            Method method2 = this.hitMethod;
            Intrinsics.checkNotNull((Object)method2);
            BreakpointRequest request = requestManagerImpl.createBreakpointRequest(this.hitRequestor, method2.locationOfCodeIndex(0L));
            ((RequestManagerImpl)requestManager).enableRequest((EventRequest)request);
        } else {
            RequestManagerImpl requestManagerImpl = (RequestManagerImpl)requestManager;
            FilteredRequestor filteredRequestor = this.hitRequestor;
            Intrinsics.checkNotNull((Object)filteredRequestor);
            requestManagerImpl.deleteRequest((Requestor)filteredRequestor);
        }
    }
}

