/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.openapi.diagnostic.Logger;
import java.text.ParseException;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessagesParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceMessageUtil {
    private static final Logger LOG = Logger.getInstance(ServiceMessageUtil.class);

    private ServiceMessageUtil() {
    }

    @Nullable
    public static ServiceMessage parse(@NotNull String text, boolean validateRequiredAttributes) {
        if (text == null) {
            ServiceMessageUtil.$$$reportNull$$$0(0);
        }
        return ServiceMessageUtil.parse(text, validateRequiredAttributes, true, null);
    }

    @Nullable
    public static ServiceMessage parse(@NotNull String text, boolean validateRequiredAttributes, boolean logErrorOnParseFailure) {
        if (text == null) {
            ServiceMessageUtil.$$$reportNull$$$0(1);
        }
        return ServiceMessageUtil.parse(text, validateRequiredAttributes, logErrorOnParseFailure, null);
    }

    @Nullable
    public static ServiceMessage parse(@NotNull String text, boolean validateRequiredAttributes, boolean logErrorOnParseFailure, @Nullable String testFrameworkName) {
        if (text == null) {
            ServiceMessageUtil.$$$reportNull$$$0(2);
        }
        if (text.startsWith("##teamcity[") && text.endsWith("]")) {
            ServiceMessagesParser parser = new ServiceMessagesParser();
            parser.setValidateRequiredAttributes(validateRequiredAttributes);
            MyServiceMessageParserCallback callback = new MyServiceMessageParserCallback(text, logErrorOnParseFailure, testFrameworkName);
            parser.parse(text, (ServiceMessageParserCallback)callback);
            return callback.getParsedMessage();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/sm/ServiceMessageUtil", "parse"));
    }

    private static class MyServiceMessageParserCallback
    implements ServiceMessageParserCallback {
        @NotNull
        private final String myText;
        private final boolean myLogErrorOnParseFailure;
        @Nullable
        private final String myTestFrameworkName;
        private ServiceMessage myMessage;
        private boolean myParseFailed;

        MyServiceMessageParserCallback(@NotNull String text, boolean logErrorOnParseFailure, @Nullable String testFrameworkName) {
            if (text == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myLogErrorOnParseFailure = logErrorOnParseFailure;
            this.myTestFrameworkName = testFrameworkName;
        }

        public void regularText(@NotNull String regularText) {
            if (regularText == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(1);
            }
            if (this.myLogErrorOnParseFailure) {
                LOG.error("Regular text encountered when parsing service message", new String[]{this.myText, regularText, this.getTestFrameworkName()});
            }
            this.myParseFailed = true;
        }

        public void serviceMessage(@NotNull ServiceMessage message) {
            if (message == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(2);
            }
            if (this.myMessage != null) {
                if (this.myLogErrorOnParseFailure) {
                    LOG.error("Another service message already parsed", new String[]{this.myText, this.myMessage.asString(), message.asString(), this.getTestFrameworkName()});
                }
                this.myParseFailed = true;
            }
            this.myMessage = message;
        }

        public void parseException(@NotNull ParseException parseException, @NotNull String parseErrorText) {
            if (parseException == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(3);
            }
            if (parseErrorText == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(4);
            }
            if (this.myLogErrorOnParseFailure) {
                LOG.error("Failed to parse service message", (Throwable)parseException, new String[]{parseErrorText, this.getTestFrameworkName()});
            }
            this.myParseFailed = true;
        }

        @NotNull
        private String getTestFrameworkName() {
            Object object = this.myTestFrameworkName == null ? "unknown testFramework" : "testFramework:" + this.myTestFrameworkName;
            if (object == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(5);
            }
            return object;
        }

        @Nullable
        public ServiceMessage getParsedMessage() {
            return this.myParseFailed ? null : this.myMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regularText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parseException";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parseErrorText";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/ServiceMessageUtil$MyServiceMessageParserCallback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/ServiceMessageUtil$MyServiceMessageParserCallback";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTestFrameworkName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "regularText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "serviceMessage";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "parseException";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

