/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.ide.IconProvider;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.SpringBootApiIcons;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@ApiStatus.Internal
public final class SpringBootApplicationYamlIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            SpringBootApplicationYamlIconProvider.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)element.getProject())) {
            return SpringBootApplicationYamlIconProvider.getIconInDumbMode(element);
        }
        return SpringBootApplicationYamlIconProvider.getIconInSmartMode(element);
    }

    @Nullable
    private static Icon getIconInSmartMode(@NotNull PsiElement element) {
        if (element == null) {
            SpringBootApplicationYamlIconProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof YAMLFile) {
            if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)element.getProject())) {
                return null;
            }
            return SpringBootConfigurationFileService.getInstance().getApplicationConfigurationFileIcon((PsiFile)((YAMLFile)element));
        }
        if (element instanceof YAMLKeyValue) {
            YAMLKeyValue keyValue = (YAMLKeyValue)element;
            PsiFile containingFile = element.getContainingFile();
            if (!(containingFile instanceof YAMLFile && SpringBootLibraryUtil.hasSpringBootLibrary((Project)element.getProject()) && SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(containingFile))) {
                return null;
            }
            MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)keyValue);
            if (configKey != null) {
                return configKey.getPresentation().getIcon();
            }
        }
        return null;
    }

    private static Icon getIconInDumbMode(PsiElement element) {
        YAMLFile file;
        String fileName;
        if (element instanceof YAMLFile && ((fileName = (file = (YAMLFile)element).getName()).startsWith("application-") || fileName.startsWith("application.") || fileName.equals("bootstrap.yaml") || fileName.equals("bootstrap.yml"))) {
            Module module = DumbAwareLineMarkerUtilsKt.findModuleForFileWhenDumb((PsiFile)file);
            if (module == null || module.isDisposed() || !SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) {
                return null;
            }
            if (fileName.startsWith("bootstrap.")) {
                return SpringBootApiIcons.SpringCloud;
            }
            return SpringBootApiIcons.SpringBoot;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIconInSmartMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

