/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionUtil;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.dirtiesContexts.SpringTestingDirtiesContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public final class SpringTestingDirtiesContextInspection
extends SpringUastInspectionBase {
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(1);
        }
        PsiElement sourcePsiClass = aClass.getSourcePsi();
        PsiClass javaPsiClass = aClass.getJavaPsi();
        if (sourcePsiClass == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsiClass);
        if (module == null || !SpringTestContextUtil.getInstance().isTestContextConfigurationClass(javaPsiClass)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsiClass.getContainingFile(), isOnTheFly);
        SpringTestingDirtiesContext dirtiesContext = (SpringTestingDirtiesContext)SpringTestingDirtiesContext.CLASS_META.getJamElement((PsiModifierListOwner)javaPsiClass);
        if (dirtiesContext != null) {
            SpringTestingDirtiesContextInspection.checkMethodModeOnClass(holder, dirtiesContext);
            SpringTestingDirtiesContextInspection.checkHierarchyMode(javaPsiClass, holder, dirtiesContext);
        }
        for (UMethod method : aClass.getMethods()) {
            PsiMethod javaPsiMethod = method.getJavaPsi();
            SpringTestingDirtiesContext methodDirties = (SpringTestingDirtiesContext)SpringTestingDirtiesContext.METHOD_META.getJamElement((PsiModifierListOwner)javaPsiMethod);
            if (methodDirties == null) continue;
            SpringTestingDirtiesContextInspection.checkHierarchyMode(javaPsiClass, holder, methodDirties);
            SpringTestingDirtiesContextInspection.checkClassModeOnMethod(holder, methodDirties);
        }
        return holder.getResultsArray();
    }

    private static void checkMethodModeOnClass(ProblemsHolder holder, SpringTestingDirtiesContext dirtiesContext) {
        PsiAnnotationMemberValue psiElement;
        PsiElement sourcePsi;
        JamEnumAttributeElement methodModeElement = dirtiesContext.getMethodModeElement();
        if (methodModeElement.getValue() != null && (sourcePsi = SpringUastInspectionUtil.INSTANCE.convertToSourcePsi((PsiElement)(psiElement = methodModeElement.getPsiElement()))) != null) {
            holder.registerProblem(sourcePsi, SpringBundle.message("spring.testing.model.dirties.method.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkClassModeOnMethod(ProblemsHolder holder, SpringTestingDirtiesContext methodDirties) {
        PsiAnnotationMemberValue psiElement;
        PsiElement sourcePsi;
        JamEnumAttributeElement methodModeElement = methodDirties.getClassModeElement();
        if (methodModeElement.getValue() != null && (sourcePsi = SpringUastInspectionUtil.INSTANCE.convertToSourcePsi((PsiElement)(psiElement = methodModeElement.getPsiElement()))) != null) {
            holder.registerProblem(sourcePsi, SpringBundle.message("spring.testing.model.dirties.class.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkHierarchyMode(@Nullable PsiClass aClass, ProblemsHolder holder, @NotNull SpringTestingDirtiesContext dirtiesContext) {
        PsiAnnotationMemberValue psiElement;
        PsiElement sourcePsi;
        if (dirtiesContext == null) {
            SpringTestingDirtiesContextInspection.$$$reportNull$$$0(2);
        }
        if (aClass == null) {
            return;
        }
        JamEnumAttributeElement hierarchyModeElement = dirtiesContext.getHierarchyModeElement();
        if (hierarchyModeElement.getValue() != null && SpringContextHierarchy.META.getJamElement((PsiModifierListOwner)aClass) == null && (sourcePsi = SpringUastInspectionUtil.INSTANCE.convertToSourcePsi((PsiElement)(psiElement = hierarchyModeElement.getPsiElement()))) != null) {
            holder.registerProblem(sourcePsi, SpringBundle.message("spring.testing.model.dirties.hierarchy.mode.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtiesContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/jam/testContexts/SpringTestingDirtiesContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkHierarchyMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

