/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables;

import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridListModelBase;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridModelWithNestedTables;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.MultiPageModel;
import com.intellij.database.datagrid.MultiPageModelImpl;
import com.intellij.database.datagrid.NestedTableGridPagingModel;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.database.datagrid.NestedTablesSortingModel;
import com.intellij.database.run.ui.grid.GridModelUpdater;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridStorageAndModelUpdater;
import com.intellij.database.run.ui.grid.HierarchicalGridStorageAndModelUpdater;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.tables.DSFilteringModel;
import com.intellij.scientific.tables.DSGridLoader;
import com.intellij.scientific.tables.DSSortingModel;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.filters.FilterExpression;
import com.intellij.scientific.tables.nestedTable.NestedTablesAwareGridLoaderImpl;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001cH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001cH\u0016J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001fH\u0016J\b\u0010 \u001a\u00020\u0016H\u0016J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0018H\u0016J\u0006\u0010\"\u001a\u00020\u001aJ\b\u0010#\u001a\u00020\u001aH\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\n\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J,\u0010(\u001a\u00020\u00142\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002JD\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00122\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-J\b\u0010.\u001a\u0004\u0018\u00010-R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00030\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/scientific/tables/DSDataHookUp;", "Lcom/intellij/database/datagrid/GridDataHookUpBase;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "project", "Lcom/intellij/openapi/project/Project;", "enableHierarchicalSupport", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "model", "Lcom/intellij/database/datagrid/GridListModelBase;", "mutationModel", "Lcom/intellij/database/run/ui/grid/GridMutationModel;", "topLevelPageModel", "Lcom/intellij/database/datagrid/MultiPageModelImpl;", "kotlin.jvm.PlatformType", "pageModel", "Lcom/intellij/database/datagrid/MultiPageModel;", "modelUpdater", "Lcom/intellij/database/run/ui/grid/GridModelUpdater;", "loader", "Lcom/intellij/scientific/tables/DSGridLoader;", "sortingModel", "Lcom/intellij/database/datagrid/GridSortingModel;", "filteringModel", "Lcom/intellij/scientific/tables/DSFilteringModel;", "getMutationModel", "Lcom/intellij/database/datagrid/GridModel;", "getDataModel", "getPageModel", "Lcom/intellij/database/datagrid/GridPagingModel;", "getLoader", "getSortingModel", "getDSFilteringModel", "createFilteringModel", "createNestedTableLoaderIfNeeded", "createNestedTablesSortingModelIfNeeded", "wrapIntoHierarchicalModelIfNeeded", "Lcom/intellij/database/datagrid/DataGridListModel;", "createHierarchicalModelUpdaterIfNeeded", "createNestedTablesPagingModelWrapperIfNeeded", "logToHistoryFiltering", "", "appliedFilters", "Lcom/intellij/scientific/tables/api/filters/FilterExpression;", "getFilteringFromHistory", "intellij.scientific.tables"})
public final class DSDataHookUp
extends GridDataHookUpBase<GridRow, GridColumn> {
    @NotNull
    private final GridListModelBase<GridRow, GridColumn> model;
    @NotNull
    private final GridMutationModel mutationModel;
    @NotNull
    private final MultiPageModelImpl<GridRow, GridColumn> topLevelPageModel;
    @NotNull
    private final MultiPageModel<GridRow, GridColumn> pageModel;
    @NotNull
    private final GridModelUpdater modelUpdater;
    @NotNull
    private final DSGridLoader loader;
    @NotNull
    private final GridSortingModel<GridRow, GridColumn> sortingModel;
    @NotNull
    private final DSFilteringModel filteringModel;

    public DSDataHookUp(@NotNull Project project, boolean enableHierarchicalSupport) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.model = this.wrapIntoHierarchicalModelIfNeeded(new DataGridListModel(GridCellEditorHelper::areValuesEqual), enableHierarchicalSupport);
        this.mutationModel = new GridMutationModel((GridDataHookUp)this);
        this.topLevelPageModel = new MultiPageModelImpl((GridModel)this.mutationModel, null);
        this.pageModel = this.createNestedTablesPagingModelWrapperIfNeeded(this.model, (MultiPageModel<GridRow, GridColumn>)((MultiPageModel)this.topLevelPageModel), enableHierarchicalSupport);
        this.modelUpdater = this.createHierarchicalModelUpdaterIfNeeded(this.model, this.mutationModel, project);
        this.loader = this.createNestedTableLoaderIfNeeded(enableHierarchicalSupport);
        this.sortingModel = this.createNestedTablesSortingModelIfNeeded(enableHierarchicalSupport);
        this.filteringModel = this.createFilteringModel();
    }

    public /* synthetic */ DSDataHookUp(Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(project, bl);
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getMutationModel() {
        return (GridModel)this.mutationModel;
    }

    @NotNull
    public GridModel<GridRow, GridColumn> getDataModel() {
        return (GridModel)this.model;
    }

    @NotNull
    public GridPagingModel<GridRow, GridColumn> getPageModel() {
        return (GridPagingModel)this.pageModel;
    }

    @NotNull
    public DSGridLoader getLoader() {
        return this.loader;
    }

    @NotNull
    public GridSortingModel<GridRow, GridColumn> getSortingModel() {
        return this.sortingModel;
    }

    @NotNull
    public final DSFilteringModel getDSFilteringModel() {
        return this.filteringModel;
    }

    private final DSFilteringModel createFilteringModel() {
        return new DSFilteringModel(this.loader, (GridModel<GridRow, GridColumn>)((GridModel)this.model));
    }

    private final DSGridLoader createNestedTableLoaderIfNeeded(boolean enableHierarchicalSupport) {
        return enableHierarchicalSupport ? (DSGridLoader)new NestedTablesAwareGridLoaderImpl(this, this.pageModel, this.modelUpdater, null, 8, null) : new DSGridLoader(this, this.pageModel, this.modelUpdater, null, 8, null);
    }

    private final GridSortingModel<GridRow, GridColumn> createNestedTablesSortingModelIfNeeded(boolean enableHierarchicalSupport) {
        return enableHierarchicalSupport ? (GridSortingModel)new NestedTablesSortingModel(() -> DSDataHookUp.createNestedTablesSortingModelIfNeeded$lambda$0(this)) : (GridSortingModel)new DSSortingModel((Function0<? extends DSTableDataRetrieverFromDataSource>)((Function0)() -> DSDataHookUp.createNestedTablesSortingModelIfNeeded$lambda$1(this)));
    }

    private final GridListModelBase<GridRow, GridColumn> wrapIntoHierarchicalModelIfNeeded(DataGridListModel model, boolean enableHierarchicalSupport) {
        return enableHierarchicalSupport ? (GridListModelBase)new HierarchicalColumnsDataGridModel((GridListModelBase)new NestedTablesDataGridModel((GridListModelBase)model)) : (GridListModelBase)model;
    }

    private final GridModelUpdater createHierarchicalModelUpdaterIfNeeded(GridListModelBase<GridRow, GridColumn> model, GridMutationModel mutationModel, Project project) {
        return model instanceof HierarchicalColumnsDataGridModel ? (GridModelUpdater)new HierarchicalGridStorageAndModelUpdater((HierarchicalColumnsDataGridModel)model, mutationModel, null, project) : (GridModelUpdater)new GridStorageAndModelUpdater(model, mutationModel, null);
    }

    private final MultiPageModel<GridRow, GridColumn> createNestedTablesPagingModelWrapperIfNeeded(GridListModelBase<GridRow, GridColumn> model, MultiPageModel<GridRow, GridColumn> pageModel, boolean enableHierarchicalSupport) {
        MultiPageModel multiPageModel;
        if (enableHierarchicalSupport) {
            Intrinsics.checkNotNull(model, (String)"null cannot be cast to non-null type com.intellij.database.datagrid.GridModelWithNestedTables");
            multiPageModel = (MultiPageModel)new NestedTableGridPagingModel((GridModelWithNestedTables)model, pageModel);
        } else {
            multiPageModel = pageModel;
        }
        return multiPageModel;
    }

    public final void logToHistoryFiltering(@Nullable FilterExpression appliedFilters) {
        this.filteringModel.logFilterToHistory(appliedFilters);
    }

    @Nullable
    public final FilterExpression getFilteringFromHistory() {
        return this.filteringModel.getPreviousFilterOrNull();
    }

    private static final DSTableDataRetrieverFromDataSource createNestedTablesSortingModelIfNeeded$lambda$0$0(DSDataHookUp this$0) {
        return this$0.loader.getTableDataRetrieverFromDataSource();
    }

    private static final DSSortingModel createNestedTablesSortingModelIfNeeded$lambda$0(DSDataHookUp this$0) {
        return new DSSortingModel((Function0<? extends DSTableDataRetrieverFromDataSource>)((Function0)() -> DSDataHookUp.createNestedTablesSortingModelIfNeeded$lambda$0$0(this$0)));
    }

    private static final DSTableDataRetrieverFromDataSource createNestedTablesSortingModelIfNeeded$lambda$1(DSDataHookUp this$0) {
        return this$0.loader.getTableDataRetrieverFromDataSource();
    }
}

