/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.util.SystemInfoRt;
import java.util.function.Supplier;

public abstract class RemoteDesktopService {
    private static final Supplier<RemoteDesktopService> ourInstance = CachedSingletonsRegistry.lazy(() -> (RemoteDesktopService)ApplicationManager.getApplication().getService(RemoteDesktopService.class));

    public static RemoteDesktopService getInstance() {
        return ourInstance.get();
    }

    public static boolean isRemoteSession() {
        if (!SystemInfoRt.isWindows) {
            return false;
        }
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred() || ApplicationManager.getApplication() == null) {
            return false;
        }
        RemoteDesktopService instance2 = RemoteDesktopService.getInstance();
        return instance2 != null && instance2.isRemoteDesktopConnected();
    }

    public abstract boolean isRemoteDesktopConnected();
}

