/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeymapManager {
    public static final String DEFAULT_IDEA_KEYMAP = "$default";
    public static final String MAC_OS_X_KEYMAP = "Mac OS X";
    public static final String MAC_OS_X_10_5_PLUS_KEYMAP = "Mac OS X 10.5+";
    public static final String X_WINDOW_KEYMAP = "Default for XWin";
    public static final String KDE_KEYMAP = "Default for KDE";
    public static final String GNOME_KEYMAP = "Default for GNOME";
    private static volatile KeymapManager INSTANCE;

    @NotNull
    public abstract Keymap getActiveKeymap();

    @Nullable
    public abstract Keymap getKeymap(@NotNull String var1);

    public static KeymapManager getInstance() {
        Application app = ApplicationManager.getApplication();
        if (app == null || !LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred()) {
            return null;
        }
        KeymapManager instance2 = INSTANCE;
        if (instance2 == null) {
            INSTANCE = instance2 = (KeymapManager)app.getService(KeymapManager.class);
        }
        return instance2;
    }

    @Deprecated(forRemoval=true)
    public abstract void removeKeymapManagerListener(@NotNull KeymapManagerListener var1);
}

