/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.FileSaverRunnable;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentWithBrowseButton<Comp extends JComponent>
extends JPanel
implements Disposable {
    private final Comp myComponent;
    private final FixedSizeButton myBrowseButton;
    private final ExtendableTextComponent.Extension myInlineButtonExtension;
    private boolean myButtonEnabled;
    private KeyEvent myCurrentEvent;

    public ComponentWithBrowseButton(@NotNull Comp component, @Nullable ActionListener browseActionListener) {
        if (component == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(0);
        }
        super(new BorderLayout(SystemInfo.isMac || StartupUiUtil.isUnderDarcula() ? 0 : 2, 0));
        this.myButtonEnabled = true;
        this.myCurrentEvent = null;
        this.myComponent = component;
        this.setFocusable(false);
        boolean inlineBrowseButton = this.myComponent instanceof ExtendableTextComponent;
        if (inlineBrowseButton) {
            this.myInlineButtonExtension = ExtendableTextComponent.Extension.create(this.getDefaultIcon(), this.getHoveredIcon(), this.getIconTooltip(), true, this::notifyActionListeners);
            ((ExtendableTextComponent)this.myComponent).addExtension(this.myInlineButtonExtension);
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ComponentWithBrowseButton.this.notifyActionListeners();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/ui/ComponentWithBrowseButton$1", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), this.myComponent);
        } else {
            this.myInlineButtonExtension = null;
        }
        this.add((Component)this.myComponent, "Center");
        this.myBrowseButton = new FixedSizeButton((JComponent)this.myComponent);
        if (this.isBackgroundSet()) {
            this.myBrowseButton.setBackground(this.getBackground());
        }
        if (browseActionListener != null) {
            this.myBrowseButton.addActionListener(browseActionListener);
        }
        if (!inlineBrowseButton) {
            this.add((Component)this.myBrowseButton, "East");
        }
        this.myBrowseButton.setToolTipText(this.getIconTooltip());
        if (ApplicationManager.getApplication() != null) {
            new MyDoClickAction(this.myBrowseButton).registerShortcut((JComponent)this.myComponent);
        }
        if (ScreenReader.isActive()) {
            this.myBrowseButton.setFocusable(true);
            this.myBrowseButton.getAccessibleContext().setAccessibleName(UIBundle.message("component.with.browse.button.accessible.name", new Object[0]));
        } else if (Registry.is((String)"ide.browse.button.always.focusable", (boolean)false)) {
            this.myBrowseButton.setFocusable(true);
        }
        LazyDisposable.installOn(this);
        Insets insets = ((JComponent)this.myComponent).getInsets();
        if (!inlineBrowseButton) {
            insets.right = this.myBrowseButton.getInsets().right;
        }
        UnscaledGaps visualPaddings = UnscaledGapsKt.toUnscaledGaps(insets);
        this.putClientProperty((Object)DslComponentProperty.INTERACTIVE_COMPONENT, component);
        this.putClientProperty((Object)DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
        this.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, visualPaddings);
    }

    @NotNull
    protected Icon getDefaultIcon() {
        Icon icon = AllIcons.General.OpenDisk;
        if (icon == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    protected Icon getHoveredIcon() {
        Icon icon = AllIcons.General.OpenDiskHover;
        if (icon == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NlsContexts.Tooltip
    @NotNull
    protected String getIconTooltip() {
        return ComponentWithBrowseButton.getTooltip();
    }

    @NlsContexts.Tooltip
    @NotNull
    public static String getTooltip() {
        String string = UIBundle.message("component.with.browse.button.browse.button.tooltip.text", new Object[0]) + " (" + KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(10, 64)) + ")";
        if (string == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void notifyActionListeners() {
        ActionEvent event = new ActionEvent(this.myComponent, 1001, "action");
        for (ActionListener listener2 : this.myBrowseButton.getActionListeners()) {
            try (AccessToken ignore = SlowOperations.startSection((String)"action.perform");){
                listener2.actionPerformed(event);
            }
        }
    }

    @NotNull
    public final Comp getChildComponent() {
        Comp Comp = this.myComponent;
        if (Comp == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(4);
        }
        return Comp;
    }

    public void setTextFieldPreferredWidth(int charCount) {
        Comp comp = this.getChildComponent();
        Dimension size = GuiUtils.getSizeByChars(charCount, comp);
        ((JComponent)comp).setPreferredSize(size);
        Dimension preferredSize = this.myBrowseButton.getPreferredSize();
        boolean keepHeight = UIUtil.isUnderWin10LookAndFeel();
        preferredSize.setSize(size.width + preferredSize.width + 2, keepHeight ? preferredSize.height : preferredSize.height + 2);
        this.setPreferredSize(preferredSize);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myBrowseButton.setEnabled(enabled && this.myButtonEnabled);
        ((JComponent)this.myComponent).setEnabled(enabled);
    }

    public void setButtonEnabled(boolean buttonEnabled) {
        this.myButtonEnabled = buttonEnabled;
        this.setEnabled(this.isEnabled());
    }

    public void setButtonVisible(boolean buttonVisible) {
        this.myBrowseButton.setVisible(buttonVisible);
        if (this.myInlineButtonExtension != null && this.myComponent instanceof ExtendableTextComponent) {
            if (buttonVisible) {
                ((ExtendableTextComponent)this.myComponent).addExtension(this.myInlineButtonExtension);
            } else {
                ((ExtendableTextComponent)this.myComponent).removeExtension(this.myInlineButtonExtension);
            }
        }
    }

    public void setButtonIcon(@NotNull Icon icon) {
        if (icon == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(5);
        }
        this.myBrowseButton.setIcon(icon);
        this.myBrowseButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.myBrowseButton != null) {
            this.myBrowseButton.setBackground(color);
        }
    }

    public void addActionListener(ActionListener listener2) {
        this.myBrowseButton.addActionListener(listener2);
    }

    public void removeActionListener(ActionListener listener2) {
        this.myBrowseButton.removeActionListener(listener2);
    }

    public void addBrowseFolderListener(@Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<? super Comp> accessor) {
        this.addActionListener(new BrowseFolderActionListener<Comp>(this, project, fileChooserDescriptor, accessor));
    }

    public void addFileSaverDialog(@Nullable Project project, @NotNull FileSaverDescriptor descriptor2, TextComponentAccessor<? super Comp> accessor) {
        if (descriptor2 == null) {
            ComponentWithBrowseButton.$$$reportNull$$$0(6);
        }
        this.addActionListener(new FileSaverRunnable<Comp>(project, descriptor2, this.getChildComponent(), accessor));
    }

    @Deprecated(forRemoval=true)
    public void addBrowseFolderListener(@NlsContexts.DialogTitle @Nullable String title, @NlsContexts.Label @Nullable String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<? super Comp> accessor) {
        this.addBrowseFolderListener(project, fileChooserDescriptor.withTitle(title).withDescription(description), accessor);
    }

    @Deprecated(forRemoval=true)
    public void addBrowseFolderListener(@NlsContexts.DialogTitle @Nullable String title, @NlsContexts.Label @Nullable String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<? super Comp> accessor, boolean autoRemoveOnHide) {
        this.addBrowseFolderListener(title, description, project, fileChooserDescriptor, accessor);
    }

    @Deprecated(forRemoval=true)
    public void addBrowseFolderListener(@Nullable Project project, BrowseFolderActionListener<Comp> actionListener) {
        this.addActionListener(actionListener);
    }

    public void dispose() {
        ActionListener[] listeners;
        for (ActionListener listener2 : listeners = this.myBrowseButton.getActionListeners()) {
            this.myBrowseButton.removeActionListener(listener2);
        }
    }

    @Deprecated(forRemoval=true)
    public FixedSizeButton getButton() {
        return this.myBrowseButton;
    }

    @Override
    public final void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myComponent, true));
    }

    @Override
    public final void setNextFocusableComponent(Component aComponent) {
        super.setNextFocusableComponent(aComponent);
        ((JComponent)this.myComponent).setNextFocusableComponent(aComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (condition == 0 && this.myCurrentEvent != e) {
            try {
                this.myCurrentEvent = e;
                ((Component)this.myComponent).dispatchEvent(e);
            }
            finally {
                this.myCurrentEvent = null;
            }
        }
        if (e.isConsumed()) {
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/ComponentWithBrowseButton";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/ComponentWithBrowseButton";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHoveredIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setButtonIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFileSaverDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static final class MyDoClickAction
    extends DumbAwareAction {
        private final FixedSizeButton myBrowseButton;

        public MyDoClickAction(FixedSizeButton browseButton) {
            this.myBrowseButton = browseButton;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyDoClickAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDoClickAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myBrowseButton.isVisible() && this.myBrowseButton.isEnabled());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDoClickAction.$$$reportNull$$$0(2);
            }
            this.myBrowseButton.doClick();
        }

        public void registerShortcut(JComponent textField) {
            CustomShortcutSet shiftEnter = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64));
            this.registerCustomShortcutSet((ShortcutSet)shiftEnter, textField);
            this.myBrowseButton.setToolTipText(KeymapUtil.getShortcutsText(shiftEnter.getShortcuts()));
        }

        public static void addTo(FixedSizeButton browseButton, JComponent aComponent) {
            new MyDoClickAction(browseButton).registerShortcut(aComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/ui/ComponentWithBrowseButton$MyDoClickAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/ui/ComponentWithBrowseButton$MyDoClickAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class LazyDisposable
    implements Activatable {
        private final WeakReference<ComponentWithBrowseButton<?>> reference;

        private LazyDisposable(ComponentWithBrowseButton<?> component) {
            this.reference = new WeakReference(component);
        }

        private static void installOn(ComponentWithBrowseButton<?> component) {
            LazyDisposable disposable = new LazyDisposable(component);
            UiNotifyConnector.Once.installOn(component, (Activatable)disposable);
        }

        public void showNotify() {
            Disposable disposable;
            DataManager dataManager;
            ComponentWithBrowseButton component = (ComponentWithBrowseButton)this.reference.get();
            if (component == null) {
                return;
            }
            Application app = ApplicationManager.getApplication();
            if (app != null && (dataManager = (DataManager)app.getServiceIfCreated(DataManager.class)) != null && (disposable = (Disposable)PlatformDataKeys.UI_DISPOSABLE.getData(dataManager.getDataContext((Component)component))) != null) {
                Disposer.register((Disposable)disposable, (Disposable)component);
            }
        }
    }

    public static class BrowseFolderActionListener<T extends JComponent>
    extends BrowseFolderRunnable<T>
    implements ActionListener {
        public BrowseFolderActionListener(@Nullable ComponentWithBrowseButton<T> textField, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<? super T> accessor) {
            super(project, fileChooserDescriptor, textField != null ? (Object)textField.getChildComponent() : null, accessor);
        }

        @Deprecated(forRemoval=true)
        public BrowseFolderActionListener(@NlsContexts.DialogTitle @Nullable String title, @NlsContexts.Label @Nullable String description, @Nullable ComponentWithBrowseButton<T> textField, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<? super T> accessor) {
            this(textField, project, fileChooserDescriptor.withTitle(title).withDescription(description), accessor);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }
}

