/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Graphics;
import javax.accessibility.AccessibleContext;
import javax.swing.JPasswordField;
import org.jetbrains.annotations.NotNull;

public class JBPasswordField
extends JPasswordField
implements ComponentWithEmptyText {
    private final TextComponentEmptyText myEmptyText = new TextComponentEmptyText(this, false);

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myEmptyText.paintStatusText(g);
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        TextComponentEmptyText textComponentEmptyText = this.myEmptyText;
        if (textComponentEmptyText == null) {
            JBPasswordField.$$$reportNull$$$0(0);
        }
        return textComponentEmptyText;
    }

    public void setPasswordIsStored(boolean stored) {
        if (stored) {
            this.myEmptyText.setText(IdeBundle.message("text.password.hidden", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            this.myEmptyText.clear();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJBPasswordField();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBPasswordField", "getEmptyText"));
    }

    private class AccessibleJBPasswordField
    extends JPasswordField.AccessibleJPasswordField {
        private AccessibleJBPasswordField() {
            super(JBPasswordField.this);
        }

        @Override
        public String getAccessibleDescription() {
            String emptyText;
            String description = super.getAccessibleDescription();
            if (description == null && StringUtil.isEmpty((String)new String(JBPasswordField.this.getPassword())) && !(emptyText = JBPasswordField.this.myEmptyText.toString()).isEmpty()) {
                return AccessibleContextUtil.getUniqueDescription((AccessibleContext)this, (String)emptyText);
            }
            return description;
        }
    }
}

