/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.UiDslException;
import com.intellij.ui.dsl.gridLayout.impl.ColumnInfo;
import com.intellij.ui.dsl.gridLayout.impl.ColumnsSizeCalculator;
import com.intellij.ui.dsl.gridLayout.impl.ColumnsSizeCalculatorKt;
import com.intellij.ui.dsl.gridLayout.impl.SizeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0017\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ/\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J5\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\tJ\u0014\u0010\u001b\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J\u0006\u0010\u001c\u001a\u00020\u000bJ\"\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002JL\u0010\u001e\u001a\u00020\t2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u00182\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u00052\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010!\u001a\u00020\u000bH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J/\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010$\u001a\u00020\u000b2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002\u00a2\u0006\u0002\u0010&JG\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010*J!\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020\u000bH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator;", "", "<init>", "()V", "sizes", "", "Lcom/intellij/ui/dsl/gridLayout/impl/ColumnInfo;", "Lcom/intellij/ui/dsl/gridLayout/impl/SizeInfo;", "addConstraint", "", "x", "", "width", "minSize", "prefSize", "calculateCoords", "", "resizableColumns", "", "respectMinimumSize", "", "(ILjava/util/Set;Z)[Ljava/lang/Integer;", "calculateWidths", "resizableVisibleColumns", "", "(Ljava/util/Set;Ljava/util/Map;)[Ljava/lang/Integer;", "reset", "calculateMinimumSize", "calculatePreferredSize", "mapSizesToMinimumSizes", "removeFirstColumn", "sizesFirstColumn", "sizesWithoutFirstColumn", "firstColumnMinWidth", "getVisibleColumns", "calculateMinCoords", "dimension", "columnsInfo", "(ILjava/util/Map;)[Ljava/lang/Integer;", "calculateResizedWidths", "minimumSizeWidths", "preferredSizeWidths", "([Ljava/lang/Integer;[Ljava/lang/Integer;Ljava/util/Set;I)[Ljava/lang/Integer;", "createCoordsFromWidths", "widths", "([Ljava/lang/Integer;)[Ljava/lang/Integer;", "getDimension", "intellij.platform.ide"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nColumnsSizeCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnsSizeCalculator.kt\ncom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n466#2:267\n415#2:268\n466#2:273\n415#2:274\n466#2:279\n415#2:280\n1266#3,4:269\n1266#3,4:275\n1266#3,4:281\n777#3:286\n873#3,2:287\n1#4:285\n*S KotlinDebug\n*F\n+ 1 ColumnsSizeCalculator.kt\ncom/intellij/ui/dsl/gridLayout/impl/ColumnsSizeCalculator\n*L\n35#1:267\n35#1:268\n121#1:273\n121#1:274\n129#1:279\n129#1:280\n35#1:269,4\n121#1:275,4\n129#1:281,4\n204#1:286\n204#1:287,2\n*E\n"})
public final class ColumnsSizeCalculator {
    @NotNull
    private final Map<ColumnInfo, SizeInfo> sizes = new LinkedHashMap();

    public final void addConstraint(int x, int width, int minSize, int prefSize) {
        ColumnInfo key = new ColumnInfo(x, width);
        SizeInfo existingSizeInfo = this.sizes.get(key);
        this.sizes.put(key, ColumnsSizeCalculatorKt.access$max(existingSizeInfo, minSize, prefSize));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Integer[] calculateCoords(int width, @NotNull Set<Integer> resizableColumns, boolean respectMinimumSize) {
        Map map;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter(resizableColumns, (String)"resizableColumns");
        if (this.sizes.isEmpty()) {
            Integer[] integerArray = new Integer[]{0};
            return integerArray;
        }
        Set resizableVisibleColumns = CollectionsKt.intersect((Iterable)resizableColumns, (Iterable)this.getVisibleColumns());
        Map<ColumnInfo, SizeInfo> map2 = this.sizes;
        Set set = resizableVisibleColumns;
        ColumnsSizeCalculator columnsSizeCalculator = this;
        boolean $i$f$mapValues = false;
        void var8_10 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map3;
            boolean bl2 = false;
            Integer n = ((SizeInfo)it.getValue()).getPrefSize();
            map.put(k, n);
        }
        map = destination$iv$iv$iv;
        Integer[] preferredSizeWidths = columnsSizeCalculator.calculateWidths(set, map);
        Integer[] minimumSizeWidths = respectMinimumSize ? this.calculateWidths(resizableVisibleColumns, this.mapSizesToMinimumSizes(resizableVisibleColumns)) : null;
        return this.createCoordsFromWidths(this.calculateResizedWidths(minimumSizeWidths, preferredSizeWidths, resizableVisibleColumns, width));
    }

    private final Integer[] calculateWidths(Set<Integer> resizableVisibleColumns, Map<ColumnInfo, Integer> sizes) {
        int dimension = this.getDimension();
        Set<Integer> visibleColumns = this.getVisibleColumns();
        int n = 0;
        Integer[] integerArray = new Integer[dimension];
        while (n < dimension) {
            int n2 = n++;
            integerArray[n2] = 0;
        }
        Integer[] result2 = integerArray;
        Map remainedSizes = sizes;
        Set remainedResizableColumns = CollectionsKt.toMutableSet((Iterable)resizableVisibleColumns);
        for (int i = 0; i < dimension; ++i) {
            if (visibleColumns.contains(i)) {
                Object[] minCoords = this.calculateMinCoords(dimension - i, remainedSizes);
                int firstColumnMinWidth = minCoords[1];
                Map sizesFirstColumn = new LinkedHashMap();
                Map sizesWithoutFirstColumn = new LinkedHashMap();
                this.removeFirstColumn(remainedSizes, sizesFirstColumn, sizesWithoutFirstColumn, firstColumnMinWidth);
                Object[] nextMinCoords = this.calculateMinCoords(dimension - i - 1, sizesWithoutFirstColumn);
                int firstColumnMaxWidth = ((Number)ArraysKt.last((Object[])minCoords)).intValue() - ((Number)ArraysKt.last((Object[])nextMinCoords)).intValue();
                int columnWidthCorrection = remainedResizableColumns.remove(i) ? (firstColumnMaxWidth - firstColumnMinWidth) / (remainedResizableColumns.size() + 1) : 0;
                for (Map.Entry entry : sizesFirstColumn.entrySet()) {
                    ColumnInfo columnInfo = (ColumnInfo)entry.getKey();
                    int size = ((Number)entry.getValue()).intValue();
                    Map map = sizesWithoutFirstColumn;
                    Integer n3 = (Integer)sizesWithoutFirstColumn.get(columnInfo);
                    int n4 = n3 != null ? n3 : 0;
                    int n5 = size - columnWidthCorrection;
                    Integer n6 = Math.max(n4, n5);
                    map.put(columnInfo, n6);
                }
                remainedSizes = sizesWithoutFirstColumn;
                result2[i] = firstColumnMinWidth + columnWidthCorrection;
                continue;
            }
            Map sizesFirstColumn = new LinkedHashMap();
            Map sizesWithoutFirstColumn = new LinkedHashMap();
            this.removeFirstColumn(remainedSizes, sizesFirstColumn, sizesWithoutFirstColumn, 0);
            if (!sizesFirstColumn.isEmpty()) {
                throw new UiDslException(null, null, 3, null);
            }
            remainedSizes = sizesWithoutFirstColumn;
            result2[i] = 0;
        }
        if (!remainedSizes.isEmpty()) {
            throw new UiDslException(null, null, 3, null);
        }
        if (!((Collection)remainedResizableColumns).isEmpty()) {
            throw new UiDslException(null, null, 3, null);
        }
        return result2;
    }

    public final void reset() {
        this.sizes.clear();
    }

    public final int calculateMinimumSize(@NotNull Set<Integer> resizableColumns) {
        Intrinsics.checkNotNullParameter(resizableColumns, (String)"resizableColumns");
        if (this.sizes.isEmpty()) {
            return 0;
        }
        Set resizableVisibleColumns = CollectionsKt.intersect((Iterable)resizableColumns, (Iterable)this.getVisibleColumns());
        Object[] minCoords = this.calculateMinCoords(this.getDimension(), this.mapSizesToMinimumSizes(resizableVisibleColumns));
        return ((Number)ArraysKt.last((Object[])minCoords)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final int calculatePreferredSize() {
        Map map;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        if (this.sizes.isEmpty()) {
            return 0;
        }
        Map<ColumnInfo, SizeInfo> map2 = this.sizes;
        int n = this.getDimension();
        ColumnsSizeCalculator columnsSizeCalculator = this;
        boolean $i$f$mapValues = false;
        void var4_5 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map3;
            boolean bl2 = false;
            Integer n2 = ((SizeInfo)it.getValue()).getPrefSize();
            map.put(k, n2);
        }
        map = destination$iv$iv$iv;
        Object[] minCoords = columnsSizeCalculator.calculateMinCoords(n, map);
        return ((Number)ArraysKt.last((Object[])minCoords)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ColumnInfo, Integer> mapSizesToMinimumSizes(Set<Integer> resizableVisibleColumns) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<ColumnInfo, SizeInfo> $this$mapValues$iv = this.sizes;
        boolean $i$f$mapValues = false;
        Map<ColumnInfo, SizeInfo> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            boolean resizable = false;
            int n = ((ColumnInfo)it.getKey()).getWidth();
            for (int i = 0; i < n; ++i) {
                if (!resizableVisibleColumns.contains(((ColumnInfo)it.getKey()).getX() + i)) continue;
                resizable = true;
                break;
            }
            Integer n2 = resizable ? ((SizeInfo)it.getValue()).getMinSize() : ((SizeInfo)it.getValue()).getPrefSize();
            map3.put(k, n2);
        }
        return destination$iv$iv$iv;
    }

    private final void removeFirstColumn(Map<ColumnInfo, Integer> sizes, Map<ColumnInfo, Integer> sizesFirstColumn, Map<ColumnInfo, Integer> sizesWithoutFirstColumn, int firstColumnMinWidth) {
        for (Map.Entry<ColumnInfo, Integer> entry : sizes.entrySet()) {
            Integer n;
            Map<ColumnInfo, Integer> map;
            ColumnInfo index;
            ColumnInfo columnInfo = entry.getKey();
            int size = ((Number)entry.getValue()).intValue();
            if (columnInfo.getX() == 0) {
                if (columnInfo.getWidth() <= 1) continue;
                index = new ColumnInfo(0, columnInfo.getWidth() - 1);
                map = sizesFirstColumn;
                Integer n2 = sizesFirstColumn.get(index);
                int n3 = n2 != null ? n2 : 0;
                int n4 = size - firstColumnMinWidth;
                n = Math.max(n3, n4);
                map.put(index, n);
                continue;
            }
            index = new ColumnInfo(columnInfo.getX() - 1, columnInfo.getWidth());
            map = sizesWithoutFirstColumn;
            Integer n5 = sizesWithoutFirstColumn.get(index);
            n = Math.max(n5 != null ? n5 : 0, size);
            map.put(index, n);
        }
    }

    private final Set<Integer> getVisibleColumns() {
        Set result2 = new LinkedHashSet();
        for (ColumnInfo columnInfo : this.sizes.keySet()) {
            CollectionsKt.addAll((Collection)result2, (Iterable)((Iterable)RangesKt.until((int)columnInfo.getX(), (int)(columnInfo.getX() + columnInfo.getWidth()))));
        }
        return result2;
    }

    private final Integer[] calculateMinCoords(int dimension, Map<ColumnInfo, Integer> columnsInfo) {
        int n = 0;
        int n2 = dimension + 1;
        Object[] object2 = new Integer[n2];
        while (n < n2) {
            int n3 = n++;
            object2[n3] = 0;
        }
        Object[] result2 = object2;
        Comparator<Object> comparator = Comparator.comparingInt(arg_0 -> ColumnsSizeCalculator.calculateMinCoords$lambda$0((Function1)calculateMinCoords.sortedSizes.1.INSTANCE, arg_0)).thenComparingInt(arg_0 -> ColumnsSizeCalculator.calculateMinCoords$lambda$1((Function1)calculateMinCoords.sortedSizes.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparingInt(...)");
        SortedMap sortedSizes2 = MapsKt.toSortedMap(columnsInfo, comparator);
        for (Map.Entry entry : ((Map)sortedSizes2).entrySet()) {
            ColumnInfo columnInfo = (ColumnInfo)entry.getKey();
            Integer size = (Integer)entry.getValue();
            if (result2[columnInfo.getX()] == 0) {
                Object v1;
                block5: {
                    Iterable iterable = (Iterable)RangesKt.downTo((int)(columnInfo.getX() - 1), (int)0);
                    for (Object t : iterable) {
                        int it = ((Number)t).intValue();
                        boolean bl = false;
                        if (!(result2[it] > 0)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                Integer prevVisible = v1;
                if (prevVisible != null) {
                    ArraysKt.fill((Object[])result2, (Object)result2[prevVisible], (int)(prevVisible + 1), (int)(columnInfo.getX() + 1));
                }
            }
            int nextColumn = columnInfo.getX() + columnInfo.getWidth();
            int n4 = result2[columnInfo.getX()];
            Intrinsics.checkNotNull((Object)size);
            result2[nextColumn] = Math.max(n4 + size, result2[nextColumn]);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] calculateResizedWidths(Integer[] minimumSizeWidths, Integer[] preferredSizeWidths, Set<Integer> resizableVisibleColumns, int width) {
        void $this$filterTo$iv$iv;
        if (width == ArraysKt.sumOfInt((Integer[])preferredSizeWidths) || resizableVisibleColumns.isEmpty()) {
            return preferredSizeWidths;
        }
        Integer[] result2 = (Integer[])preferredSizeWidths.clone();
        Iterable $this$filter$iv = resizableVisibleColumns;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it < preferredSizeWidths.length)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List remainedResizableColumns = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        while (!remainedResizableColumns.isEmpty()) {
            int column;
            int remainedResizableColumnsCount = remainedResizableColumns.size();
            int extraSize = width - ArraysKt.sumOfInt((Integer[])result2);
            Integer minimumSizeExceededIndex = null;
            Iterator iterator = ((Iterable)remainedResizableColumns).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                column = ((Number)iterator.next()).intValue();
                int correction = extraSize / remainedResizableColumnsCount;
                --remainedResizableColumnsCount;
                extraSize -= correction;
                result2[column] = result2[column] + correction;
                if (minimumSizeWidths == null || result2[column] >= minimumSizeWidths[column]) continue;
                result2[column] = minimumSizeWidths[column];
                minimumSizeExceededIndex = index;
                break;
            }
            if (minimumSizeExceededIndex == null) break;
            iterator = ((Iterable)remainedResizableColumns).iterator();
            n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                column = ((Number)iterator.next()).intValue();
                if (index >= minimumSizeExceededIndex) break;
                result2[column] = preferredSizeWidths[column];
            }
            remainedResizableColumns.remove(minimumSizeExceededIndex);
        }
        return result2;
    }

    private final Integer[] createCoordsFromWidths(Integer[] widths) {
        int n = 0;
        int n2 = widths.length + 1;
        Integer[] integerArray = new Integer[n2];
        while (n < n2) {
            int n3 = n++;
            integerArray[n3] = 0;
        }
        Integer[] result2 = integerArray;
        n2 = widths.length;
        for (n = 0; n < n2; ++n) {
            int i = n;
            int width = widths[n];
            result2[i + 1] = result2[i] + width;
        }
        return result2;
    }

    private final int getDimension() {
        Iterator iterator = ((Iterable)this.sizes.keySet()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        ColumnInfo it = (ColumnInfo)iterator.next();
        boolean bl = false;
        int n = it.getX() + it.getWidth();
        while (iterator.hasNext()) {
            ColumnInfo it2 = (ColumnInfo)iterator.next();
            $i$a$-maxOf-ColumnsSizeCalculator$getDimension$1 = false;
            int n2 = it2.getX() + it2.getWidth();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    private static final int calculateMinCoords$lambda$0(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int calculateMinCoords$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }
}

