/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization;

import com.intellij.notebooks.visualization.CaretBasedCellSelectionModelKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000b0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/notebooks/visualization/CaretBasedCellSelectionModel;", "Lcom/intellij/notebooks/visualization/NotebookCellSelectionModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "primarySelectedCell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "getPrimarySelectedCell", "()Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "primarySelectedRegion", "", "getPrimarySelectedRegion", "()Ljava/util/List;", "selectedRegions", "getSelectedRegions", "selectedCells", "getSelectedCells", "isSelectedCell", "", "cell", "selectCell", "", "makePrimary", "removeSecondarySelections", "removeSelection", "selectSingleCell", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nCaretBasedCellSelectionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaretBasedCellSelectionModel.kt\ncom/intellij/notebooks/visualization/CaretBasedCellSelectionModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1#2:99\n1404#3:100\n1496#3,5:101\n1807#3,3:106\n*S KotlinDebug\n*F\n+ 1 CaretBasedCellSelectionModel.kt\ncom/intellij/notebooks/visualization/CaretBasedCellSelectionModel\n*L\n34#1:100\n34#1:101,5\n42#1:106,3\n*E\n"})
public final class CaretBasedCellSelectionModel
implements NotebookCellSelectionModel {
    @NotNull
    private final Editor editor;

    public CaretBasedCellSelectionModel(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @Override
    @NotNull
    public NotebookCellLines.Interval getPrimarySelectedCell() {
        return NotebookVisualizationUiUtilKt.getCell(this.editor, this.editor.getCaretModel().getPrimaryCaret().getLogicalPosition().line);
    }

    @Override
    @NotNull
    public List<NotebookCellLines.Interval> getPrimarySelectedRegion() {
        Object v0;
        block1: {
            NotebookCellLines.Interval primary = this.getPrimarySelectedCell();
            Iterable iterable = this.getSelectedRegions();
            for (Object t : iterable) {
                List it = (List)t;
                boolean bl = false;
                if (!it.contains(primary)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    @Override
    @NotNull
    public List<List<NotebookCellLines.Interval>> getSelectedRegions() {
        return NotebookVisualizationUiUtilKt.groupNeighborCells(this.getSelectedCells());
    }

    @Override
    @NotNull
    public List<NotebookCellLines.Interval> getSelectedCells() {
        NotebookCellLines notebookCellLines = NotebookCellLines.Companion.get(this.editor);
        Object object = ReadAction.compute(() -> CaretBasedCellSelectionModel._get_selectedCells_$lambda$0(this, notebookCellLines));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (List)object;
    }

    @Override
    public boolean isSelectedCell(@NotNull NotebookCellLines.Interval cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Object object = ReadAction.compute(() -> CaretBasedCellSelectionModel.isSelectedCell$lambda$0(this, cell));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    @Override
    public void selectCell(@NotNull NotebookCellLines.Interval cell, boolean makePrimary) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.editor.getCaretModel().addCaret(CaretBasedCellSelectionModelKt.access$getStartLogicalPosition(cell), makePrimary);
    }

    @Override
    public void removeSecondarySelections() {
        this.editor.getCaretModel().removeSecondaryCarets();
    }

    @Override
    public void removeSelection(@NotNull NotebookCellLines.Interval cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
            IntRange intRange = cell.getLines();
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            int n3 = caret.getLogicalPosition().line;
            boolean bl = n <= n3 ? n3 <= n2 : false;
            if (!bl) continue;
            this.editor.getCaretModel().removeCaret(caret);
        }
    }

    @Override
    public void selectSingleCell(@NotNull NotebookCellLines.Interval cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        caretModel2.getPrimaryCaret().moveToLogicalPosition(CaretBasedCellSelectionModelKt.access$getStartLogicalPosition(cell));
        caretModel2.getPrimaryCaret().removeSelection();
        caretModel2.removeSecondaryCarets();
    }

    /*
     * WARNING - void declaration
     */
    private static final List _get_selectedCells_$lambda$0(CaretBasedCellSelectionModel this$0, NotebookCellLines $notebookCellLines) {
        void $this$flatMapTo$iv$iv;
        List list = this$0.editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Caret caret = (Caret)element$iv$iv;
            boolean bl = false;
            Document document = this$0.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Intrinsics.checkNotNull((Object)caret);
            Sequence<NotebookCellLines.Interval> list$iv$iv = NotebookVisualizationUiUtilKt.getCells($notebookCellLines, CaretBasedCellSelectionModelKt.getSelectionLines(document, caret));
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private static final Boolean isSelectedCell$lambda$0(CaretBasedCellSelectionModel this$0, NotebookCellLines.Interval $cell) {
        boolean bl;
        block3: {
            List list = this$0.editor.getCaretModel().getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Caret caret = (Caret)element$iv;
                    boolean bl2 = false;
                    Document document = this$0.editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                    Intrinsics.checkNotNull((Object)caret);
                    if (!NotebookVisualizationUiUtilKt.hasIntersectionWith(CaretBasedCellSelectionModelKt.getSelectionLines(document, caret), $cell.getLines())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

