/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.EditorCellInputFactory;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.ui.CustomFoldingEditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellFoldingBar;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.InputComponent;
import com.intellij.notebooks.visualization.ui.UpdateManager;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.notebooks.visualization.ui.cellsDnD.EditorCellDragAssistant;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u000f\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000f\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!J\b\u0010#\u001a\u00020$H\u0016J\u0006\u0010%\u001a\u00020\u001cJ\u0006\u0010&\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellInput;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "getCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "component", "getComponent", "()Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "dragAssistant", "Lcom/intellij/notebooks/visualization/ui/cellsDnD/EditorCellDragAssistant;", "folding", "Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar;", "getFolding", "()Lcom/intellij/notebooks/visualization/ui/EditorCellFoldingBar;", "value", "", "folded", "getFolded", "()Z", "getFoldingBounds", "Lkotlin/Pair;", "", "toggleFolding", "", "()Lkotlin/Unit;", "fold", "unfold", "getBlockElementsInRange", "", "Lcom/intellij/openapi/editor/Inlay;", "calculateBounds", "Ljava/awt/Rectangle;", "updateInput", "requestCaret", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellInput.kt\ncom/intellij/notebooks/visualization/ui/EditorCellInput\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,89:1\n1#2:90\n1313#3,3:91\n*S KotlinDebug\n*F\n+ 1 EditorCellInput.kt\ncom/intellij/notebooks/visualization/ui/EditorCellInput\n*L\n74#1:91,3\n*E\n"})
public final class EditorCellInput
extends EditorCellViewComponent {
    @NotNull
    private final EditorCell cell;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final EditorCellViewComponent component;
    @Nullable
    private final EditorCellDragAssistant dragAssistant;
    @NotNull
    private final EditorCellFoldingBar folding;
    private boolean folded;

    /*
     * WARNING - void declaration
     */
    public EditorCellInput(@NotNull EditorCell cell) {
        Object object;
        Object it;
        EditorCellViewComponent editorCellViewComponent;
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.cell = cell;
        this.editor = this.cell.getEditor();
        EditorCellViewComponent editorCellViewComponent2 = editorCellViewComponent = EditorCellInputFactory.Companion.create(this.cell);
        EditorCellInput editorCellInput = this;
        boolean bl3 = false;
        this.add((EditorCellViewComponent)it);
        editorCellInput.component = editorCellViewComponent;
        EditorCellInput editorCellInput2 = this;
        boolean bl2 = Registry.Companion.is("jupyter.editor.dnd.cells");
        if (bl2) {
            void it2;
            EditorCellDragAssistant bl3 = it = new EditorCellDragAssistant(this.editor, this, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    EditorCellInput.access$fold((EditorCellInput)this.receiver);
                }
            }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    EditorCellInput.access$unfold((EditorCellInput)this.receiver);
                }
            }));
            editorCellInput = editorCellInput2;
            boolean bl4 = false;
            Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it2));
            editorCellInput2 = editorCellInput;
            object = it;
        } else if (!bl2) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        editorCellInput2.dragAssistant = object;
        EditorCellFoldingBar editorCellFoldingBar = new EditorCellFoldingBar(this.editor, this.dragAssistant, (Function0<Pair<Integer, Integer>>)((Function0)new Function0<Pair<? extends Integer, ? extends Integer>>((Object)this){

            public final Pair<Integer, Integer> invoke() {
                return EditorCellInput.access$getFoldingBounds((EditorCellInput)this.receiver);
            }
        }), (Function0<Unit>)((Function0)() -> EditorCellInput.folding$lambda$0(this)));
        it = editorCellFoldingBar;
        editorCellInput = this;
        boolean bl5 = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)it);
        editorCellInput.folding = editorCellFoldingBar;
    }

    @NotNull
    public final EditorCell getCell() {
        return this.cell;
    }

    @NotNull
    public final EditorCellViewComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final EditorCellFoldingBar getFolding() {
        return this.folding;
    }

    public final boolean getFolded() {
        return this.folded;
    }

    private final Pair<Integer, Integer> getFoldingBounds() {
        if (this.cell.getIntervalPointer().get() == null) {
            return new Pair((Object)0, (Object)0);
        }
        int delimiterPanelSize = this.cell.getInterval().getOrdinal() == 0 ? NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getAboveFirstCellDelimiterHeight() : NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellBorderHeight();
        Rectangle bounds = this.calculateBounds();
        return TuplesKt.to((Object)(bounds.y + delimiterPanelSize), (Object)(bounds.height - delimiterPanelSize));
    }

    private final Unit toggleFolding() {
        return (Unit)UpdateManager.update$default(UpdateManagerKt.getUpdateManager((Editor)this.editor), false, false, arg_0 -> EditorCellInput.toggleFolding$lambda$0(this, arg_0), 3, null);
    }

    private final Unit fold() {
        return (Unit)UpdateManager.update$default(UpdateManagerKt.getUpdateManager((Editor)this.editor), false, false, arg_0 -> EditorCellInput.fold$lambda$0(this, arg_0), 3, null);
    }

    private final Unit unfold() {
        return (Unit)UpdateManager.update$default(UpdateManagerKt.getUpdateManager((Editor)this.editor), false, false, arg_0 -> EditorCellInput.unfold$lambda$0(this, arg_0), 3, null);
    }

    @NotNull
    public final List<Inlay<?>> getBlockElementsInRange() {
        IntRange linesRange = this.cell.getInterval().getLines();
        int startOffset = this.editor.getDocument().getLineStartOffset(linesRange.getFirst());
        int endOffset = this.editor.getDocument().getLineEndOffset(linesRange.getLast());
        List list = this.editor.getInlayModel().getBlockElementsInRange(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlockElementsInRange(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Rectangle calculateBounds() {
        void $this$fold$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getBlockElementsInRange()), arg_0 -> EditorCellInput.calculateBounds$lambda$0(this, arg_0)), EditorCellInput::calculateBounds$lambda$1);
        Rectangle initial$iv = this.component.calculateBounds();
        boolean $i$f$fold = false;
        Rectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void i;
            Rectangle rectangle = (Rectangle)element$iv;
            Rectangle b = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)b.union((Rectangle)i), (String)"union(...)");
        }
        return accumulator$iv;
    }

    public final void updateInput() {
        ActionsKt.runInEdt$default(null, () -> EditorCellInput.updateInput$lambda$0(this), (int)1, null);
    }

    public final void requestCaret() {
        block0: {
            EditorCellViewComponent editorCellViewComponent = this.component;
            InputComponent inputComponent = editorCellViewComponent instanceof InputComponent ? (InputComponent)((Object)editorCellViewComponent) : null;
            if (inputComponent == null) break block0;
            inputComponent.requestCaret();
        }
    }

    private static final Unit folding$lambda$0(EditorCellInput this$0) {
        this$0.toggleFolding();
        return Unit.INSTANCE;
    }

    private static final Unit toggleFolding$lambda$0(EditorCellInput this$0, UpdateContext ctx) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.folded = !this$0.folded;
        EditorCellViewComponent editorCellViewComponent = this$0.component;
        InputComponent inputComponent = editorCellViewComponent instanceof InputComponent ? (InputComponent)((Object)editorCellViewComponent) : null;
        if (inputComponent != null) {
            inputComponent.updateFolding(ctx, this$0.folded);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final Unit fold$lambda$0(EditorCellInput this$0, UpdateContext ctx) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.folded = true;
        EditorCellViewComponent editorCellViewComponent = this$0.component;
        InputComponent inputComponent = editorCellViewComponent instanceof InputComponent ? (InputComponent)((Object)editorCellViewComponent) : null;
        if (inputComponent != null) {
            inputComponent.updateFolding(ctx, true);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final Unit unfold$lambda$0(EditorCellInput this$0, UpdateContext ctx) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.folded = false;
        EditorCellViewComponent editorCellViewComponent = this$0.component;
        InputComponent inputComponent = editorCellViewComponent instanceof InputComponent ? (InputComponent)((Object)editorCellViewComponent) : null;
        if (inputComponent != null) {
            inputComponent.updateFolding(ctx, false);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final boolean calculateBounds$lambda$0(EditorCellInput this$0, Inlay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getProperties().getPriority() > NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this$0.editor).getCellOutputToolbarInlayPriority();
    }

    private static final Rectangle calculateBounds$lambda$1(Inlay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getBounds();
    }

    private static final Unit updateInput$lambda$0$0(EditorCellInput this$0, UpdateContext ctx) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            EditorCellViewComponent editorCellViewComponent = this$0.component;
            InputComponent inputComponent = editorCellViewComponent instanceof InputComponent ? (InputComponent)((Object)editorCellViewComponent) : null;
            if (inputComponent != null) {
                inputComponent.updateInput(ctx);
            }
            editorCellViewComponent = this$0.component;
            CustomFoldingEditorCellViewComponent customFoldingEditorCellViewComponent = editorCellViewComponent instanceof CustomFoldingEditorCellViewComponent ? (CustomFoldingEditorCellViewComponent)editorCellViewComponent : null;
            if (customFoldingEditorCellViewComponent == null) break block1;
            customFoldingEditorCellViewComponent.updateCustomComponent();
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateInput$lambda$0(EditorCellInput this$0) {
        UpdateManager.update$default(UpdateManagerKt.getUpdateManager((Editor)this$0.editor), false, false, arg_0 -> EditorCellInput.updateInput$lambda$0$0(this$0, arg_0), 3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Unit access$fold(EditorCellInput $this) {
        return $this.fold();
    }

    public static final /* synthetic */ Unit access$unfold(EditorCellInput $this) {
        return $this.unfold();
    }

    public static final /* synthetic */ Pair access$getFoldingBounds(EditorCellInput $this) {
        return $this.getFoldingBounds();
    }
}

