/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.providers.frame;

import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellInput;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.notebooks.visualization.ui.NotebookEditorKt;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.ui.providers.frame.CellFrameState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cJ\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0006\u0010\"\u001a\u00020\u001eJ\b\u0010#\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/frame/EditorCellFrameManager;", "Lcom/intellij/openapi/Disposable;", "editorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "cellType", "Lcom/intellij/notebooks/jupyter/core/jupyter/CellType;", "getCellType", "()Lcom/intellij/notebooks/jupyter/core/jupyter/CellType;", "view", "Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "getView", "()Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "isSelected", "", "()Z", "isHovered", "state", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "Lcom/intellij/notebooks/visualization/ui/providers/frame/CellFrameState;", "getState", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "cachedRightLine", "Ljava/awt/geom/Line2D;", "dispose", "", "getOrCalculateLineFrameVerticalLine", "calculateRightLine", "Ljava/awt/geom/Line2D$Double;", "updateCellFrameShow", "updateCellFrameShowMarkdown", "updateCellFrameShowCode", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellFrameManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellFrameManager.kt\ncom/intellij/notebooks/visualization/ui/providers/frame/EditorCellFrameManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n296#2,2:149\n546#2,6:151\n1#3:157\n*S KotlinDebug\n*F\n+ 1 EditorCellFrameManager.kt\ncom/intellij/notebooks/visualization/ui/providers/frame/EditorCellFrameManager\n*L\n86#1:149,2\n89#1:151,6\n*E\n"})
public final class EditorCellFrameManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorCell editorCell;
    @NotNull
    private final AtomicProperty<CellFrameState> state;
    @Nullable
    private Line2D cachedRightLine;

    public EditorCellFrameManager(@NotNull EditorCell editorCell) {
        Intrinsics.checkNotNullParameter((Object)editorCell, (String)"editorCell");
        this.editorCell = editorCell;
        this.state = new AtomicProperty((Object)new CellFrameState(false, null, 3, null));
        NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)((ObservableProperty)this.editorCell.isSelected()), (Disposable)this, arg_0 -> EditorCellFrameManager._init_$lambda$0(this, arg_0));
        NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)((ObservableProperty)this.editorCell.isHovered()), (Disposable)this, arg_0 -> EditorCellFrameManager._init_$lambda$1(this, arg_0));
        NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)((ObservableProperty)this.editorCell.isUnfolded()), (Disposable)this, arg_0 -> EditorCellFrameManager._init_$lambda$2(this, arg_0));
        NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellFrameSelectedColor().afterChange((Disposable)this, arg_0 -> EditorCellFrameManager._init_$lambda$3(this, arg_0));
        NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellFrameHoveredColor().afterChange((Disposable)this, arg_0 -> EditorCellFrameManager._init_$lambda$4(this, arg_0));
        NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getEditorBackgroundColor().afterChange((Disposable)this, arg_0 -> EditorCellFrameManager._init_$lambda$5(this, arg_0));
        NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCodeCellBackgroundColor().afterChange((Disposable)this, arg_0 -> EditorCellFrameManager._init_$lambda$6(this, arg_0));
        JupyterBoundsChangeHandler.Companion.get((Editor)this.getEditor()).subscribe(this, () -> EditorCellFrameManager._init_$lambda$7(this));
        this.updateCellFrameShow();
    }

    private final EditorImpl getEditor() {
        return this.editorCell.getEditor();
    }

    private final CellType getCellType() {
        NotebookCellLines.Interval interval = this.editorCell.getIntervalOrNull();
        return interval != null ? interval.getType() : null;
    }

    private final EditorCellView getView() {
        return this.editorCell.getView();
    }

    private final boolean isSelected() {
        return this.editorCell.isSelected().get();
    }

    private final boolean isHovered() {
        return this.editorCell.isHovered().get();
    }

    @NotNull
    public final AtomicProperty<CellFrameState> getState() {
        return this.state;
    }

    public void dispose() {
        this.state.set((Object)new CellFrameState(false, null, 2, null));
    }

    @Nullable
    public final Line2D getOrCalculateLineFrameVerticalLine() {
        if (!((CellFrameState)this.state.get()).isVisible()) {
            return null;
        }
        Line2D line2D = this.cachedRightLine;
        if (line2D != null) {
            Line2D it = line2D;
            boolean bl = false;
            return it;
        }
        return this.calculateRightLine();
    }

    private final Line2D.Double calculateRightLine() {
        Line2D.Double double_;
        Rectangle rectangle;
        Object v2;
        Object upperInlayBounds;
        Object $this$firstOrNull$iv;
        block6: {
            Object v1;
            Object inlays;
            block5: {
                Object object = this.getView();
                if (object == null || (object = ((EditorCellView)object).getInput()) == null || (object = ((EditorCellInput)object).getBlockElementsInRange()) == null) {
                    return null;
                }
                inlays = object;
                $this$firstOrNull$iv = (Iterable)inlays;
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Inlay it = (Inlay)element$iv;
                    boolean bl = false;
                    if (!(it.getProperties().getPriority() == NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellInputInlaysPriority() && it.getProperties().isShownAbove())) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            Inlay inlay = v1;
            if (inlay == null || ($this$firstOrNull$iv = inlay.getBounds()) == null) {
                return null;
            }
            upperInlayBounds = $this$firstOrNull$iv;
            Object $this$lastOrNull$iv = inlays;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                Inlay it = (Inlay)element$iv;
                boolean bl = false;
                if (!(it.getProperties().getPriority() == NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellInputInlaysPriority() && !it.getProperties().isShownAbove())) continue;
                v2 = element$iv;
                break block6;
            }
            v2 = null;
        }
        $this$firstOrNull$iv = v2;
        if ($this$firstOrNull$iv == null || (rectangle = $this$firstOrNull$iv.getBounds()) == null) {
            return null;
        }
        Rectangle lowerInlayBounds = rectangle;
        double x = (double)(((Rectangle)upperInlayBounds).x + ((Rectangle)upperInlayBounds).width) - 0.5;
        double startY = (double)(((Rectangle)upperInlayBounds).y + ((Rectangle)upperInlayBounds).height - NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellBorderHeight() / 2) + 0.5;
        double endY = (double)(lowerInlayBounds.y + lowerInlayBounds.height) - 1.0;
        Line2D.Double it = double_ = new Line2D.Double(x, startY, x, endY);
        boolean bl = false;
        this.cachedRightLine = it;
        return double_;
    }

    public final void updateCellFrameShow() {
        if (this.getCellType() == CellType.MARKDOWN) {
            this.updateCellFrameShowMarkdown();
        } else {
            this.updateCellFrameShowCode();
        }
    }

    private final void updateCellFrameShowMarkdown() {
        if (((Boolean)NotebookEditorKt.getNotebookEditor((Editor)this.getEditor()).getSingleFileDiffMode().get()).booleanValue()) {
            this.updateCellFrameShowCode();
            return;
        }
        if (this.isSelected()) {
            this.state.set((Object)new CellFrameState(true, (Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellFrameSelectedColor().get()));
        } else if (this.isHovered()) {
            this.state.set((Object)new CellFrameState(true, (Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellFrameHoveredColor().get()));
        } else {
            this.state.set((Object)new CellFrameState(false, null, 2, null));
        }
    }

    private final void updateCellFrameShowCode() {
        if (this.isSelected()) {
            this.state.set((Object)new CellFrameState(true, (Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellFrameSelectedColor().get()));
        } else {
            this.state.set((Object)new CellFrameState(false, null, 2, null));
        }
    }

    private static final Unit _init_$lambda$0(EditorCellFrameManager this$0, boolean it) {
        this$0.updateCellFrameShow();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(EditorCellFrameManager this$0, boolean it) {
        this$0.updateCellFrameShow();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(EditorCellFrameManager this$0, boolean it) {
        this$0.updateCellFrameShow();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(EditorCellFrameManager this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCellFrameShow();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(EditorCellFrameManager this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCellFrameShow();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(EditorCellFrameManager this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCellFrameShow();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(EditorCellFrameManager this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCellFrameShow();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(EditorCellFrameManager this$0) {
        this$0.cachedRightLine = null;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/notebooks/visualization/ui/providers/frame/EditorCellFrameManager$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/notebooks/visualization/ui/providers/frame/EditorCellFrameManager;", "editorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final EditorCellFrameManager create(@NotNull EditorCell editorCell) {
            Intrinsics.checkNotNullParameter((Object)editorCell, (String)"editorCell");
            return editorCell.getInterval().getType() == CellType.MARKDOWN && Registry.Companion.is("jupyter.markdown.cells.border") || Registry.Companion.is("jupyter.code.cells.border") ? new EditorCellFrameManager(editorCell) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

