/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.aggregation.Aggregatable;
import org.jetbrains.kotlinx.dataframe.aggregation.AggregateGroupedDsl;
import org.jetbrains.kotlinx.dataframe.annotations.HasSchema;
import org.jetbrains.kotlinx.dataframe.annotations.Interpretable;
import org.jetbrains.kotlinx.dataframe.annotations.Refine;
import org.jetbrains.kotlinx.dataframe.annotations.RequiredByIntellijPlugin;
import org.jetbrains.kotlinx.dataframe.api.AddKt;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.IndicesKt;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.impl.DataFrameImpl;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@HasSchema(schemaArg=0)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u0000 0*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00010J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H&J\b\u0010\t\u001a\u00020\nH'J\u0015\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\fH\u0096\u0002J^\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\u0004\b\u0001\u0010\u000f2H\u0010\u0010\u001aD\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0012\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u0002H\u000f0\u0011j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000f`\u0017\u00a2\u0006\u0002\b\u0016H'Jj\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u00190\u0005\"\u0004\b\u0001\u0010\u001a2N\u0010\u001b\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001c\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u001d0\u0011j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001a`\u001e\u00a2\u0006\u0002\b\u0016H\u0016J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u001f\u001a\u00020\nH\u00a7\u0002J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0096\u0002J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\"\u001a\u00020#H\u0096\u0002J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010$\u001a\u00020#2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0&\"\u00020#H\u0096\u0002\u00a2\u0006\u0002\u0010'J#\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010(\u001a\u00020\n2\n\u0010)\u001a\u00020*\"\u00020\nH\u0096\u0002J\u001f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010,\u001a\n\u0012\u0002\b\u00030-j\u0002`.H\u0096\u0002J%\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0014\u0010/\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030-j\u0002`.0!H\u0096\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00061\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "T", "Lorg/jetbrains/kotlinx/dataframe/aggregation/Aggregatable;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsContainer;", "columnNames", "", "", "columnTypes", "Lkotlin/reflect/KType;", "rowsCount", "", "iterator", "", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "aggregate", "R", "body", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/aggregation/AggregateGroupedDsl;", "Lkotlin/ParameterName;", "name", "it", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/aggregation/AggregateGroupedBody;", "get", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "C", "columns", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "index", "indices", "", "range", "Lkotlin/ranges/IntRange;", "first", "ranges", "", "(Lkotlin/ranges/IntRange;[Lkotlin/ranges/IntRange;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "firstIndex", "otherIndices", "", "plus", "col", "Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyBaseCol;", "cols", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrame.kt\norg/jetbrains/kotlinx/dataframe/DataFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,154:1\n1563#2:155\n1634#2,3:156\n1563#2:159\n1634#2,3:160\n248#3:163\n252#3:166\n37#4,2:164\n*S KotlinDebug\n*F\n+ 1 DataFrame.kt\norg/jetbrains/kotlinx/dataframe/DataFrame\n*L\n106#1:155\n106#1:156,3\n109#1:159\n109#1:160,3\n112#1:163\n115#1:166\n112#1:164,2\n*E\n"})
public interface DataFrame<T>
extends Aggregatable<T>,
ColumnsContainer<T> {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlinx.dataframe.DataFrame$Companion.$$INSTANCE;

    @NotNull
    public List<String> columnNames();

    @NotNull
    public List<KType> columnTypes();

    @RequiredByIntellijPlugin
    public int rowsCount();

    @NotNull
    default public Iterator<DataRow<T>> iterator() {
        return DataFrameGetKt.rows(this).iterator();
    }

    @Refine
    @Interpretable(interpreter="AggregateRow")
    @NotNull
    public <R> DataRow<T> aggregate(@NotNull Function2<? super AggregateGroupedDsl<? extends T>, ? super AggregateGroupedDsl<? extends T>, ? extends R> var1);

    @Override
    @NotNull
    default public <C> List<DataColumn<C>> get(@NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return UtilsKt.getColumnsImpl(this, UnresolvedColumnsPolicy.Fail, columns2);
    }

    @RequiredByIntellijPlugin
    @NotNull
    public DataRow<T> get(int var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    default public DataFrame<T> get(@NotNull Iterable<Integer> indices) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Iterable $this$map$iv = this.columns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void col;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(col.get(indices));
        }
        return CastKt.cast(ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public DataFrame<T> get(@NotNull IntRange range) {
        DataFrame dataFrame;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (Intrinsics.areEqual((Object)range, (Object)IndicesKt.indices(this))) {
            dataFrame = this;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.columns();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void col;
                DataColumn dataColumn = (DataColumn)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(col.get(range));
            }
            dataFrame = CastKt.cast(ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv));
        }
        return dataFrame;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public DataFrame<T> get(@NotNull IntRange first, IntRange ... ranges) {
        void head$iv;
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        IntRange intRange = first;
        Object[] cols$iv = ranges;
        boolean $i$f$headPlusArray = false;
        Collection $this$toTypedArray$iv$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)head$iv), (Iterable)ArraysKt.toList((Object[])cols$iv));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        return DataFrameGetKt.getRows(this, SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])thisCollection$iv$iv.toArray(new IntRange[0])), DataFrame::get$lambda$2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public DataFrame<T> get(int firstIndex, int ... otherIndices) {
        void head$iv;
        Intrinsics.checkNotNullParameter((Object)otherIndices, (String)"otherIndices");
        Integer n = firstIndex;
        Iterable cols$iv = ArraysKt.asIterable((int[])otherIndices);
        boolean $i$f$headPlusIterable = false;
        return this.get(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)head$iv), (Iterable)cols$iv));
    }

    @NotNull
    default public DataFrame<T> plus(@NotNull BaseColumn<?> col) {
        Intrinsics.checkNotNullParameter(col, (String)"col");
        BaseColumn[] baseColumnArray = new BaseColumn[]{col};
        return AddKt.add(this, baseColumnArray);
    }

    @NotNull
    default public DataFrame<T> plus(@NotNull Iterable<? extends BaseColumn<?>> cols) {
        Intrinsics.checkNotNullParameter(cols, (String)"cols");
        return CastKt.cast(ToDataFrameKt.toDataFrameAnyColumn(CollectionsKt.plus((Collection)this.columns(), cols)));
    }

    private static Sequence get$lambda$2(IntRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.asSequence((Iterable)((Iterable)it));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\n\u0012\u0002\b\u00030\u0005j\u0002`\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0005\"\u0006\b\u0001\u0010\r\u0018\u0001H\u0086\bJ\u0016\u0010\t\u001a\n\u0012\u0002\b\u00030\u0005j\u0002`\u00062\u0006\u0010\u000e\u001a\u00020\u000fR\u0019\u0010\u0004\u001a\n\u0012\u0002\b\u00030\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/dataframe/DataFrame$Companion;", "", "<init>", "()V", "Empty", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "getEmpty", "()Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "empty", "nrow", "", "emptyOf", "T", "schema", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final DataFrame<?> Empty;

        private Companion() {
        }

        @NotNull
        public final DataFrame<?> getEmpty() {
            return Empty;
        }

        @NotNull
        public final DataFrame<?> empty(int nrow) {
            return nrow == 0 ? Empty : (DataFrame)new DataFrameImpl(CollectionsKt.emptyList(), nrow);
        }

        public static /* synthetic */ DataFrame empty$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.empty(n);
        }

        public final /* synthetic */ <T> DataFrame<T> emptyOf() {
            boolean $i$f$emptyOf = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            return CastKt.cast(org.jetbrains.kotlinx.dataframe.impl.schema.UtilsKt.createEmptyDataFrameOf(Reflection.getOrCreateKotlinClass(Object.class)));
        }

        @NotNull
        public final DataFrame<?> empty(@NotNull DataFrameSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return org.jetbrains.kotlinx.dataframe.impl.schema.UtilsKt.createEmptyDataFrame(schema);
        }

        static {
            $$INSTANCE = new Companion();
            Empty = new DataFrameImpl(CollectionsKt.emptyList(), 0);
        }
    }
}

