/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.SplitWithTransform;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.impl.ColumnDataCollector;
import org.jetbrains.kotlinx.dataframe.impl.ColumnDataCollectorKt;
import org.jetbrains.kotlinx.dataframe.impl.api.ColumnToInsert;
import org.jetbrains.kotlinx.dataframe.impl.api.InsertKt;
import org.jetbrains.kotlinx.dataframe.impl.api.RemoveKt;
import org.jetbrains.kotlinx.dataframe.impl.api.RemoveResult;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.tree.TreeNode;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0000\u001ae\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0000\u0010\b\"\u0004\b\u0001\u0010\t\"\u0004\b\u0002\u0010\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\f2)\u0010\r\u001a%\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u000f\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00010\u000e\u00a2\u0006\u0002\b\u0012H\u0000\u001a4\u0010\u0013\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0001H\u0000\u001a\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0001*\u00020\u0011H\u0000\u00a8\u0006\u001b"}, d2={"valueToList", "", "", "value", "splitStrings", "", "splitImpl", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "T", "C", "R", "clause", "Lorg/jetbrains/kotlinx/dataframe/api/SplitWithTransform;", "columnNamesGenerator", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "", "", "Lkotlin/ExtensionFunctionType;", "generateUnusedName", "df", "preferredName", "insertPath", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "columnsToBeInserted", "Lorg/jetbrains/kotlinx/dataframe/impl/api/ColumnToInsert;", "splitDefault", "core"})
@SourceDebugExtension(value={"SMAP\nsplit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 split.kt\norg/jetbrains/kotlinx/dataframe/impl/api/SplitKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1563#2:106\n1634#2,3:107\n1869#2:110\n1878#2,3:112\n1870#2:115\n1563#2:116\n1634#2,3:117\n1761#2,3:120\n1#3:111\n*S KotlinDebug\n*F\n+ 1 split.kt\norg/jetbrains/kotlinx/dataframe/impl/api/SplitKt\n*L\n19#1:106\n19#1:107,3\n35#1:110\n58#1:112,3\n35#1:115\n104#1:116\n104#1:117,3\n84#1:120,3\n*E\n"})
public final class SplitKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Object> valueToList(@Nullable Object value, boolean splitStrings) {
        List list;
        Object object = value;
        if (object == null) {
            list = CollectionsKt.emptyList();
        } else if (object instanceof List) {
            list = (List)value;
        } else if (object instanceof DataFrame) {
            list = CollectionsKt.toList(DataFrameGetKt.rows((DataFrame)value));
        } else if (splitStrings) {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)value.toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)value);
        }
        return list;
    }

    public static /* synthetic */ List valueToList$default(Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return SplitKt.valueToList(object, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C, R> DataFrame<T> splitImpl(@NotNull SplitWithTransform<T, C, R> clause, @NotNull Function2<? super ColumnWithPath<? extends C>, ? super Integer, ? extends List<String>> columnNamesGenerator) {
        Intrinsics.checkNotNullParameter(clause, (String)"clause");
        Intrinsics.checkNotNullParameter(columnNamesGenerator, (String)"columnNamesGenerator");
        int nrow = DataFrameKt.getNrow(clause.getDf$core());
        RemoveResult removeResult = RemoveKt.removeImpl$default(clause.getDf$core(), false, clause.getColumns$core(), 1, null);
        List columnsToInsert = new ArrayList();
        Iterable $this$forEach$iv = removeResult.getRemovedColumns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeNode node = (TreeNode)element$iv;
            boolean bl = false;
            ColumnWithPath column2 = UtilsKt.toColumnWithPath(node);
            List columnCollectors = new ArrayList();
            for (int row = 0; row < nrow; ++row) {
                int j;
                Iterable value = (Iterable)clause.getTransform$core().invoke(clause.getDf$core().get(row), column2.getData().get(row));
                List list = SplitKt.valueToList$default(value, false, 2, null);
                int n = ((Collection)list).size();
                for (j = 0; j < n; ++j) {
                    if (columnCollectors.size() <= j) {
                        ColumnDataCollector collector = ColumnDataCollectorKt.createDataCollector(nrow);
                        int n2 = 0;
                        while (n2 < row) {
                            int it = n2++;
                            boolean bl2 = false;
                            collector.add(clause.getDefault$core());
                        }
                        columnCollectors.add(collector);
                    }
                    ((ColumnDataCollector)columnCollectors.get(j)).add(list.get(j));
                }
                n = columnCollectors.size();
                for (j = list.size(); j < n; ++j) {
                    ((ColumnDataCollector)columnCollectors.get(j)).add(clause.getDefault$core());
                }
            }
            List names = (List)columnNamesGenerator.invoke(column2, (Object)columnCollectors.size());
            ColumnPath sourcePath = node.pathFromRoot();
            Iterable $this$forEachIndexed$iv = columnCollectors;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void col;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ColumnDataCollector bl2 = (ColumnDataCollector)item$iv;
                int i = n;
                boolean bl3 = false;
                String preferredName = (String)CollectionsKt.getOrNull((List)names, (int)i);
                ColumnPath pathToInsert = clause.getInward$core() ? sourcePath : sourcePath.dropLast(1);
                String name = SplitKt.generateUnusedName(removeResult.getDf(), preferredName, pathToInsert, columnsToInsert);
                ColumnPath path = pathToInsert.plus(name);
                DataColumn<Object> data = col.toColumn(name);
                columnsToInsert.add(new ColumnToInsert(path, (BaseColumn)data, node));
            }
        }
        return InsertKt.insertImplT(removeResult.getDf(), columnsToInsert);
    }

    @NotNull
    public static final String generateUnusedName(@NotNull DataFrame<?> df, @Nullable String preferredName, @NotNull ColumnPath insertPath, @NotNull List<ColumnToInsert> columnsToBeInserted) {
        Intrinsics.checkNotNullParameter(df, (String)"df");
        Intrinsics.checkNotNullParameter((Object)insertPath, (String)"insertPath");
        Intrinsics.checkNotNullParameter(columnsToBeInserted, (String)"columnsToBeInserted");
        return preferredName == null ? SplitKt.generateUnusedName$generateNameVariationByTryingNumericSuffixes$default(df, insertPath, columnsToBeInserted, null, 1, 8, null) : SplitKt.generateUnusedName$generateNameVariationByTryingNumericSuffixes(df, insertPath, columnsToBeInserted, preferredName, 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> splitDefault(@NotNull String $this$splitDefault) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$splitDefault, (String)"<this>");
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$splitDefault, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean generateUnusedName$isUsed(DataFrame<?> $df, ColumnPath $insertPath, List<ColumnToInsert> $columnsToBeInserted, String name) {
        ColumnToInsert it;
        if ($df.getColumnOrNull($insertPath.plus(name)) != null) return true;
        Iterable $this$any$iv = $columnsToBeInserted;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ColumnToInsert)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it.getInsertionPath(), (Object)$insertPath.plus(name)));
        return true;
    }

    private static final String generateUnusedName$generateNameVariationByTryingNumericSuffixes(DataFrame<?> $df, ColumnPath $insertPath, List<ColumnToInsert> $columnsToBeInserted, String original, int startSuffix) {
        String name;
        int k = startSuffix;
        String string = original;
        if (string == null) {
            string = name = "split" + k;
        }
        while (SplitKt.generateUnusedName$isUsed($df, $insertPath, $columnsToBeInserted, name)) {
            String string2 = original;
            if (string2 == null) {
                string2 = "split";
            }
            name = string2;
            name = name + k++;
        }
        return name;
    }

    static /* synthetic */ String generateUnusedName$generateNameVariationByTryingNumericSuffixes$default(DataFrame dataFrame, ColumnPath columnPath, List list, String string, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string = null;
        }
        return SplitKt.generateUnusedName$generateNameVariationByTryingNumericSuffixes(dataFrame, columnPath, list, string, n);
    }
}

