/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.plugin.impl.api;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPathKt;
import org.jetbrains.kotlinx.dataframe.plugin.impl.DataFrameAdapterKt;
import org.jetbrains.kotlinx.dataframe.plugin.impl.PluginDataFrameSchema;
import org.jetbrains.kotlinx.dataframe.plugin.impl.api.SingleColumnApproximation;
import org.jetbrains.kotlinx.dataframe.plugin.impl.data.ColumnWithPathApproximation;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dataframe/plugin/impl/api/ResolvedDataColumn;", "Lorg/jetbrains/kotlinx/dataframe/plugin/impl/api/SingleColumnApproximation;", "col", "Lorg/jetbrains/kotlinx/dataframe/plugin/impl/data/ColumnWithPathApproximation;", "<init>", "(Lorg/jetbrains/kotlinx/dataframe/plugin/impl/data/ColumnWithPathApproximation;)V", "name", "", "rename", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "", "newName", "resolve", "", "df", "Lorg/jetbrains/kotlinx/dataframe/plugin/impl/PluginDataFrameSchema;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "resolveSingle", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "getPath", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "kotlin-dataframe-compiler-plugin.k2"})
public final class ResolvedDataColumn
implements SingleColumnApproximation {
    @NotNull
    private final ColumnWithPathApproximation col;
    @NotNull
    private final ColumnPath path;

    public ResolvedDataColumn(@NotNull ColumnWithPathApproximation col) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        this.col = col;
        this.path = this.col.getPath();
    }

    @Override
    @NotNull
    public String name() {
        return this.col.getColumn().getName();
    }

    @Override
    @NotNull
    public ColumnReference<Object> rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new ResolvedDataColumn(new ColumnWithPathApproximation(this.col.getPath(), this.col.getColumn().rename(newName), false, 4, null));
    }

    @Override
    @NotNull
    public List<ColumnWithPathApproximation> resolve(@NotNull PluginDataFrameSchema df) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        return CollectionsKt.listOf((Object)this.col);
    }

    @Override
    @NotNull
    public List<ColumnWithPath<Object>> resolve(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CollectionsKt.listOf(this.resolveSingle(context));
    }

    @Override
    @NotNull
    public ColumnWithPath<Object> resolveSingle(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ColumnWithPathKt.ColumnWithPath(DataFrameAdapterKt.asDataColumn(this.col.getColumn()), this.col.getPath());
    }

    @Override
    @NotNull
    public ColumnPath getPath() {
        return this.path;
    }
}

