/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.stats;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.AtomicExtensionsKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.stats.Buckets;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001#B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u001fH\u0016R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jitsi/utils/stats/BucketStats;", "", "thresholdsNoMax", "", "averageMaxLabel", "", "bucketLabel", "([JLjava/lang/String;Ljava/lang/String;)V", "average", "", "getAverage", "()D", "getAverageMaxLabel", "()Ljava/lang/String;", "getBucketLabel", "buckets", "Lorg/jitsi/utils/stats/Buckets;", "maxValue", "Ljava/util/concurrent/atomic/AtomicLong;", "snapshot", "Lorg/jitsi/utils/stats/BucketStats$Snapshot;", "getSnapshot", "()Lorg/jitsi/utils/stats/BucketStats$Snapshot;", "totalCount", "Ljava/util/concurrent/atomic/LongAdder;", "totalValue", "addValue", "", "value", "", "getBucketsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "b", "Lorg/jitsi/utils/stats/Buckets$Snapshot;", "toJson", "Snapshot", "jitsi-utils"})
public class BucketStats {
    @NotNull
    private final String averageMaxLabel;
    @NotNull
    private final String bucketLabel;
    @NotNull
    private final LongAdder totalValue;
    @NotNull
    private final LongAdder totalCount;
    @NotNull
    private final AtomicLong maxValue;
    @NotNull
    private final Buckets buckets;

    public BucketStats(@NotNull long[] thresholdsNoMax, @NotNull String averageMaxLabel, @NotNull String bucketLabel) {
        Intrinsics.checkNotNullParameter((Object)thresholdsNoMax, (String)"thresholdsNoMax");
        Intrinsics.checkNotNullParameter((Object)averageMaxLabel, (String)"averageMaxLabel");
        Intrinsics.checkNotNullParameter((Object)bucketLabel, (String)"bucketLabel");
        this.averageMaxLabel = averageMaxLabel;
        this.bucketLabel = bucketLabel;
        long[] lArray = thresholdsNoMax;
        long[] lArray2 = ArraysKt.sortedArray((long[])thresholdsNoMax);
        boolean bl = false;
        if (!Arrays.equals(lArray, lArray2)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Thresholds must be sorted: ", (Object)ArraysKt.joinToString$default((long[])thresholdsNoMax, null, null, null, (int)0, null, null, (int)63, null)));
        }
        this.totalValue = new LongAdder();
        this.totalCount = new LongAdder();
        this.maxValue = new AtomicLong(0L);
        this.buckets = new Buckets(thresholdsNoMax);
    }

    public /* synthetic */ BucketStats(long[] lArray, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(lArray, string, string2);
    }

    @NotNull
    public final String getAverageMaxLabel() {
        return this.averageMaxLabel;
    }

    @NotNull
    public final String getBucketLabel() {
        return this.bucketLabel;
    }

    private final double getAverage() {
        return (double)this.totalValue.sum() / (double)this.totalCount.sum();
    }

    public final void addValue(long value) {
        if (value >= 0L) {
            this.totalValue.add(value);
            AtomicExtensionsKt.maxAssign(this.maxValue, value);
            this.totalCount.increment();
            this.buckets.addValue(value);
        }
    }

    @NotNull
    public OrderedJsonObject toJson() {
        OrderedJsonObject orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        boolean bl2 = false;
        OrderedJsonObject $this$toJson_u24lambda_u2d0 = orderedJsonObject;
        boolean bl3 = false;
        Snapshot snapshot = this.getSnapshot();
        $this$toJson_u24lambda_u2d0.put(Intrinsics.stringPlus((String)"average", (Object)this.getAverageMaxLabel()), (Object)snapshot.getAverage());
        $this$toJson_u24lambda_u2d0.put(Intrinsics.stringPlus((String)"max", (Object)this.getAverageMaxLabel()), (Object)snapshot.getMaxValue());
        $this$toJson_u24lambda_u2d0.put("total_value", (Object)snapshot.getTotalValue());
        $this$toJson_u24lambda_u2d0.put("total_count", (Object)snapshot.getTotalCount());
        $this$toJson_u24lambda_u2d0.put("buckets", this.getBucketsJson(snapshot.getBuckets()));
        return orderedJsonObject;
    }

    @NotNull
    public final Snapshot getSnapshot() {
        return new Snapshot(this.getAverage(), this.maxValue.get(), this.totalValue.sum(), this.totalCount.sum(), this.buckets.getSnapshot());
    }

    @NotNull
    public final OrderedJsonObject getBucketsJson(@NotNull Buckets.Snapshot b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        OrderedJsonObject orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        boolean bl2 = false;
        OrderedJsonObject $this$getBucketsJson_u24lambda_u2d1 = orderedJsonObject;
        boolean bl3 = false;
        int n = 0;
        int n2 = b.getBuckets().length - 2;
        if (n <= n2) {
            int i;
            do {
                i = n++;
                $this$getBucketsJson_u24lambda_u2d1.put("<= " + ((Number)b.getBuckets()[i].getFirst()).longValue() + this.getBucketLabel(), b.getBuckets()[i].getSecond());
            } while (i != n2);
        }
        int indexOfSecondToLast = b.getBuckets().length - 2;
        $this$getBucketsJson_u24lambda_u2d1.put("> " + ((Number)b.getBuckets()[indexOfSecondToLast].getFirst()).longValue() + this.getBucketLabel(), ((Pair)ArraysKt.last((Object[])b.getBuckets())).getSecond());
        $this$getBucketsJson_u24lambda_u2d1.put("p99<=", (Object)b.getP99bound());
        $this$getBucketsJson_u24lambda_u2d1.put("p999<=", (Object)b.getP999bound());
        return orderedJsonObject;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jitsi/utils/stats/BucketStats$Snapshot;", "", "average", "", "maxValue", "", "totalValue", "totalCount", "buckets", "Lorg/jitsi/utils/stats/Buckets$Snapshot;", "(DJJJLorg/jitsi/utils/stats/Buckets$Snapshot;)V", "getAverage", "()D", "getBuckets", "()Lorg/jitsi/utils/stats/Buckets$Snapshot;", "getMaxValue", "()J", "getTotalCount", "getTotalValue", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-utils"})
    public static final class Snapshot {
        private final double average;
        private final long maxValue;
        private final long totalValue;
        private final long totalCount;
        @NotNull
        private final Buckets.Snapshot buckets;

        public Snapshot(double average, long maxValue, long totalValue, long totalCount, @NotNull Buckets.Snapshot buckets) {
            Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
            this.average = average;
            this.maxValue = maxValue;
            this.totalValue = totalValue;
            this.totalCount = totalCount;
            this.buckets = buckets;
        }

        public final double getAverage() {
            return this.average;
        }

        public final long getMaxValue() {
            return this.maxValue;
        }

        public final long getTotalValue() {
            return this.totalValue;
        }

        public final long getTotalCount() {
            return this.totalCount;
        }

        @NotNull
        public final Buckets.Snapshot getBuckets() {
            return this.buckets;
        }

        public final double component1() {
            return this.average;
        }

        public final long component2() {
            return this.maxValue;
        }

        public final long component3() {
            return this.totalValue;
        }

        public final long component4() {
            return this.totalCount;
        }

        @NotNull
        public final Buckets.Snapshot component5() {
            return this.buckets;
        }

        @NotNull
        public final Snapshot copy(double average, long maxValue, long totalValue, long totalCount, @NotNull Buckets.Snapshot buckets) {
            Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
            return new Snapshot(average, maxValue, totalValue, totalCount, buckets);
        }

        public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, double d, long l, long l2, long l3, Buckets.Snapshot snapshot2, int n, Object object) {
            if ((n & 1) != 0) {
                d = snapshot.average;
            }
            if ((n & 2) != 0) {
                l = snapshot.maxValue;
            }
            if ((n & 4) != 0) {
                l2 = snapshot.totalValue;
            }
            if ((n & 8) != 0) {
                l3 = snapshot.totalCount;
            }
            if ((n & 0x10) != 0) {
                snapshot2 = snapshot.buckets;
            }
            return snapshot.copy(d, l, l2, l3, snapshot2);
        }

        @NotNull
        public String toString() {
            return "Snapshot(average=" + this.average + ", maxValue=" + this.maxValue + ", totalValue=" + this.totalValue + ", totalCount=" + this.totalCount + ", buckets=" + this.buckets + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.average);
            result = result * 31 + Long.hashCode(this.maxValue);
            result = result * 31 + Long.hashCode(this.totalValue);
            result = result * 31 + Long.hashCode(this.totalCount);
            result = result * 31 + this.buckets.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Snapshot)) {
                return false;
            }
            Snapshot snapshot = (Snapshot)other;
            if (!Intrinsics.areEqual((Object)this.average, (Object)snapshot.average)) {
                return false;
            }
            if (this.maxValue != snapshot.maxValue) {
                return false;
            }
            if (this.totalValue != snapshot.totalValue) {
                return false;
            }
            if (this.totalCount != snapshot.totalCount) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.buckets, (Object)snapshot.buckets);
        }
    }
}

