/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.sybase.model.AseProcedure;
import com.intellij.database.dialects.sybase.model.AseRoutine;
import com.intellij.database.dialects.sybase.model.AseTrigger;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlTableDefinition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/sybase/AseObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "buildRoutine", "Lcom/intellij/database/dialects/sybase/model/AseRoutine;", "buildTrigger", "Lcom/intellij/database/dialects/sybase/model/AseTrigger;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "assignName", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "intellij.database.dialects.sybase"})
public final class AseObjectBuilder
extends SqlObjectBuilderImpl {
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof AseTrigger) {
            this.buildTrigger((AseTrigger)obj, source, context);
        } else if (basicModElement instanceof AseRoutine) {
            this.buildRoutine((AseRoutine)obj, source, context);
        } else {
            super.build(obj, source, context);
        }
    }

    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? this.getViewQueryRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? this.getRoutineBodyRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TRIGGER) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text, def)));
    }

    private final void buildRoutine(AseRoutine obj, DasObject source, SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModRoutine");
        this.buildRoutine(obj, source, context);
        if (obj instanceof AseProcedure) {
            ((AseProcedure)obj).setPosition(ObjectPaths.getSybaseNumber((DasObject)source));
        }
        this.assignSources(obj, context, () -> AseObjectBuilder.buildRoutine$lambda$0(source, this));
    }

    private final void buildTrigger(AseTrigger obj, DasObject source, SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        this.buildTrigger(obj, source, context);
        this.assignSources(obj, context, () -> AseObjectBuilder.buildTrigger$lambda$0(source, this));
    }

    protected void buildViewSource(@NotNull BasicModView obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources((BasicModSourceAware)obj, context, () -> AseObjectBuilder.buildViewSource$lambda$0(source, this));
    }

    protected void assignName(@NotNull BasicModNamedElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (obj instanceof AseProcedure) {
            ((AseProcedure)obj).setName("");
        } else {
            super.assignName(obj, source, context);
        }
    }

    private static final CompositeText buildRoutine$lambda$0(DasObject $source, AseObjectBuilder this$0) {
        String string;
        SqlCreateProcedureStatement sqlCreateProcedureStatement = $source instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)$source : null;
        return (CompositeText)(sqlCreateProcedureStatement != null && (string = this$0.wholeStatement((SqlRoutineDefinition)sqlCreateProcedureStatement)) != null ? SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null) : null);
    }

    private static final CompositeText buildTrigger$lambda$0(DasObject $source, AseObjectBuilder this$0) {
        String string;
        SqlCreateTriggerStatement sqlCreateTriggerStatement = $source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)$source : null;
        return (CompositeText)(sqlCreateTriggerStatement != null && (string = sqlCreateTriggerStatement.getText()) != null ? SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null) : null);
    }

    private static final CompositeText buildViewSource$lambda$0(DasObject $source, AseObjectBuilder this$0) {
        String string;
        SqlCreateViewStatement sqlCreateViewStatement = $source instanceof SqlCreateViewStatement ? (SqlCreateViewStatement)$source : null;
        return (CompositeText)(sqlCreateViewStatement != null && (string = this$0.wholeStatement((SqlTableDefinition)sqlCreateViewStatement)) != null ? SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null) : null);
    }
}

