/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.options;

import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceRestartService;
import com.intellij.lang.typescript.lsp.ExternalDefinitionsNodePackageKt;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptorKt;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.typescript.service.VueTypeScriptPluginServiceWrapper;
import org.jetbrains.vuejs.lang.typescript.service.lsp.VueLspServerLoader;
import org.jetbrains.vuejs.lang.typescript.service.plugin.VueTSPluginLoaderFactory;
import org.jetbrains.vuejs.options.VueServiceSettings;
import org.jetbrains.vuejs.options.VueSettingsState;
import org.jetbrains.vuejs.options.VueTSPluginVersion;

@Service(value={Service.Level.PROJECT})
@State(name="VueSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR$\u0010#\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\"8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lorg/jetbrains/vuejs/options/VueSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lorg/jetbrains/vuejs/options/VueSettingsState;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Lorg/jetbrains/vuejs/options/VueServiceSettings;", "serviceType", "getServiceType", "()Lorg/jetbrains/vuejs/options/VueServiceSettings;", "setServiceType", "(Lorg/jetbrains/vuejs/options/VueServiceSettings;)V", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "packageRef", "getPackageRef", "()Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "setPackageRef", "(Lcom/intellij/javascript/nodejs/util/NodePackageRef;)V", "tsPluginPackageRef", "getTsPluginPackageRef", "setTsPluginPackageRef", "", "useTypesFromServer", "getUseTypesFromServer", "()Z", "setUseTypesFromServer", "(Z)V", "tsPluginPreviewEnabled", "getTsPluginPreviewEnabled", "setTsPluginPreviewEnabled", "Lorg/jetbrains/vuejs/options/VueTSPluginVersion;", "tsPluginVersion", "getTsPluginVersion", "()Lorg/jetbrains/vuejs/options/VueTSPluginVersion;", "setTsPluginVersion", "(Lorg/jetbrains/vuejs/options/VueTSPluginVersion;)V", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueSettings.kt\norg/jetbrains/vuejs/options/VueSettings\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,146:1\n30#2,2:147\n30#2,2:149\n30#2,2:151\n30#2,2:153\n30#2,2:155\n*S KotlinDebug\n*F\n+ 1 VueSettings.kt\norg/jetbrains/vuejs/options/VueSettings\n*L\n51#1:147,2\n86#1:149,2\n100#1:151,2\n112#1:153,2\n113#1:155,2\n*E\n"})
public final class VueSettings
extends SimplePersistentStateComponent<VueSettingsState> {
    @NotNull
    private final Project project;

    public VueSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((BaseState)new VueSettingsState());
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VueServiceSettings getServiceType() {
        return ((VueSettingsState)this.getState()).getInnerServiceType();
    }

    public final void setServiceType(@NotNull VueServiceSettings value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        VueServiceSettings prevServiceType = ((VueSettingsState)this.getState()).getInnerServiceType();
        ((VueSettingsState)this.getState()).setInnerServiceType(value);
        if (prevServiceType != value && !this.project.isDisposed()) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<TypeScriptServiceRestartService> serviceClass$iv = TypeScriptServiceRestartService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((TypeScriptServiceRestartService)object).restartServices(TypeScriptCompilerConfigUtil.isEffectiveUseTypesFromServer((boolean)prevServiceType.isEnabled(), (boolean)((VueSettingsState)this.getState()).getUseTypesFromServer()) != TypeScriptCompilerConfigUtil.isEffectiveUseTypesFromServer((boolean)this.getServiceType().isEnabled(), (boolean)((VueSettingsState)this.getState()).getUseTypesFromServer()));
        }
    }

    @NotNull
    public final NodePackageRef getPackageRef() {
        return ExternalDefinitionsNodePackageKt.createPackageRef((String)((VueSettingsState)this.getState()).getPackageName(), (TypeScriptPackageName)VueLspServerLoader.INSTANCE.getPackageDescriptor().getServerPackage());
    }

    public final void setPackageRef(@NotNull NodePackageRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String refText = ExternalDefinitionsNodePackageKt.extractRefText((NodePackageRef)value);
        boolean changed = !Intrinsics.areEqual((Object)((VueSettingsState)this.getState()).getPackageName(), (Object)refText);
        ((VueSettingsState)this.getState()).setPackageName(refText);
        if (changed) {
            JSFrameworkLspServerDescriptorKt.restartTypeScriptServicesAsync((Project)this.project);
        }
    }

    @NotNull
    public final NodePackageRef getTsPluginPackageRef() {
        return ExternalDefinitionsNodePackageKt.createPackageRef((String)((VueSettingsState)this.getState()).getTsPluginPackageName(), (TypeScriptPackageName)VueTSPluginLoaderFactory.INSTANCE.getLoader(this.getTsPluginVersion()).getPackageDescriptor().getServerPackage());
    }

    public final void setTsPluginPackageRef(@NotNull NodePackageRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String refText = ExternalDefinitionsNodePackageKt.extractRefText((NodePackageRef)value);
        boolean changed = !Intrinsics.areEqual((Object)((VueSettingsState)this.getState()).getTsPluginPackageName(), (Object)refText);
        ((VueSettingsState)this.getState()).setTsPluginPackageName(refText);
        if (changed) {
            JSFrameworkLspServerDescriptorKt.restartTypeScriptServicesAsync((Project)this.project);
        }
    }

    public final boolean getUseTypesFromServer() {
        Boolean bl = TypeScriptCompilerSettings.Companion.getUseTypesFromServerInTests();
        return bl != null ? bl.booleanValue() : ((VueSettingsState)this.getState()).getUseTypesFromServer();
    }

    public final void setUseTypesFromServer(boolean value) {
        boolean prevUseTypesFromServer = ((VueSettingsState)this.getState()).getUseTypesFromServer();
        ((VueSettingsState)this.getState()).setUseTypesFromServer(value);
        if (prevUseTypesFromServer != value) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<TypeScriptServiceRestartService> serviceClass$iv = TypeScriptServiceRestartService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((TypeScriptServiceRestartService)object).restartServices(TypeScriptCompilerConfigUtil.isEffectiveUseTypesFromServer((boolean)this.getServiceType().isEnabled(), (boolean)prevUseTypesFromServer) != TypeScriptCompilerConfigUtil.isEffectiveUseTypesFromServer((boolean)this.getServiceType().isEnabled(), (boolean)((VueSettingsState)this.getState()).getUseTypesFromServer()));
        }
    }

    public final boolean getTsPluginPreviewEnabled() {
        return ((VueSettingsState)this.getState()).getTsPluginPreviewEnabled();
    }

    public final void setTsPluginPreviewEnabled(boolean value) {
        boolean prevTsPluginPreviewEnabled = ((VueSettingsState)this.getState()).getTsPluginPreviewEnabled();
        ((VueSettingsState)this.getState()).setTsPluginPreviewEnabled(value);
        if (prevTsPluginPreviewEnabled != value) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<TypeScriptServiceRestartService> serviceClass$iv = TypeScriptServiceRestartService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((TypeScriptServiceRestartService)object).restartServices(false);
        }
    }

    @NotNull
    public final VueTSPluginVersion getTsPluginVersion() {
        return ((VueSettingsState)this.getState()).getTsPluginVersion();
    }

    public final void setTsPluginVersion(@NotNull VueTSPluginVersion value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        VueTSPluginVersion prevTsPluginVersion = ((VueSettingsState)this.getState()).getTsPluginVersion();
        ((VueSettingsState)this.getState()).setTsPluginVersion(value);
        if (prevTsPluginVersion != value) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<VueTypeScriptPluginServiceWrapper> serviceClass$iv = VueTypeScriptPluginServiceWrapper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((VueTypeScriptPluginServiceWrapper)object).refreshService(this.project);
            $this$service$iv = (ComponentManager)this.project;
            $i$f$service = false;
            serviceClass$iv = TypeScriptServiceRestartService.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((TypeScriptServiceRestartService)object2).restartServices(false);
        }
    }
}

