/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.formatting;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/prettierjs/formatting/CaretSnapshot;", "", "primary", "Lcom/intellij/openapi/editor/RangeMarker;", "secondary", "<init>", "(Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/openapi/editor/RangeMarker;)V", "getPrimary", "()Lcom/intellij/openapi/editor/RangeMarker;", "getSecondary", "restore", "", "document", "Lcom/intellij/openapi/editor/Document;", "psiFile", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.prettierJS"})
public final class CaretSnapshot {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RangeMarker primary;
    @Nullable
    private final RangeMarker secondary;

    public CaretSnapshot(@NotNull RangeMarker primary, @Nullable RangeMarker secondary) {
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        this.primary = primary;
        this.secondary = secondary;
    }

    @NotNull
    public final RangeMarker getPrimary() {
        return this.primary;
    }

    @Nullable
    public final RangeMarker getSecondary() {
        return this.secondary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void restore(@NotNull Document document, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        try {
            Editor editor = FileEditorManager.getInstance((Project)psiFile.getProject()).getSelectedTextEditor();
            if (editor != null) {
                Editor editor2 = editor;
                boolean bl = false;
                if (editor2.getDocument() == document) {
                    int offset;
                    int n = this.primary.isValid() ? this.primary.getStartOffset() : (offset = this.secondary != null && this.secondary.isValid() ? this.secondary.getEndOffset() : -1);
                    if (offset > 0) {
                        editor2.getCaretModel().moveToOffset(offset);
                    }
                }
            }
        }
        finally {
            this.primary.dispose();
            RangeMarker rangeMarker = this.secondary;
            if (rangeMarker != null) {
                rangeMarker.dispose();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/prettierjs/formatting/CaretSnapshot$Companion;", "", "<init>", "()V", "from", "Lcom/intellij/prettierjs/formatting/CaretSnapshot;", "document", "Lcom/intellij/openapi/editor/Document;", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.prettierJS"})
    @SourceDebugExtension(value={"SMAP\nPrettierCaretSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierCaretSnapshot.kt\ncom/intellij/prettierjs/formatting/CaretSnapshot$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CaretSnapshot from(@NotNull Document document, @NotNull PsiFile psiFile) {
            RangeMarker rangeMarker;
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Editor editor = FileEditorManager.getInstance((Project)psiFile.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return null;
            }
            Editor editor2 = editor;
            if (editor2.getDocument() != document) {
                return null;
            }
            int offset = editor2.getCaretModel().getOffset();
            PsiElement psiElement = psiFile.findElementAt(offset);
            if (psiElement == null) {
                psiElement = (PsiElement)psiFile;
            }
            PsiElement element = psiElement;
            RangeMarker rangeMarker2 = document.createRangeMarker(offset, offset);
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"createRangeMarker(...)");
            RangeMarker primary = rangeMarker2;
            if (element instanceof PsiWhiteSpace) {
                PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
                if (psiElement2 != null) {
                    PsiElement it = psiElement2;
                    boolean bl = false;
                    rangeMarker = document.createRangeMarker(it.getTextRange());
                } else {
                    rangeMarker = null;
                }
            } else {
                rangeMarker = null;
            }
            RangeMarker secondary = rangeMarker;
            return new CaretSnapshot(primary, secondary);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

