/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateFileType;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

final class TextMateBackspaceHandler
extends BackspaceHandlerDelegate {
    TextMateBackspaceHandler() {
    }

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            TextMateBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TextMateBackspaceHandler.$$$reportNull$$$0(1);
        }
    }

    public boolean charDeleted(char c, PsiFile file, @NotNull Editor editor) {
        if (editor == null) {
            TextMateBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (file.getFileType() == TextMateFileType.INSTANCE) {
            TextMateScope scopeSelector;
            TextMateAutoClosingPair pairForChar;
            int offset = editor.getCaretModel().getOffset();
            EditorHighlighter highlighter = editor.getHighlighter();
            HighlighterIterator iterator = highlighter.createIterator(offset);
            if (offset == 0 && iterator.atEnd()) {
                return false;
            }
            IElementType tokenType = iterator.getTokenType();
            if (tokenType instanceof TextMateElementType && (pairForChar = TextMateBackspaceHandler.findSingleCharSmartTypingPair(c, scopeSelector = ((TextMateElementType)tokenType).getScope())) != null) {
                Document document = editor.getDocument();
                int endOffset = offset + pairForChar.getRight().length();
                if (endOffset < document.getTextLength() && StringUtil.equals((CharSequence)pairForChar.getRight(), (CharSequence)document.getCharsSequence().subSequence(offset, endOffset))) {
                    document.deleteString(offset, endOffset);
                    return true;
                }
            }
        }
        return false;
    }

    private static TextMateAutoClosingPair findSingleCharSmartTypingPair(char openingChar, @Nullable TextMateScope currentSelector) {
        if (!TextMateService.getInstance().getPreferenceRegistry().isPossibleLeftSmartTypingBrace(openingChar)) {
            return null;
        }
        Set<TextMateAutoClosingPair> pairs = TextMateEditorUtils.getSmartTypingPairs(currentSelector);
        for (TextMateAutoClosingPair pair : pairs) {
            if (pair.getLeft().length() != 1 || pair.getLeft().charAt(0) != openingChar) continue;
            return pair;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

