/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodParenthesesHandler
extends ParenthesesInsertHandler<LookupElement> {
    private final PsiMethod myMethod;
    private final boolean myOverloadsMatter;

    public MethodParenthesesHandler(@NotNull PsiMethod method, boolean overloadsMatter) {
        if (method == null) {
            MethodParenthesesHandler.$$$reportNull$$$0(0);
        }
        this.myMethod = method;
        this.myOverloadsMatter = overloadsMatter;
    }

    protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
        return this.myOverloadsMatter ? MethodParenthesesHandler.overloadsHaveParameters(context.getElements(), this.myMethod) != ThreeState.NO : !this.myMethod.getParameterList().isEmpty();
    }

    @NotNull
    public static ThreeState overloadsHaveParameters(@NotNull @NotNull LookupElement @NotNull [] allItems, @NotNull PsiMethod method) {
        List overloads;
        if (method == null) {
            MethodParenthesesHandler.$$$reportNull$$$0(1);
        }
        if (allItems == null) {
            MethodParenthesesHandler.$$$reportNull$$$0(2);
        }
        return (overloads = JBIterable.of((Object[])allItems).map(LookupElement::getPsiElement).filter(PsiMethod.class).filter(element -> element.getName().equals(method.getName())).toList()).isEmpty() ? ThreeState.fromBoolean((!method.getParameterList().isEmpty() ? 1 : 0) != 0) : MethodParenthesesHandler.hasParameters(overloads);
    }

    @NotNull
    public static ThreeState hasParameters(@NotNull List<PsiMethod> methods) {
        if (methods == null) {
            MethodParenthesesHandler.$$$reportNull$$$0(3);
        }
        boolean hasEmpty = methods.isEmpty();
        boolean hasNonEmpty = false;
        for (PsiMethod method : methods) {
            if (!method.getParameterList().isEmpty()) {
                hasNonEmpty = true;
                continue;
            }
            hasEmpty = true;
        }
        ThreeState threeState = hasNonEmpty && hasEmpty ? ThreeState.UNSURE : (hasNonEmpty ? ThreeState.YES : ThreeState.NO);
        if (threeState == null) {
            MethodParenthesesHandler.$$$reportNull$$$0(4);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allItems";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/util/MethodParenthesesHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/util/MethodParenthesesHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "hasParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "overloadsHaveParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasParameters";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

