/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class ConfigFileMetaData {
    private static final Logger LOG = Logger.getInstance(ConfigFileMetaData.class);
    @Nls
    private final String myTitle;
    private final String myId;
    private final String myFileName;
    private final String myDirectoryPath;
    private final ConfigFileVersion[] versions;
    private final ConfigFileVersion defaultVersion;
    private final boolean isOptional;
    private final boolean myFileNameFixed;
    private final boolean myUnique;

    public ConfigFileMetaData(@Nls String title, @NonNls String id, @NonNls String fileName, @NonNls String directoryPath, ConfigFileVersion[] versions, @Nullable ConfigFileVersion defaultVersion, boolean optional, boolean fileNameFixed, boolean unique) {
        this.myTitle = title;
        this.myId = id;
        this.myFileName = fileName;
        this.myDirectoryPath = directoryPath;
        this.myFileNameFixed = fileNameFixed;
        this.myUnique = unique;
        LOG.assertTrue(versions.length > 0, (Object)("No versions specified for '" + id + "' descriptor"));
        this.versions = versions;
        this.isOptional = optional;
        this.defaultVersion = defaultVersion == null ? versions[versions.length - 1] : defaultVersion;
        LOG.assertTrue(Arrays.asList(versions).contains(this.defaultVersion));
    }

    public ConfigFileMetaData(@Nls String title, @NonNls String fileName, @NonNls String directoryPath, ConfigFileVersion[] versions, ConfigFileVersion defaultVersion, boolean optional, boolean fileNameFixed, boolean unique) {
        this(title, fileName, fileName, directoryPath, versions, defaultVersion, optional, fileNameFixed, unique);
    }

    @Nls
    public String getTitle() {
        return this.myTitle;
    }

    public String getId() {
        return this.myId;
    }

    @NlsSafe
    public String getFileName() {
        return this.myFileName;
    }

    public String getDirectoryPath() {
        return this.myDirectoryPath;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public ConfigFileVersion[] getVersions() {
        return this.versions;
    }

    public String toString() {
        return this.myTitle;
    }

    public ConfigFileVersion getDefaultVersion() {
        return this.defaultVersion;
    }

    public boolean isFileNameFixed() {
        return this.myFileNameFixed;
    }

    public boolean isUnique() {
        return this.myUnique;
    }
}

