/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractMemberResolveConverter
extends ResolvingConverter<PsiMember> {
    @Nullable
    protected abstract PsiClass getTargetClass(ConvertContext var1);

    protected abstract PropertyMemberType @NotNull [] getMemberTypes(ConvertContext var1);

    @NotNull
    protected PsiType getPsiType(ConvertContext context) {
        PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)context.getPsiManager(), (GlobalSearchScope)ProjectScope.getAllScope((Project)context.getPsiManager().getProject()));
        if (psiClassType == null) {
            AbstractMemberResolveConverter.$$$reportNull$$$0(0);
        }
        return psiClassType;
    }

    protected boolean isLookDeep() {
        return true;
    }

    protected String getPropertyName(String s, ConvertContext context) {
        return s;
    }

    public PsiMember fromString(String s, @NotNull ConvertContext context) {
        if (context == null) {
            AbstractMemberResolveConverter.$$$reportNull$$$0(1);
        }
        if (s == null) {
            return null;
        }
        PsiClass psiClass = this.getTargetClass(context);
        if (psiClass == null) {
            return null;
        }
        for (PropertyMemberType type : this.getMemberTypes(context)) {
            PsiField member;
            switch (type) {
                default: {
                    throw new MatchException(null, null);
                }
                case FIELD: {
                    PsiField psiField = psiClass.findFieldByName(s, this.isLookDeep());
                    break;
                }
                case GETTER: {
                    PsiField psiField = PropertyUtilBase.findPropertyGetter((PsiClass)psiClass, (String)this.getPropertyName(s, context), (boolean)false, (boolean)this.isLookDeep());
                    break;
                }
                case SETTER: {
                    PsiField psiField = member = PropertyUtilBase.findPropertySetter((PsiClass)psiClass, (String)this.getPropertyName(s, context), (boolean)false, (boolean)this.isLookDeep());
                }
            }
            if (member == null) continue;
            return member;
        }
        return null;
    }

    public String toString(PsiMember t, @NotNull ConvertContext context) {
        if (context == null) {
            AbstractMemberResolveConverter.$$$reportNull$$$0(2);
        }
        return t == null ? null : this.getPropertyName(t.getName(), context);
    }

    public String getErrorMessage(String s, @NotNull ConvertContext context) {
        if (context == null) {
            AbstractMemberResolveConverter.$$$reportNull$$$0(3);
        }
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{TypePresentationService.getService().getTypeName((Object)parent), s});
    }

    @NotNull
    public @Unmodifiable Collection<? extends PsiMember> getVariants(@NotNull ConvertContext context) {
        PsiClass psiClass;
        if (context == null) {
            AbstractMemberResolveConverter.$$$reportNull$$$0(4);
        }
        if ((psiClass = this.getTargetClass(context)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                AbstractMemberResolveConverter.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<PsiField> list = new ArrayList<PsiField>();
        for (PsiField psiField : this.isLookDeep() ? psiClass.getAllFields() : psiClass.getFields()) {
            if (!this.fieldSuits(psiField)) continue;
            list.add(psiField);
        }
        for (PsiField psiField : this.isLookDeep() ? psiClass.getAllMethods() : psiClass.getMethods()) {
            if (!this.methodSuits((PsiMethod)psiField)) continue;
            list.add(psiField);
        }
        ArrayList<PsiField> arrayList = list;
        if (arrayList == null) {
            AbstractMemberResolveConverter.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    protected boolean methodSuits(PsiMethod psiMethod) {
        return !psiMethod.isConstructor() && !psiMethod.hasModifierProperty("static") && PropertyUtilBase.getPropertyName((PsiMethod)psiMethod) != null;
    }

    protected boolean fieldSuits(PsiField psiField) {
        return !psiField.hasModifierProperty("static");
    }

    public LocalQuickFix[] getQuickFixes(@NotNull ConvertContext context) {
        LocalQuickFix[] localQuickFixArray;
        if (context == null) {
            AbstractMemberResolveConverter.$$$reportNull$$$0(7);
        }
        String targetName = ((GenericValue)context.getInvocationElement()).getStringValue();
        if (!PsiNameHelper.getInstance((Project)context.getProject()).isIdentifier(targetName)) {
            return super.getQuickFixes(context);
        }
        PsiClass targetClass = this.getTargetClass(context);
        if (targetClass == null) {
            return super.getQuickFixes(context);
        }
        PropertyMemberType memberType = this.getMemberTypes(context)[0];
        PsiType psiType = this.getPsiType(context);
        IntentionAction fix = QuickFixFactory.getInstance().createCreateFieldOrPropertyFix(targetClass, targetName, psiType, memberType, new PsiAnnotation[0]);
        if (fix instanceof LocalQuickFix) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = (LocalQuickFix)fix;
        } else {
            localQuickFixArray = super.getQuickFixes(context);
        }
        return localQuickFixArray;
    }

    public void handleElementRename(GenericDomValue<PsiMember> genericValue, ConvertContext context, String newElementName) {
        super.handleElementRename(genericValue, context, this.getPropertyName(newElementName, context));
    }

    public void bindReference(GenericDomValue<PsiMember> genericValue, ConvertContext context, PsiElement newTarget) {
        if (newTarget instanceof PsiMember) {
            String elementName = ((PsiMember)newTarget).getName();
            genericValue.setStringValue(this.getPropertyName(elementName, context));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/converters/AbstractMemberResolveConverter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/converters/AbstractMemberResolveConverter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 7 -> new IllegalArgumentException(string);
        };
    }
}

