/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.diagnostic.DialogAppender$processEvent$;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.LowMemoryNotifier;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.VMOptions;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerFacade;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u001a\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u001a\u0010\u001c\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J$\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\b\u0010 \u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010!\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/diagnostic/DialogAppender;", "Ljava/util/logging/Handler;", "<init>", "()V", "MAX_EARLY_LOGGING_EVENTS", "", "NOTIFICATIONS_ENABLED", "", "context", "Lkotlin/coroutines/CoroutineContext;", "getContext$annotations", "earlyEventCounter", "earlyEvents", "Ljava/util/ArrayDeque;", "Lkotlin/Pair;", "", "", "loggerBroken", "Ljava/util/concurrent/atomic/AtomicBoolean;", "pluginUpdateScheduled", "publish", "", "event", "Ljava/util/logging/LogRecord;", "processEarlyEventsIfNeeded", "queueEvent", "message", "throwable", "processEvent", "findPlugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "showPluginError", "plugin", "flush", "close", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDialogAppender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogAppender.kt\ncom/intellij/diagnostic/DialogAppender\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,124:1\n479#2:125\n*S KotlinDebug\n*F\n+ 1 DialogAppender.kt\ncom/intellij/diagnostic/DialogAppender\n*L\n95#1:125\n*E\n"})
public final class DialogAppender
extends Handler {
    private final int MAX_EARLY_LOGGING_EVENTS;
    private final boolean NOTIFICATIONS_ENABLED = !Intrinsics.areEqual((Object)System.getProperty("idea.fatal.error.notification"), (Object)"disabled");
    @NotNull
    private final CoroutineContext context = CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Dispatchers.getIO(), (int)1, null, (int)2, null).plus((CoroutineContext)new CoroutineName("DialogAppender"));
    private int earlyEventCounter;
    @NotNull
    private final ArrayDeque<Pair<String, Throwable>> earlyEvents = new ArrayDeque();
    @NotNull
    private AtomicBoolean loggerBroken = new AtomicBoolean(false);
    @NotNull
    private final AtomicBoolean pluginUpdateScheduled = new AtomicBoolean(false);

    public DialogAppender() {
        this.MAX_EARLY_LOGGING_EVENTS = 20;
    }

    private static /* synthetic */ void getContext$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@NotNull LogRecord event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getLevel().intValue() < Level.SEVERE.intValue() || this.loggerBroken.get() || AppMode.isCommandLine() && !ApplicationManagerEx.isInIntegrationTest()) {
            return;
        }
        Throwable throwable = event.getThrown();
        if (throwable == null) {
            return;
        }
        Throwable throwable2 = throwable;
        DialogAppender dialogAppender = this;
        synchronized (dialogAppender) {
            boolean bl = false;
            if (LoadingState.APP_READY.isOccurred()) {
                this.processEarlyEventsIfNeeded();
                this.queueEvent(event.getMessage(), throwable2);
            } else {
                int n = this.earlyEventCounter;
                this.earlyEventCounter = n + 1;
                if (this.earlyEvents.size() < this.MAX_EARLY_LOGGING_EVENTS) {
                    this.earlyEvents.add((Pair<String, Throwable>)TuplesKt.to((Object)event.getMessage(), (Object)throwable2));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void processEarlyEventsIfNeeded() {
        if (this.earlyEventCounter == 0) {
            return;
        }
        while (this.earlyEvents.poll() != null) {
            Pair<String, Throwable> pair;
            String message = (String)pair.component1();
            Throwable throwable = (Throwable)pair.component2();
            int n = this.earlyEventCounter;
            this.earlyEventCounter = n + -1;
            this.queueEvent(message, throwable);
        }
        if (this.earlyEventCounter > 0) {
            LifecycleUsageTriggerCollector.onEarlyErrorsIgnored(this.earlyEventCounter);
            this.earlyEventCounter = 0;
        }
    }

    private final void queueEvent(String message, Throwable throwable) {
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)this.context, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, message, throwable, null){
            int label;
            final /* synthetic */ DialogAppender this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ Throwable $throwable;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                this.$throwable = $throwable;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        DialogAppender.access$processEvent(this.this$0, this.$message, this.$throwable);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void processEvent(String message, Throwable throwable) {
        try {
            Application app = ApplicationManager.getApplication();
            if (app == null || app.isExitInProgress() || app.isDisposed()) {
                return;
            }
            VMOptions.MemoryKind oomErrorKind = DefaultIdeaErrorLogger.getOOMErrorKind(throwable);
            if (oomErrorKind != null) {
                LowMemoryNotifier.showNotification(oomErrorKind, true);
            } else {
                IdeaPluginDescriptor plugin = this.findPlugin(throwable);
                if (app.isInternal() || this.NOTIFICATIONS_ENABLED || this.showPluginError(throwable, message, plugin)) {
                    List withAttachments = ExceptionUtil.causeAndSuppressed((Throwable)throwable, ExceptionWithAttachments.class).toList();
                    Intrinsics.checkNotNull(withAttachments);
                    Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)withAttachments);
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processEvent$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    Object object = (RuntimeExceptionWithAttachments)SequencesKt.firstOrNull((Sequence)sequence);
                    if (object == null || (object = object.getUserMessage()) == null) {
                        object = message;
                    }
                    Object message2 = object;
                    List attachments = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)withAttachments), DialogAppender::processEvent$lambda$0));
                    MessagePool.getInstance().addIdeFatalMessage(new LogMessage(throwable, (String)message2, attachments));
                }
            }
        }
        catch (Throwable e) {
            this.loggerBroken.set(true);
            throw e;
        }
    }

    private final IdeaPluginDescriptor findPlugin(Throwable throwable) {
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginUtil.getInstance().findPluginId(throwable));
        if (plugin != null && !plugin.isBundled() && !this.pluginUpdateScheduled.getAndSet(true) && UpdateSettings.getInstance().isPluginsCheckNeeded()) {
            UpdateCheckerFacade.Companion.getInstance().updateAndShowResult();
        }
        return plugin;
    }

    private final boolean showPluginError(Throwable throwable, String message, IdeaPluginDescriptor plugin) {
        ErrorReportSubmitter submitter = DefaultIdeaErrorLogger.findSubmitter(throwable, plugin);
        return !(submitter instanceof ITNReporter) || ((ITNReporter)submitter).showErrorInRelease(new IdeaLoggingEvent(message, throwable));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private static final Sequence processEvent$lambda$0(ExceptionWithAttachments it) {
        Attachment[] attachmentArray = it.getAttachments();
        Intrinsics.checkNotNullExpressionValue((Object)attachmentArray, (String)"getAttachments(...)");
        return ArraysKt.asSequence((Object[])attachmentArray);
    }

    public static final /* synthetic */ void access$processEvent(DialogAppender $this, String message, Throwable throwable) {
        $this.processEvent(message, throwable);
    }
}

