/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.PreciseEventWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.awt.AWTEvent;
import org.HdrHistogram.Histogram;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
@ApiStatus.Internal
public final class OtelReportingEventWatcher
extends PreciseEventWatcher
implements Disposable {
    private final ObservableLongMeasurement tasksExecutedCounter;
    private final ObservableDoubleMeasurement waitingTimeAvgNs;
    private final ObservableLongMeasurement waitingTime90PNs;
    private final ObservableLongMeasurement waitingTimeMaxNs;
    private final ObservableDoubleMeasurement queueSizeAvg;
    private final ObservableLongMeasurement queueSize90P;
    private final ObservableLongMeasurement queueSizeMax;
    private final ObservableDoubleMeasurement executionTimeAvgNs;
    private final ObservableLongMeasurement executionTime90PNs;
    private final ObservableLongMeasurement executionTimeMaxNs;
    private final ObservableLongMeasurement awtEventsDispatchedCounter;
    private final ObservableDoubleMeasurement awtDispatchTimeAvgNs;
    private final ObservableLongMeasurement awtDispatchTime90PNs;
    private final ObservableLongMeasurement awtDispatchTimeMaxNs;
    private final LongCounter awtTotalTimeNs;
    private final BatchCallback batchCallback;

    public OtelReportingEventWatcher() {
        this(TelemetryManager.getInstance().getMeter(PlatformScopesKt.EDT));
    }

    public OtelReportingEventWatcher(@NotNull Meter meter) {
        if (meter == null) {
            OtelReportingEventWatcher.$$$reportNull$$$0(0);
        }
        this.tasksExecutedCounter = meter.gaugeBuilder("FlushQueue.tasksExecuted").ofLongs().buildObserver();
        this.waitingTimeAvgNs = meter.gaugeBuilder("FlushQueue.waitingTimeAvgNs").setUnit("ns").buildObserver();
        this.waitingTime90PNs = meter.gaugeBuilder("FlushQueue.waitingTime90PNs").setUnit("ns").ofLongs().buildObserver();
        this.waitingTimeMaxNs = meter.gaugeBuilder("FlushQueue.waitingTimeMaxNs").setUnit("ns").ofLongs().buildObserver();
        this.executionTimeAvgNs = meter.gaugeBuilder("FlushQueue.executionTimeAvgNs").setUnit("ns").buildObserver();
        this.executionTime90PNs = meter.gaugeBuilder("FlushQueue.executionTime90PNs").setUnit("ns").ofLongs().buildObserver();
        this.executionTimeMaxNs = meter.gaugeBuilder("FlushQueue.executionTimeMaxNs").setUnit("ns").ofLongs().buildObserver();
        this.queueSizeAvg = meter.gaugeBuilder("FlushQueue.queueSizeAvg").buildObserver();
        this.queueSize90P = meter.gaugeBuilder("FlushQueue.queueSize90P").ofLongs().buildObserver();
        this.queueSizeMax = meter.gaugeBuilder("FlushQueue.queueSizeMax").ofLongs().buildObserver();
        this.awtEventsDispatchedCounter = meter.gaugeBuilder("AWTEventQueue.eventsDispatched").ofLongs().buildObserver();
        this.awtDispatchTimeAvgNs = meter.gaugeBuilder("AWTEventQueue.dispatchTimeAvgNs").setUnit("ns").buildObserver();
        this.awtDispatchTime90PNs = meter.gaugeBuilder("AWTEventQueue.dispatchTime90PNs").setUnit("ns").ofLongs().buildObserver();
        this.awtDispatchTimeMaxNs = meter.gaugeBuilder("AWTEventQueue.dispatchTimeMaxNs").setUnit("ns").ofLongs().buildObserver();
        this.awtTotalTimeNs = meter.counterBuilder("AWTEventQueue.dispatchTimeTotalNS").setUnit("ns").build();
        this.batchCallback = meter.batchCallback(this::reportStatsForPeriod, (ObservableMeasurement)this.tasksExecutedCounter, new ObservableMeasurement[]{this.waitingTimeAvgNs, this.waitingTime90PNs, this.waitingTimeMaxNs, this.queueSizeAvg, this.queueSize90P, this.queueSizeMax, this.executionTimeAvgNs, this.executionTime90PNs, this.executionTimeMaxNs, this.awtEventsDispatchedCounter, this.awtDispatchTimeAvgNs, this.awtDispatchTime90PNs, this.awtDispatchTimeMaxNs});
    }

    @Override
    protected void edtEventFinishedExt(@NotNull AWTEvent event, long executionDurationNs) {
        if (event == null) {
            OtelReportingEventWatcher.$$$reportNull$$$0(1);
        }
        this.awtTotalTimeNs.add(executionDurationNs);
    }

    @Override
    public void dispose() {
        this.batchCallback.close();
    }

    private synchronized void reportStatsForPeriod() {
        Histogram intervalWaitingTimes = this.getWaitingTimeHistogram();
        Histogram intervalQueueSizes = this.getQueueSizeHistogram();
        Histogram intervalExecutionTimes = this.getExecutionTimeHistogram();
        Histogram intervalAWTDispatchTimes = this.getAWTEventDispatchTimeHistogram();
        this.tasksExecutedCounter.record(intervalWaitingTimes.getTotalCount());
        this.waitingTimeAvgNs.record(intervalWaitingTimes.getMean());
        this.waitingTime90PNs.record(intervalWaitingTimes.getValueAtPercentile(90.0));
        this.waitingTimeMaxNs.record(intervalWaitingTimes.getMaxValue());
        this.queueSizeAvg.record(intervalQueueSizes.getMean());
        this.queueSize90P.record(intervalQueueSizes.getValueAtPercentile(90.0));
        this.queueSizeMax.record(intervalQueueSizes.getMaxValue());
        this.executionTimeAvgNs.record(intervalExecutionTimes.getMean());
        this.executionTime90PNs.record(intervalExecutionTimes.getValueAtPercentile(90.0));
        this.executionTimeMaxNs.record(intervalExecutionTimes.getMaxValue());
        this.awtEventsDispatchedCounter.record(intervalAWTDispatchTimes.getTotalCount());
        this.awtDispatchTimeAvgNs.record(intervalAWTDispatchTimes.getMean());
        this.awtDispatchTime90PNs.record(intervalAWTDispatchTimes.getValueAtPercentile(90.0));
        this.awtDispatchTimeMaxNs.record(intervalAWTDispatchTimes.getMaxValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/OtelReportingEventWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "edtEventFinishedExt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

