/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ijent.nio;

import com.intellij.execution.ijent.nio.IjentNioPosixFileAttributesWithDosAdapter;
import com.intellij.platform.eel.EelUserPosixInfo;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0011\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014H\u0096\u0001J\u0011\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00170\u0017H\u0096\u0001J\u0019\u0010\u0018\u001a\u00020\r2\u000e\u0010\u0019\u001a\n \u0015*\u0004\u0018\u00010\u001a0\u001aH\u0096\u0001J\u0019\u0010\u001b\u001a\u00020\r2\u000e\u0010\u0019\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014H\u0096\u0001J5\u0010\u001c\u001a\u00020\r2*\u0010\u0019\u001a&\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u001e0\u001e \u0015*\u0012\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u001e0\u001e\u0018\u00010\u001f0\u001dH\u0096\u0001J9\u0010 \u001a\u00020\r2\u000e\u0010\u0019\u001a\n \u0015*\u0004\u0018\u00010!0!2\u000e\u0010\"\u001a\n \u0015*\u0004\u0018\u00010!0!2\u000e\u0010#\u001a\n \u0015*\u0004\u0018\u00010!0!H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/execution/ijent/nio/IjentNioPosixFileAttributeViewWithDosAdapter;", "Ljava/nio/file/attribute/PosixFileAttributeView;", "Ljava/nio/file/attribute/DosFileAttributeView;", "userInfo", "Lcom/intellij/platform/eel/EelUserPosixInfo;", "posixView", "nameStartsWithDot", "", "<init>", "(Lcom/intellij/platform/eel/EelUserPosixInfo;Ljava/nio/file/attribute/PosixFileAttributeView;Z)V", "readAttributes", "Lcom/intellij/execution/ijent/nio/IjentNioPosixFileAttributesWithDosAdapter;", "setReadOnly", "", "readOnly", "setHidden", "value", "setSystem", "setArchive", "getOwner", "Ljava/nio/file/attribute/UserPrincipal;", "kotlin.jvm.PlatformType", "name", "", "setGroup", "p0", "Ljava/nio/file/attribute/GroupPrincipal;", "setOwner", "setPermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "", "setTimes", "Ljava/nio/file/attribute/FileTime;", "p1", "p2", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class IjentNioPosixFileAttributeViewWithDosAdapter
implements PosixFileAttributeView,
DosFileAttributeView {
    @NotNull
    private final EelUserPosixInfo userInfo;
    @NotNull
    private final PosixFileAttributeView posixView;
    private final boolean nameStartsWithDot;

    public IjentNioPosixFileAttributeViewWithDosAdapter(@NotNull EelUserPosixInfo userInfo, @NotNull PosixFileAttributeView posixView, boolean nameStartsWithDot) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        Intrinsics.checkNotNullParameter((Object)posixView, (String)"posixView");
        this.userInfo = userInfo;
        this.posixView = posixView;
        this.nameStartsWithDot = nameStartsWithDot;
    }

    @Override
    @NotNull
    public IjentNioPosixFileAttributesWithDosAdapter readAttributes() {
        PosixFileAttributes posixFileAttributes = this.posixView.readAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)posixFileAttributes, (String)"readAttributes(...)");
        return new IjentNioPosixFileAttributesWithDosAdapter(this.userInfo, posixFileAttributes, this.nameStartsWithDot);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        Set<PosixFilePermission> set = this.posixView.readAttributes().permissions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"permissions(...)");
        Set<PosixFilePermission> permissions = set;
        ((Collection)permissions).add(PosixFilePermission.OWNER_READ);
        if (readOnly) {
            ((Collection)permissions).remove((Object)PosixFilePermission.OWNER_WRITE);
            ((Collection)permissions).remove((Object)PosixFilePermission.GROUP_WRITE);
            ((Collection)permissions).remove((Object)PosixFilePermission.OTHERS_WRITE);
        } else {
            ((Collection)permissions).add(PosixFilePermission.OWNER_WRITE);
        }
        this.posixView.setPermissions(permissions);
    }

    @Override
    public void setHidden(boolean value) {
    }

    @Override
    public void setSystem(boolean value) {
    }

    @Override
    public void setArchive(boolean value) {
    }

    @Override
    public String name() {
        return this.posixView.name();
    }

    @Override
    public void setPermissions(Set<PosixFilePermission> p0) {
        this.posixView.setPermissions(p0);
    }

    @Override
    public void setGroup(GroupPrincipal p0) {
        this.posixView.setGroup(p0);
    }

    @Override
    public void setTimes(FileTime p0, FileTime p1, FileTime p2) {
        this.posixView.setTimes(p0, p1, p2);
    }

    @Override
    public UserPrincipal getOwner() {
        return this.posixView.getOwner();
    }

    @Override
    public void setOwner(UserPrincipal p0) {
        this.posixView.setOwner(p0);
    }
}

