/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.Switcher;
import com.intellij.ide.actions.SwitcherListItem;
import com.intellij.ide.actions.SwitcherRenderingKt;
import com.intellij.ide.actions.SwitcherToolWindow;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/intellij/ide/actions/SwitcherListRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/ide/actions/SwitcherListItem;", "switcher", "Lcom/intellij/ide/actions/Switcher$SwitcherPanel;", "<init>", "(Lcom/intellij/ide/actions/Switcher$SwitcherPanel;)V", "getSwitcher", "()Lcom/intellij/ide/actions/Switcher$SwitcherPanel;", "SEPARATOR", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "mnemonic", "Ljavax/swing/JLabel;", "getMnemonic$annotations", "()V", "main", "Lcom/intellij/ui/SimpleColoredComponent;", "extra", "panel", "Lcom/intellij/ui/CellRendererPanel;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "focused", "toolWindowsAllowed", "toolWindows", "", "Lcom/intellij/ide/actions/SwitcherToolWindow;", "getToolWindows", "()Ljava/util/List;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nSwitcherRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitcherRendering.kt\ncom/intellij/ide/actions/SwitcherListRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1#2:252\n777#3:253\n873#3,2:254\n1586#3:256\n1661#3,3:257\n*S KotlinDebug\n*F\n+ 1 SwitcherRendering.kt\ncom/intellij/ide/actions/SwitcherListRenderer\n*L\n241#1:253\n241#1:254,2\n242#1:256\n242#1:257,3\n*E\n"})
public final class SwitcherListRenderer
implements ListCellRenderer<SwitcherListItem> {
    @NotNull
    private final Switcher.SwitcherPanel switcher;
    @NotNull
    private final Color SEPARATOR;
    @NotNull
    private final JLabel mnemonic;
    @NotNull
    private final SimpleColoredComponent main;
    @NotNull
    private final SimpleColoredComponent extra;
    @NotNull
    private final CellRendererPanel panel;
    private final boolean toolWindowsAllowed;
    @NotNull
    private final List<SwitcherToolWindow> toolWindows;

    /*
     * WARNING - void declaration
     */
    public SwitcherListRenderer(@NotNull Switcher.SwitcherPanel switcher) {
        Object object;
        void $this$panel_u24lambda_u240;
        JLabel $this$extra_u24lambda_u240;
        JLabel $this$main_u24lambda_u240;
        JLabel $this$mnemonic_u24lambda_u240;
        Dimension dimension;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter((Object)((Object)switcher), (String)"switcher");
        this.switcher = switcher;
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"separatorForeground(...)");
        this.SEPARATOR = color;
        JLabel jLabel2 = jLabel = new JLabel("W");
        SwitcherListRenderer switcherListRenderer = this;
        boolean bl = false;
        Dimension dimension2 = dimension = $this$mnemonic_u24lambda_u240.getPreferredSize();
        void var7_10 = $this$mnemonic_u24lambda_u240;
        boolean bl2 = false;
        $this$mnemonic_u24lambda_u240_u240.width += JBUI.CurrentTheme.ActionsList.mnemonicIconGap();
        var7_10.setPreferredSize(dimension);
        $this$mnemonic_u24lambda_u240.setFont(JBUI.CurrentTheme.ActionsList.applyStylesForNumberMnemonic((Font)$this$mnemonic_u24lambda_u240.getFont()));
        switcherListRenderer.mnemonic = jLabel;
        $this$mnemonic_u24lambda_u240 = jLabel = new SimpleColoredComponent();
        switcherListRenderer = this;
        boolean bl3 = false;
        $this$main_u24lambda_u240.setOpaque(false);
        switcherListRenderer.main = jLabel;
        $this$main_u24lambda_u240 = jLabel = new SimpleColoredComponent();
        switcherListRenderer = this;
        boolean bl4 = false;
        $this$extra_u24lambda_u240.setOpaque(false);
        switcherListRenderer.extra = jLabel;
        $this$extra_u24lambda_u240 = jLabel = new CellRendererPanel((LayoutManager)new BorderLayout());
        switcherListRenderer = this;
        boolean bl52 = false;
        $this$panel_u24lambda_u240.add("West", (Component)this.mnemonic);
        $this$panel_u24lambda_u240.add("Center", (Component)this.main);
        $this$panel_u24lambda_u240.add("East", (Component)this.extra);
        switcherListRenderer.panel = jLabel;
        this.toolWindowsAllowed = this.switcher.getRecent() ? Registry.Companion.is("ide.recent.files.tool.window.list") : Registry.Companion.is("ide.switcher.tool.window.list");
        SwitcherListRenderer switcherListRenderer2 = this;
        if (this.toolWindowsAllowed) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ToolWindow it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            ToolWindowManagerEx manager2 = ToolWindowManagerEx.Companion.getInstanceEx(this.switcher.getProject());
            Iterable bl52 = manager2.getToolWindows();
            switcherListRenderer = switcherListRenderer2;
            boolean $i$f$filter = false;
            void $this$mnemonic_u24lambda_u240_u240 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ToolWindow)element$iv$iv;
                boolean bl6 = false;
                if (!(it.isAvailable() && it.isShowStripeButton())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ToolWindow)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                collection.add(new SwitcherToolWindow(it, this.switcher.getPinned()));
            }
            switcherListRenderer2 = switcherListRenderer;
            Iterable iterable = (List)destination$iv$iv;
            Comparator comparator = SwitcherRenderingKt.access$getMainTextComparator();
            Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"access$getMainTextComparator(...)");
            List windows = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
            object = jLabel2;
        } else {
            object = CollectionsKt.emptyList();
        }
        switcherListRenderer2.toolWindows = object;
    }

    @NotNull
    public final Switcher.SwitcherPanel getSwitcher() {
        return this.switcher;
    }

    private static /* synthetic */ void getMnemonic$annotations() {
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends SwitcherListItem> list2, @NotNull SwitcherListItem value, int index, boolean selected, boolean focused) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.main.clear();
        this.extra.clear();
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)0, (int)10);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        JBEmptyBorder border = jBEmptyBorder;
        this.panel.setBorder(!selected && value.getSeparatorAbove() ? JBUI.Borders.compound((Border)((Border)border), (Border)JBUI.Borders.customLine((Color)this.SEPARATOR, (int)1, (int)0, (int)0, (int)0)) : (Border)border);
        Color it = RenderingUtil.getForeground(list2, (boolean)selected);
        boolean bl = false;
        this.mnemonic.setForeground(selected ? it : JBUI.CurrentTheme.ActionsList.MNEMONIC_FOREGROUND);
        this.main.setForeground(it);
        this.extra.setForeground(it);
        String string = value.getMnemonic();
        if (string == null) {
            string = "";
        }
        this.mnemonic.setText(string);
        this.mnemonic.setVisible(value.getMnemonic() != null);
        value.prepareExtraRenderer(this.extra, selected);
        this.main.setFont(list2.getFont());
        int splitIconWidth = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width;
        this.main.setSize(new Dimension(list2.getWidth() - this.extra.getWidth() - this.mnemonic.getWidth() - list2.getInsets().left - list2.getInsets().right - splitIconWidth, this.main.getHeight()));
        value.prepareMainRenderer(this.main, selected);
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((JComponent)((Object)this.switcher)), (SimpleColoredComponent)this.main, (boolean)false, (boolean)selected);
        this.panel.getAccessibleContext().setAccessibleName(value.getMainText());
        this.panel.getAccessibleContext().setAccessibleDescription(value.getStatusText());
        return (Component)this.panel;
    }

    @NotNull
    public final List<SwitcherToolWindow> getToolWindows() {
        return this.toolWindows;
    }
}

