/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actionsOnSave;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actionsOnSave.ActionOnSaveComment;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfo;
import com.intellij.ide.actionsOnSave.SameRendererAndEditorColumnInfo;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

final class ActionOnSaveColumnInfo
extends SameRendererAndEditorColumnInfo<ActionOnSaveInfo> {
    static final int TOP_INSET = 5;

    ActionOnSaveColumnInfo() {
        super(IdeBundle.message((String)"actions.on.save.table.column.name.action", (Object[])new Object[0]));
    }

    @Override
    @NotNull
    protected JComponent getCellComponent(@NotNull TableView<?> table2, @NotNull ActionOnSaveInfo info, boolean hovered) {
        int baselineDelta;
        Dimension linkSize;
        if (table2 == null) {
            ActionOnSaveColumnInfo.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ActionOnSaveColumnInfo.$$$reportNull$$$0(1);
        }
        JPanel resultPanel = new JPanel(new GridBagLayout());
        resultPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)8, (int)0, (int)0));
        JCheckBox anchorCheckBox = new JCheckBox(info.getActionOnSaveName());
        Dimension cbSize = anchorCheckBox.getPreferredSize();
        int anchorBaseline = anchorCheckBox.getBaseline(cbSize.width, cbSize.height);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        resultPanel.add((Component)ActionOnSaveColumnInfo.createActionNamePanel(table2, info, anchorCheckBox, anchorBaseline), gbc);
        gbc.weightx = 0.0;
        gbc.anchor = 12;
        if (hovered) {
            for (ActionLink actionLink : info.getActionLinks()) {
                linkSize = actionLink.getPreferredSize();
                baselineDelta = anchorBaseline - actionLink.getBaseline(linkSize.width, linkSize.height);
                gbc.insets = new Insets(baselineDelta, JBUI.scale((int)5), 0, JBUI.scale((int)7));
                resultPanel.add((Component)actionLink, gbc);
            }
        }
        for (JComponent jComponent : info.getDropDownLinks()) {
            linkSize = jComponent.getPreferredSize();
            baselineDelta = anchorBaseline - jComponent.getBaseline(linkSize.width, linkSize.height);
            gbc.insets = new Insets(baselineDelta, JBUI.scale((int)5), 0, JBUI.scale((int)7));
            resultPanel.add((Component)jComponent, gbc);
        }
        ActionOnSaveColumnInfo.setupTableCellBackground(resultPanel, hovered);
        JPanel jPanel = resultPanel;
        if (jPanel == null) {
            ActionOnSaveColumnInfo.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    private static JPanel createActionNamePanel(@NotNull TableView<?> table2, @NotNull ActionOnSaveInfo info, @NotNull JCheckBox anchorCheckBox, int anchorBaseline) {
        if (table2 == null) {
            ActionOnSaveColumnInfo.$$$reportNull$$$0(3);
        }
        if (info == null) {
            ActionOnSaveColumnInfo.$$$reportNull$$$0(4);
        }
        if (anchorCheckBox == null) {
            ActionOnSaveColumnInfo.$$$reportNull$$$0(5);
        }
        if (info.isSaveActionApplicable()) {
            JBCheckBox checkBox = new JBCheckBox(info.getActionOnSaveName());
            checkBox.setAnchor((JComponent)anchorCheckBox);
            checkBox.setSelected(info.isActionOnSaveEnabled());
            checkBox.addActionListener(e -> {
                info.setActionOnSaveEnabled(checkBox.isSelected());
                int row2 = table2.getEditingRow();
                int column = table2.getEditingColumn();
                if (row2 >= 0 && column >= 0) {
                    table2.stopEditing();
                    table2.editCellAt(row2, column);
                }
            });
            ComponentPanelBuilder builder = UI.PanelFactory.panel((JComponent)checkBox);
            ActionOnSaveComment comment2 = info.getComment();
            if (comment2 != null) {
                builder.withComment(comment2.getCommentText(), false);
                if (comment2.isWarning()) {
                    builder.withCommentIcon(AllIcons.General.Warning);
                }
            }
            JPanel jPanel = builder.createPanel();
            if (jPanel == null) {
                ActionOnSaveColumnInfo.$$$reportNull$$$0(6);
            }
            return jPanel;
        }
        JPanel panel2 = new JPanel(new GridLayout(2, 1, 0, JBUI.scale((int)3)));
        JBLabel label2 = new JBLabel(info.getActionOnSaveName());
        int leftInsetScaled = UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)anchorCheckBox);
        Dimension labelSize = label2.getPreferredSize();
        int baselineDelta = anchorBaseline - label2.getBaseline(labelSize.width, labelSize.height);
        panel2.setBorder(new EmptyBorder(baselineDelta, leftInsetScaled, 0, 0));
        panel2.add((Component)label2);
        ActionOnSaveComment comment3 = info.getComment();
        if (comment3 != null) {
            JLabel commentComponent = ComponentPanelBuilder.createCommentComponent((String)comment3.getCommentText(), (boolean)true, (int)-1, (boolean)false);
            if (comment3.isWarning()) {
                commentComponent.setIcon(AllIcons.General.Warning);
            }
            panel2.add(commentComponent);
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ActionOnSaveColumnInfo.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    static void setupTableCellBackground(@NotNull JComponent component2, boolean hovered) {
        if (component2 == null) {
            ActionOnSaveColumnInfo.$$$reportNull$$$0(8);
        }
        Color bgColor = hovered ? JBUI.CurrentTheme.Table.Hover.background((boolean)true) : UIUtil.getTableBackground((boolean)false, (boolean)false);
        UIUtil.setOpaqueRecursively((Component)component2, (boolean)false);
        component2.setOpaque(true);
        component2.setBackground(bgColor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actionsOnSave/ActionOnSaveColumnInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorCheckBox";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actionsOnSave/ActionOnSaveColumnInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionNamePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCellComponent";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createActionNamePanel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupTableCellBackground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7 -> new IllegalStateException(string);
        };
    }
}

