/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.impl;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.ReloadMode;
import com.intellij.ide.browsers.WebBrowserService;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.ide.browsers.impl.WebBrowserServiceImplKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/browsers/impl/WebBrowserServiceImpl;", "Lcom/intellij/ide/browsers/WebBrowserService;", "<init>", "()V", "getUrlsToOpen", "", "Lcom/intellij/util/Url;", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "preferLocalUrl", "", "Companion", "intellij.platform.ide.impl"})
public final class WebBrowserServiceImpl
extends WebBrowserService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<Url> getUrlsToOpen(@NotNull OpenInBrowserRequest request, boolean preferLocalUrl) {
        Collection collection;
        VirtualFile file2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean isHtmlOrXml = WebBrowserXmlService.Companion.getInstance().isHtmlOrXmlFile(request.getFile());
        if (!preferLocalUrl || !isHtmlOrXml) {
            DumbService dumbService = DumbService.Companion.getInstance(request.getProject());
            for (WebBrowserUrlProvider urlProvider : WebBrowserServiceImplKt.access$getURL_PROVIDER_EP$p().getExtensionList()) {
                Collection urls;
                if (!dumbService.isUsableInCurrentContext((Object)urlProvider) || !urlProvider.canHandleElement(request) || (urls = WebBrowserServiceImplKt.access$getUrls(urlProvider, request)).isEmpty()) continue;
                return urls;
            }
            if (!isHtmlOrXml && !request.isForceFileUrlIfNoUrlProvider()) {
                return CollectionsKt.emptyList();
            }
        }
        VirtualFile virtualFile2 = file2 = !request.getFile().getViewProvider().isPhysical() ? null : request.getVirtualFile();
        if (!(file2 instanceof LightVirtualFile)) {
            VirtualFile virtualFile3 = file2;
            if (virtualFile3 != null) {
                collection = CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)virtualFile3));
                return collection;
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }

    @JvmStatic
    @Nullable
    public static final Url getDebuggableUrl(@Nullable PsiElement context2) {
        return Companion.getDebuggableUrl(context2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/browsers/impl/WebBrowserServiceImpl$Companion;", "", "<init>", "()V", "getProviders", "Lkotlin/sequences/Sequence;", "Lcom/intellij/ide/browsers/WebBrowserUrlProvider;", "request", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "getDebuggableUrls", "", "Lcom/intellij/util/Url;", "context", "Lcom/intellij/psi/PsiElement;", "getDebuggableUrl", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Sequence<WebBrowserUrlProvider> getProviders(@NotNull OpenInBrowserRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            DumbService dumbService = DumbService.Companion.getInstance(request.getProject());
            return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)WebBrowserServiceImplKt.access$getURL_PROVIDER_EP$p().getExtensionList()), arg_0 -> Companion.getProviders$lambda$0(dumbService, request, arg_0));
        }

        @NotNull
        public final Collection<Url> getDebuggableUrls(@Nullable PsiElement context2) {
            try {
                OpenInBrowserRequest request;
                block7: {
                    block6: {
                        PsiElement psiElement = context2;
                        OpenInBrowserRequest openInBrowserRequest = request = psiElement == null ? null : OpenInBrowserRequestKt.createOpenInBrowserRequest$default((PsiElement)psiElement, (boolean)false, (int)2, null);
                        if (request == null) break block6;
                        WebBrowserXmlService webBrowserXmlService = WebBrowserXmlService.Companion.getInstance();
                        Language language = request.getFile().getViewProvider().getBaseLanguage();
                        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getBaseLanguage(...)");
                        if (!webBrowserXmlService.isXmlLanguage(language)) break block7;
                    }
                    return CollectionsKt.emptyList();
                }
                request.setAppendAccessToken(false);
                request.setReloadMode(ReloadMode.DISABLED);
                Collection collection = (Collection)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map(this.getProviders(request), arg_0 -> Companion.getDebuggableUrls$lambda$0(request, arg_0)), (Function1)getDebuggableUrls.2.INSTANCE));
                if (collection == null) {
                    collection = CollectionsKt.emptyList();
                }
                return collection;
            }
            catch (WebBrowserUrlProvider.BrowserException ignored) {
                return CollectionsKt.emptyList();
            }
        }

        @JvmStatic
        @Nullable
        public final Url getDebuggableUrl(@Nullable PsiElement context2) {
            return (Url)ContainerUtil.getFirstItem(this.getDebuggableUrls(context2));
        }

        private static final boolean getProviders$lambda$0(DumbService $dumbService, OpenInBrowserRequest $request, WebBrowserUrlProvider it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $dumbService.isUsableInCurrentContext((Object)it) && it.canHandleElement($request);
        }

        private static final Collection getDebuggableUrls$lambda$0(OpenInBrowserRequest $request, WebBrowserUrlProvider it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return WebBrowserServiceImplKt.access$getUrls(it, $request);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

