/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.environment.impl;

import com.intellij.ide.environment.EnvironmentKey;
import com.intellij.ide.environment.impl.EnvironmentConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u001f\u0010\u000b\u001a\u00020\f2\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u000e\u00a2\u0006\u0002\b\u0010J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/environment/impl/EnvironmentUtil;", "", "<init>", "()V", "pathToEnvironmentConfig", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "getPathToConfigurationFile", "setPathToConfigurationFile", "", "path", "buildEnvironmentConfiguration", "Lcom/intellij/ide/environment/impl/EnvironmentConfiguration;", "action", "Lkotlin/Function1;", "Lcom/intellij/ide/environment/impl/EnvironmentUtil$EnvironmentFileBuilder;", "Lkotlin/ExtensionFunctionType;", "setPathTemporarily", "disposable", "Lcom/intellij/openapi/Disposable;", "EnvironmentFileBuilder", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nEnvironmentUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentUtil.kt\ncom/intellij/ide/environment/impl/EnvironmentUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n23#2:65\n23#2:66\n*S KotlinDebug\n*F\n+ 1 EnvironmentUtil.kt\ncom/intellij/ide/environment/impl/EnvironmentUtil\n*L\n30#1:65\n33#1:66\n*E\n"})
public final class EnvironmentUtil {
    @NotNull
    public static final EnvironmentUtil INSTANCE = new EnvironmentUtil();
    @NotNull
    private static final Key<Path> pathToEnvironmentConfig;

    private EnvironmentUtil() {
    }

    @Nullable
    public final Path getPathToConfigurationFile() {
        return (Path)ApplicationManager.getApplication().getUserData(pathToEnvironmentConfig);
    }

    @ApiStatus.Internal
    public final void setPathToConfigurationFile(@NotNull Path path) {
        boolean $i$f$thisLogger;
        EnvironmentUtil $this$thisLogger$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Application application = ApplicationManager.getApplication();
        Path currentPath = (Path)application.getUserData(pathToEnvironmentConfig);
        if (currentPath != null && !application.isUnitTestMode()) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(EnvironmentUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("The path to environment config can be set only once");
        }
        if (!path.isAbsolute()) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(EnvironmentUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.error("The path to environment config must be absolute");
        }
        application.putUserData(pathToEnvironmentConfig, (Object)path);
    }

    @NotNull
    public final EnvironmentConfiguration buildEnvironmentConfiguration(@NotNull Function1<? super EnvironmentFileBuilder, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        EnvironmentFileBuilder environmentFileBuilder = new EnvironmentFileBuilder();
        action2.invoke((Object)environmentFileBuilder);
        return environmentFileBuilder.build$intellij_platform_ide_impl();
    }

    @TestOnly
    public final void setPathTemporarily(@NotNull Path path, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Application application = ApplicationManager.getApplication();
        boolean bl = application.isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.setPathToConfigurationFile(path);
        Disposer.register((Disposable)disposable, () -> EnvironmentUtil.setPathTemporarily$lambda$0(application));
    }

    private static final void setPathTemporarily$lambda$0(Application $application) {
        $application.putUserData(pathToEnvironmentConfig, null);
    }

    static {
        Key key = Key.create((String)"environment.configuration.file");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        pathToEnvironmentConfig = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t*\u00020\u00062\u0006\u0010\n\u001a\u00020\u0007J\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/environment/impl/EnvironmentUtil$EnvironmentFileBuilder;", "", "<init>", "()V", "map", "", "Lcom/intellij/ide/environment/EnvironmentKey;", "", "assign", "", "value", "build", "Lcom/intellij/ide/environment/impl/EnvironmentConfiguration;", "build$intellij_platform_ide_impl", "intellij.platform.ide.impl"})
    public static final class EnvironmentFileBuilder {
        @NotNull
        private final Map<EnvironmentKey, String> map = new LinkedHashMap();

        public final void assign(@NotNull EnvironmentKey $this$assign, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)$this$assign, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (!(this.map.put($this$assign, value) == null)) {
                boolean bl = false;
                String string = "Duplicate assignment";
                throw new IllegalStateException(string.toString());
            }
        }

        @NotNull
        public final EnvironmentConfiguration build$intellij_platform_ide_impl() {
            return new EnvironmentConfiguration(this.map);
        }
    }
}

