/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class LightEditFeatureUsagesUtil
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("light.edit", 3);
    private static final EventId1<OpenPlace> OPEN_FILE_EVENT_ID = GROUP.registerEvent("open.file", (EventField)EventFields.Enum((String)"open_place", OpenPlace.class));
    private static final EventId1<Boolean> AUTO_SAVE_MODE_EVENT_ID = GROUP.registerEvent("autosave.mode", (EventField)EventFields.Boolean((String)"enabled"));
    private static final EventId1<ProjectStatus> OPEN_IN_PROJECT_EVENT_ID = GROUP.registerEvent("open.in.project", (EventField)EventFields.Enum((String)"project_status", ProjectStatus.class));

    private LightEditFeatureUsagesUtil() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void logFileOpen(@Nullable Project project2, OpenPlace openPlace) {
        OPEN_FILE_EVENT_ID.log(project2, (Object)openPlace);
    }

    public static void logAutosaveModeChanged(boolean isAutoSave) {
        AUTO_SAVE_MODE_EVENT_ID.log((Object)isAutoSave);
    }

    public static void logOpenFileInProject(@Nullable Project project2, ProjectStatus projectStatus) {
        OPEN_IN_PROJECT_EVENT_ID.log(project2, (Object)projectStatus);
    }

    public static enum OpenPlace {
        CommandLine,
        WelcomeScreenOpenAction,
        LightEditOpenAction,
        DragAndDrop,
        RecentFiles;

    }

    public static enum ProjectStatus {
        Open,
        Existing,
        New;

    }
}

