/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.menuBar;

import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class LightEditRecentFileActionGroup
extends ActionGroup
implements DumbAware {
    LightEditRecentFileActionGroup() {
        super(ApplicationBundle.messagePointer((String)"light.edit.action.recentFile.text", (Object[])new Object[0]), true);
        this.getTemplatePresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_GROUP, (Object)true);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        Project project2;
        Project project3 = project2 = e != null ? e.getProject() : null;
        if (!LightEdit.owns((Project)project2)) {
            if (AnAction.EMPTY_ARRAY == null) {
                LightEditRecentFileActionGroup.$$$reportNull$$$0(0);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List<VirtualFile> recentFiles = LightEditRecentFileActionGroup.getRecentFiles(project2);
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.addAll(ContainerUtil.map(recentFiles, file2 -> new OpenFileAction((VirtualFile)file2)));
        List<AnAction> recentProjectsActions = RecentProjectListActionProvider.getInstance().getActionsWithoutGroups(false);
        if (!recentProjectsActions.isEmpty()) {
            if (!actions.isEmpty()) {
                actions.add(Separator.create());
            }
            actions.addAll(recentProjectsActions);
        }
        AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            LightEditRecentFileActionGroup.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    private static @Unmodifiable @NotNull List<VirtualFile> getRecentFiles(@NotNull Project project2) {
        if (project2 == null) {
            LightEditRecentFileActionGroup.$$$reportNull$$$0(2);
        }
        List<VirtualFile> historyFiles = EditorHistoryManager.getInstance(project2).getFileList();
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>(historyFiles);
        Arrays.asList(FileEditorManager.getInstance((Project)project2).getOpenFiles()).forEach(result2::remove);
        List list2 = ContainerUtil.reverse(new ArrayList<VirtualFile>(result2));
        if (list2 == null) {
            LightEditRecentFileActionGroup.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/menuBar/LightEditRecentFileActionGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/menuBar/LightEditRecentFileActionGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRecentFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static final class OpenFileAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private final VirtualFile myFile;

        private OpenFileAction(@NotNull VirtualFile file2) {
            if (file2 == null) {
                OpenFileAction.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenFileAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            Project project2 = e.getProject();
            if (project2 == null) {
                presentation2.setEnabled(false);
                return;
            }
            String path = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project2, this.myFile);
            presentation2.setText(path);
            presentation2.setIcon(IconUtil.getIcon((VirtualFile)this.myFile, (int)2, (Project)project2));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                OpenFileAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                OpenFileAction.$$$reportNull$$$0(3);
            }
            if ((project2 = e.getProject()) != null) {
                LightEditUtil.markUnknownFileTypeAsPlainTextIfNeeded(project2, this.myFile);
                LightEditFeatureUsagesUtil.logFileOpen(project2, LightEditFeatureUsagesUtil.OpenPlace.RecentFiles);
                LightEditService.getInstance().openFile(this.myFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/lightEdit/menuBar/LightEditRecentFileActionGroup$OpenFileAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/lightEdit/menuBar/LightEditRecentFileActionGroup$OpenFileAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

