/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.ActionUrlComparator;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomActionsSchemaKt;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="com.intellij.ide.ui.customization.CustomActionsSchema", storages={@Storage(value="customization.xml", usePathMacroManager=false)}, category=SettingsCategory.UI)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 T2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001TB\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0014H\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0007J\u0016\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0007J\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0000J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0000J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0002H\u0016J\b\u0010*\u001a\u00020\u001dH\u0016J\u0006\u0010+\u001a\u00020\u001dJ\b\u0010,\u001a\u00020\u0002H\u0016J\u0010\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\tJ\u0018\u00100\u001a\u0004\u0018\u00010\u000f2\u0006\u0010/\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u00101J \u00100\u001a\u0004\u0018\u00010\u000f2\u0006\u0010/\u001a\u00020\t2\u0006\u00102\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u00103J\u0018\u0010-\u001a\u0004\u0018\u00010\u000f2\u0006\u0010/\u001a\u00020\t2\u0006\u00102\u001a\u00020\tJ \u00104\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\t2\u0006\u00105\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\tH\u0002J\u0010\u00106\u001a\u0004\u0018\u00010\t2\u0006\u0010/\u001a\u00020\tJ\u000e\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\tJ\u000e\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020;J\u0016\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020\tJ\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00140!2\u0006\u0010\u001f\u001a\u00020\u0014H\u0007J!\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00140!2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\t0!H\u0000\u00a2\u0006\u0002\bBJ\u000e\u0010C\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020\tJ\u0018\u0010E\u001a\u00020\u001d2\u0006\u0010D\u001a\u00020\t2\b\u0010F\u001a\u0004\u0018\u00010\tJ\u000e\u0010G\u001a\u00020\t2\u0006\u0010D\u001a\u00020\tJ\u0014\u0010H\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bJ\u0010\u0010I\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020\u0002H\u0002J\u0012\u0010K\u001a\u00020\u001d2\b\b\u0002\u0010L\u001a\u00020\u0016H\u0007J\u0010\u0010M\u001a\u00020\u001d2\u0006\u0010N\u001a\u00020OH\u0002J.\u0010P\u001a\u00020\u001d2\u0006\u0010Q\u001a\u00020.2\u0006\u0010D\u001a\u00020\t2\u0014\u0010R\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010.0SH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006U"}, d2={"Lcom/intellij/ide/ui/customization/CustomActionsSchema;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "iconCustomizations", "", "", "lock", "", "idToName", "Ljava/util/LinkedHashMap;", "idToActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "extGroupIds", "Ljava/util/HashSet;", "actions", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/ide/ui/customization/ActionUrl;", "isFirstLoadState", "", "value", "", "modificationStamp", "getModificationStamp", "()I", "setCustomizationSchemaForCurrentProjects", "", "addAction", "url", "getActions", "", "setActions", "newActions", "copyFrom", "result", "isModified", "schema", "loadState", "element", "noStateLoaded", "incrementModificationStamp", "getState", "getCorrectedAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "id", "getCorrectedActionAsync", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "name", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOrPut", "actionGroup", "getDisplayName", "invalidateCustomizedActionGroup", "groupId", "fillCorrectedActionGroups", "root", "Ljavax/swing/tree/DefaultMutableTreeNode;", "fillActionGroups", "isCorrectActionGroup", "group", "defaultGroupName", "getChildActions", "groupPath", "getChildActions$intellij_platform_ide_impl", "removeIconCustomization", "actionId", "addIconCustomization", "iconPath", "getIconPath", "getIconCustomizations", "writeIcons", "parent", "initActionIcons", "updateView", "applyIconCustomization", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "initActionIcon", "anAction", "actionSupplier", "Lkotlin/Function1;", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nCustomActionsSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomActionsSchema.kt\ncom/intellij/ide/ui/customization/CustomActionsSchema\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,638:1\n1807#2,3:639\n74#3,10:642\n74#3,10:652\n1#4:662\n*S KotlinDebug\n*F\n+ 1 CustomActionsSchema.kt\ncom/intellij/ide/ui/customization/CustomActionsSchema\n*L\n217#1:639,3\n304#1:642,10\n313#1:652,10\n*E\n"})
public final class CustomActionsSchema
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final CoroutineScope coroutineScope;
    @NotNull
    private volatile Map<String, String> iconCustomizations;
    @NotNull
    private final Object lock;
    @NotNull
    private volatile LinkedHashMap<String, String> idToName;
    @NotNull
    private volatile Map<String, ? extends ActionGroup> idToActionGroup;
    @NotNull
    private final HashSet<String> extGroupIds;
    @NotNull
    private final CopyOnWriteArrayList<ActionUrl> actions;
    private boolean isFirstLoadState;
    private int modificationStamp;
    @JvmField
    @NotNull
    public static final Key<Icon> PROP_ORIGINAL_ICON;

    public CustomActionsSchema(@Nullable CoroutineScope coroutineScope) {
        this.coroutineScope = coroutineScope;
        Map map2 = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"emptyMap(...)");
        this.iconCustomizations = map2;
        this.lock = new Object();
        Map map3 = Map.of();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"of(...)");
        this.idToActionGroup = map3;
        this.extGroupIds = new HashSet();
        this.actions = new CopyOnWriteArrayList();
        this.isFirstLoadState = true;
        LinkedHashMap<String, String> idToName = new LinkedHashMap<String, String>();
        idToName.put("MainMenu", ActionsTreeUtil.getMainMenuTitle());
        String mainToolbarID = ExperimentalUI.Companion.isNewUI() ? "MainToolbarNewUI" : "MainToolBar";
        idToName.put(mainToolbarID, ActionsTreeUtil.getMainToolbar());
        idToName.put("EditorPopupMenu", ActionsTreeUtil.getEditorPopup());
        idToName.put("EditorGutterPopupMenu", ActionsTreeUtil.getEditorGutterPopupMenu());
        idToName.put("EditorTabPopupMenu", ActionsTreeUtil.getEditorTabPopup());
        idToName.put("ProjectViewPopupMenu", ActionsTreeUtil.getProjectViewPopup());
        idToName.put("ScopeViewPopupMenu", ActionsTreeUtil.getScopeViewPopupMenu());
        idToName.put("NavbarPopupMenu", ActionsTreeUtil.getNavigationBarPopupMenu());
        idToName.put("NavBarToolBar", ActionsTreeUtil.getNavigationBarToolbar());
        CustomActionsSchemaKt.access$fillExtGroups(idToName, this.extGroupIds);
        if (this.coroutineScope != null) {
            CustomActionsSchemaKt.access$getEP_NAME$p().addChangeListener(this.coroutineScope, () -> CustomActionsSchema._init_$lambda$0(idToName, this));
        }
        idToName.putAll(CustomActionsSchemaKt.access$getAdditionalIdToName$p());
        this.idToName = idToName;
    }

    public final int getModificationStamp() {
        return this.modificationStamp;
    }

    public final void setCustomizationSchemaForCurrentProjects() {
        block1: {
            this.incrementModificationStamp();
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project2 : projectArray) {
                Intrinsics.checkNotNull((Object)project2);
                Project project3 = project2;
                ProjectFrameHelper projectFrameHelper = windowManager.getFrameHelper(project3);
                if (projectFrameHelper == null) continue;
                projectFrameHelper.updateView();
            }
            ProjectFrameHelper projectFrameHelper = windowManager.getFrameHelper(null);
            if (projectFrameHelper == null) break block1;
            projectFrameHelper.updateView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final void addAction(@NotNull ActionUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.actions.contains(url) && !this.actions.remove(url.getInverted())) {
                this.actions.add(url);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public final List<ActionUrl> getActions() {
        List<ActionUrl> list2 = Collections.unmodifiableList((List)this.actions);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(...)");
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final void setActions(@NotNull List<ActionUrl> newActions) {
        Intrinsics.checkNotNullParameter(newActions, (String)"newActions");
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = this.actions != newActions;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.actions.clear();
            this.actions.addAll((Collection<ActionUrl>)newActions);
            CollectionsKt.sortWith((List)this.actions, (Comparator)ActionUrlComparator.INSTANCE);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyFrom(@NotNull CustomActionsSchema result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Map map2 = Map.of();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"of(...)");
            this.idToActionGroup = map2;
            this.actions.clear();
            List<String> ids = List.copyOf((Collection)this.iconCustomizations.keySet());
            HashMap<String, String> iconCustomizations = new HashMap<String, String>();
            Iterator<ActionUrl> iterator2 = result2.actions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Object> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                ActionUrl actionUrl = iterator3.next();
                ActionUrl actionUrl2 = actionUrl.copy();
                Intrinsics.checkNotNullExpressionValue((Object)actionUrl2, (String)"copy(...)");
                this.addAction(actionUrl2);
            }
            CollectionsKt.sortWith((List)this.actions, (Comparator)ActionUrlComparator.INSTANCE);
            iconCustomizations.putAll(result2.iconCustomizations);
            for (String id2 : ids) {
                iconCustomizations.putIfAbsent(id2, null);
            }
            Map map3 = Collections.unmodifiableMap((Map)iconCustomizations);
            Intrinsics.checkNotNullExpressionValue(map3, (String)"unmodifiableMap(...)");
            this.iconCustomizations = map3;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isModified(@NotNull CustomActionsSchema schema) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            List<ActionUrl> storedActions = schema.getActions();
            if (ApplicationManager.getApplication().isUnitTestMode() && !storedActions.isEmpty()) {
                Object[] objectArray = new Object[]{storedActions};
                CustomActionsSchemaKt.access$getLOG$p().error(IdeBundle.message((String)"custom.action.stored", (Object[])objectArray));
                objectArray = new Object[]{this.getActions()};
                CustomActionsSchemaKt.access$getLOG$p().error(IdeBundle.message((String)"custom.action.actual", (Object[])objectArray));
            }
            if (storedActions.size() != this.getActions().size()) {
                return true;
            }
            int n = ((Collection)this.getActions()).size();
            for (int i2 = 0; i2 < n; ++i2) {
                if (Intrinsics.areEqual((Object)this.getActions().get(i2), (Object)storedActions.get(i2))) continue;
                return true;
            }
            if (schema.iconCustomizations.size() != this.iconCustomizations.size()) {
                return true;
            }
            Iterable $this$any$iv = this.iconCustomizations.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)schema.getIconPath(it), (Object)this.getIconPath(it)))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Ref.BooleanRef reload = new Ref.BooleanRef();
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                Map map2 = Map.of();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"of(...)");
                this.idToActionGroup = map2;
                this.actions.clear();
                Element schElement = element;
                String activeName = element.getAttributeValue("active");
                if (activeName != null) {
                    block3: for (Element toolbarElement : element.getChildren("custom_actions_schema")) {
                        for (Element o : toolbarElement.getChildren("option")) {
                            if (!Intrinsics.areEqual((Object)o.getAttributeValue("name"), (Object)"myName") || !Intrinsics.areEqual((Object)o.getAttributeValue("value"), (Object)activeName)) continue;
                            Intrinsics.checkNotNull((Object)toolbarElement);
                            schElement = toolbarElement;
                            continue block3;
                        }
                    }
                }
                for (Element groupElement : schElement.getChildren("group")) {
                    ActionUrl url = new ActionUrl();
                    url.readExternal(groupElement);
                    this.addAction(url);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    Object[] objectArray = new Object[]{this.actions.toString()};
                    CustomActionsSchemaKt.access$getLOG$p().error(IdeBundle.message((String)"custom.option.testmode", (Object[])objectArray));
                }
                HashMap<String, String> iconCustomizations = new HashMap<String, String>();
                for (Element action2 : element.getChildren("action")) {
                    String actionId;
                    if (action2.getAttributeValue("id") == null) continue;
                    iconCustomizations.put(actionId, action2.getAttributeValue("icon"));
                }
                boolean bl2 = reload.element = !this.isFirstLoadState;
                if (this.isFirstLoadState) {
                    this.isFirstLoadState = false;
                }
                Map map3 = Collections.unmodifiableMap((Map)iconCustomizations);
                Intrinsics.checkNotNullExpressionValue(map3, (String)"unmodifiableMap(...)");
                this.iconCustomizations = map3;
                Unit unit = Unit.INSTANCE;
            }
            CoroutineScope coroutineScope = this.coroutineScope;
            if (coroutineScope == null) break block10;
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, reload, null){
                int I$0;
                int I$1;
                Object L$0;
                int label;
                final /* synthetic */ CustomActionsSchema this$0;
                final /* synthetic */ Ref.BooleanRef $reload;
                {
                    this.this$0 = $receiver;
                    this.$reload = $reload;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (CustomActionsSchema.access$getIconCustomizations$p(this.this$0).isEmpty()) ** GOTO lbl38
                            $i$f$serviceAsync = 0;
                            v0 = ApplicationManager.getApplication();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getApplication(...)");
                            $this$serviceAsync$iv$iv = (ComponentManager)v0;
                            $i$f$serviceAsync = 0;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                            this.I$0 = $i$f$serviceAsync;
                            this.I$1 = $i$f$serviceAsync;
                            this.label = 1;
                            v1 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(ActionManager.class, (Continuation)this);
                            if (v1 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl27
                        }
                        case 1: {
                            $i$f$serviceAsync = this.I$1;
                            $i$f$serviceAsync = this.I$0;
                            $this$serviceAsync$iv$iv = (ComponentManager)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl27:
                            // 2 sources

                            actionManager = (ActionManager)v1;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)actionManager);
                            this.label = 2;
                            v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, actionManager, null){
                                int label;
                                final /* synthetic */ CustomActionsSchema this$0;
                                final /* synthetic */ ActionManager $actionManager;
                                {
                                    this.this$0 = $receiver;
                                    this.$actionManager = $actionManager;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            CustomActionsSchema.access$applyIconCustomization(this.this$0, this.$actionManager);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl38
                        }
                        case 2: {
                            actionManager = (ActionManager)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl38:
                            // 3 sources

                            if (this.$reload.element) {
                                this.L$0 = null;
                                this.label = 3;
                                v3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ CustomActionsSchema this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.this$0.setCustomizationSchemaForCurrentProjects();
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v3 == var6_2) {
                                    return var6_2;
                                }
                            }
                            ** GOTO lbl48
                        }
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl48:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public void noStateLoaded() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.loadState(new Element("State"));
        }
    }

    public final void incrementModificationStamp() {
        int n = this.modificationStamp;
        this.modificationStamp = n + 1;
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        Iterator<ActionUrl> iterator2 = this.actions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<ActionUrl> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            ActionUrl group2 = iterator3.next();
            Element groupElement = new Element("group");
            group2.writeExternal(groupElement);
            element.addContent(groupElement);
        }
        this.writeIcons(element);
        return element;
    }

    @Nullable
    public final AnAction getCorrectedAction(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        String string = this.idToName.get(id2);
        if (string == null) {
            return ActionManager.getInstance().getAction(id2);
        }
        String name2 = string;
        return (AnAction)this.getCorrectedAction(id2, name2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getCorrectedActionAsync(@NotNull String id, @NotNull Continuation<? super ActionGroup> $completion) {
        if (!($completion instanceof getCorrectedActionAsync.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ CustomActionsSchema this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getCorrectedActionAsync(null, (Continuation<? super ActionGroup>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.idToName.get(id);
                if (v0 != null) break;
                $i$f$serviceAsync = 0;
                v1 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getApplication(...)");
                $this$serviceAsync$iv$iv = (ComponentManager)v1;
                $i$f$serviceAsync = 0;
                $continuation.L$0 = id;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.I$1 = $i$f$serviceAsync;
                $continuation.label = 1;
                v2 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(ActionManager.class, (Continuation)$continuation);
                if (v2 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl37
            }
            case 1: {
                $i$f$serviceAsync = $continuation.I$1;
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv$iv = (ComponentManager)$continuation.L$1;
                id = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl37:
                // 2 sources

                var4_12 = ((ActionManager)v2).getAction(id);
                return var4_12 instanceof ActionGroup != false ? (ActionGroup)var4_12 : null;
            }
        }
        name = v0;
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)id);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)name);
        $continuation.label = 2;
        v3 = this.getCorrectedActionAsync(id, name, (Continuation<? super ActionGroup>)$continuation);
        if (v3 == var10_5) {
            return var10_5;
        }
        ** GOTO lbl52
        {
            case 2: {
                name = (String)$continuation.L$1;
                id = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl52:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getCorrectedActionAsync(@NotNull String id, @NotNull String name, @NotNull Continuation<? super ActionGroup> $completion) {
        if (!($completion instanceof getCorrectedActionAsync.2)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ CustomActionsSchema this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getCorrectedActionAsync(null, null, (Continuation<? super ActionGroup>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.idToActionGroup.get(id);
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-CustomActionsSchema$getCorrectedActionAsync$3 = false;
                    return it;
                }
                $i$f$serviceAsync = 0;
                v1 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getApplication(...)");
                $this$serviceAsync$iv$iv = (ComponentManager)v1;
                $i$f$serviceAsync = 0;
                $continuation.L$0 = id;
                $continuation.L$1 = name;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv$iv);
                $continuation.I$0 = $i$f$serviceAsync;
                $continuation.I$1 = $i$f$serviceAsync;
                $continuation.label = 1;
                v2 = ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(ActionManager.class, (Continuation)$continuation);
                if (v2 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl42
            }
            case 1: {
                $i$f$serviceAsync = $continuation.I$1;
                $i$f$serviceAsync = $continuation.I$0;
                $this$serviceAsync$iv$iv = (ComponentManager)$continuation.L$2;
                name = (String)$continuation.L$1;
                id = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl42:
                // 2 sources

                var5_8 = ((ActionManager)v2).getAction(id);
                v3 = var5_8 instanceof ActionGroup != false ? (ActionGroup)var5_8 : null;
                if (v3 == null) {
                    return null;
                }
                actionGroup = v3;
                return this.getOrPut(id, actionGroup, name);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final ActionGroup getCorrectedAction(@NotNull String id2, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ActionGroup actionGroup = this.idToActionGroup.get(id2);
        if (actionGroup != null) {
            ActionGroup it = actionGroup;
            boolean bl = false;
            return it;
        }
        AnAction anAction = ActionManager.getInstance().getAction(id2);
        ActionGroup actionGroup2 = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
        if (actionGroup2 == null) {
            return null;
        }
        ActionGroup actionGroup3 = actionGroup2;
        return this.getOrPut(id2, actionGroup3, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ActionGroup getOrPut(String id2, ActionGroup actionGroup, String name2) {
        ActionGroup actionGroup2 = this.idToActionGroup.get(id2);
        if (actionGroup2 != null) {
            ActionGroup it = actionGroup2;
            boolean bl = false;
            return it;
        }
        ActionGroup corrected = CustomizationUtil.correctActionGroup(actionGroup, this, name2, name2, true);
        Object object = this.lock;
        synchronized (object) {
            block5: {
                boolean bl = false;
                ActionGroup actionGroup3 = this.idToActionGroup.get(id2);
                if (actionGroup3 == null) break block5;
                ActionGroup it = actionGroup3;
                boolean bl2 = false;
                ActionGroup actionGroup4 = it;
                return actionGroup4;
            }
            this.idToActionGroup = UtilKt.with(this.idToActionGroup, (Object)id2, (Object)corrected);
            Unit unit = Unit.INSTANCE;
        }
        Intrinsics.checkNotNull((Object)corrected);
        return corrected;
    }

    @Nullable
    public final String getDisplayName(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.idToName.get(id2);
    }

    public final void invalidateCustomizedActionGroup(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        ActionGroup group2 = this.idToActionGroup.get(groupId);
        if (group2 instanceof CustomisedActionGroup) {
            ((CustomisedActionGroup)group2).resetChildren();
        }
    }

    public final void fillCorrectedActionGroups(@NotNull DefaultMutableTreeNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ActionManager actionManager = ActionManager.getInstance();
        SmartList path = new SmartList((Object)"root");
        for (Map.Entry entry : ((Map)this.idToName).entrySet()) {
            ActionGroup actionGroup;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            AnAction anAction = actionManager.getAction(key);
            if ((anAction instanceof ActionGroup ? (ActionGroup)anAction : null) == null) continue;
            actionGroup = actionGroup;
            root.add(ActionsTreeUtil.createNode(ActionsTreeUtil.createCorrectedGroup(actionGroup, value, (List)path, (List<ActionUrl>)this.actions)));
        }
    }

    public final void fillActionGroups(@NotNull DefaultMutableTreeNode root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ActionManager actionManager = ActionManager.getInstance();
        for (Map.Entry entry : ((Map)this.idToName).entrySet()) {
            ActionGroup actionGroup;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            AnAction anAction = actionManager.getAction(key);
            if ((anAction instanceof ActionGroup ? (ActionGroup)anAction : null) == null) continue;
            actionGroup = actionGroup;
            root.add(ActionsTreeUtil.createNode(ActionsTreeUtil.createGroup(actionGroup, value, null, true, null, false)));
        }
    }

    public final boolean isCorrectActionGroup(@NotNull ActionGroup group2, @NotNull String defaultGroupName) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)defaultGroupName, (String)"defaultGroupName");
        if (this.actions.isEmpty()) {
            return false;
        }
        String text2 = group2.getTemplatePresentation().getText();
        Object object = text2;
        if (object == null || object.length() == 0) {
            return true;
        }
        Iterator<ActionUrl> iterator2 = this.actions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        object = iterator2;
        while (object.hasNext()) {
            String id2;
            ActionUrl url = (ActionUrl)object.next();
            if (url.getGroupPath().contains(text2) || url.getGroupPath().contains(defaultGroupName)) {
                return true;
            }
            if (!(url.getComponent() instanceof Group)) continue;
            Object object2 = url.getComponent();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.openapi.keymap.impl.ui.Group");
            Group urlGroup = (Group)object2;
            if (urlGroup.getChildren().isEmpty()) continue;
            String string = urlGroup.getName();
            if (string == null) {
                string = urlGroup.getId();
            }
            if ((id2 = string) != null && !Intrinsics.areEqual((Object)id2, (Object)text2) && !Intrinsics.areEqual((Object)id2, (Object)defaultGroupName)) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    @NotNull
    public final List<ActionUrl> getChildActions(@NotNull ActionUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ArrayList<String> arrayList = url.getGroupPath();
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"getGroupPath(...)");
        return this.getChildActions$intellij_platform_ide_impl((List<String>)arrayList);
    }

    @NotNull
    public final List<ActionUrl> getChildActions$intellij_platform_ide_impl(@NotNull List<String> groupPath) {
        Intrinsics.checkNotNullParameter(groupPath, (String)"groupPath");
        ArrayList<ActionUrl> result2 = new ArrayList<ActionUrl>();
        Iterator<ActionUrl> iterator2 = this.actions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<ActionUrl> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            int index;
            ActionUrl actionUrl = iterator3.next();
            if (groupPath.size() > actionUrl.getGroupPath().size()) continue;
            for (index = 0; index < groupPath.size() && Intrinsics.areEqual((Object)groupPath.get(index), (Object)actionUrl.getGroupPath().get(index)); ++index) {
            }
            if (index != groupPath.size()) continue;
            result2.add(actionUrl);
        }
        return result2;
    }

    public final void removeIconCustomization(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        this.iconCustomizations = UtilKt.with(this.iconCustomizations, (Object)actionId, null);
    }

    public final void addIconCustomization(@NotNull String actionId, @Nullable String iconPath) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        String string = iconPath;
        this.iconCustomizations = UtilKt.with(this.iconCustomizations, (Object)actionId, (Object)(string == null ? null : FileUtil.toSystemIndependentName((String)string)));
    }

    @NotNull
    public final String getIconPath(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        String string = this.iconCustomizations.get(actionId);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final Map<String, String> getIconCustomizations() {
        Map<String, String> map2 = Collections.unmodifiableMap(this.iconCustomizations);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        return map2;
    }

    private final void writeIcons(Element parent) {
        for (String actionId : this.iconCustomizations.keySet()) {
            String icon2 = this.iconCustomizations.get(actionId);
            if (icon2 == null) continue;
            Element action2 = new Element("action");
            action2.setAttribute("id", actionId);
            action2.setAttribute("icon", icon2);
            parent.addContent(action2);
        }
    }

    @JvmOverloads
    public final void initActionIcons(boolean updateView2) {
        block2: {
            if (!this.iconCustomizations.isEmpty()) {
                ActionManager actionManager = ActionManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"getInstance(...)");
                this.applyIconCustomization(actionManager);
            }
            if (!updateView2) break block2;
            ProjectFrameHelper projectFrameHelper = WindowManagerEx.getInstanceEx().getFrameHelper(null);
            if (projectFrameHelper != null) {
                projectFrameHelper.updateView();
            }
        }
    }

    public static /* synthetic */ void initActionIcons$default(CustomActionsSchema customActionsSchema, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        customActionsSchema.initActionIcons(bl);
    }

    private final void applyIconCustomization(ActionManager actionManager) {
        for (String actionId : this.iconCustomizations.keySet()) {
            AnAction action2 = actionManager.getActionOrStub(actionId);
            if (action2 == null || action2 instanceof ActionStub) continue;
            this.initActionIcon(action2, actionId, (Function1<? super String, ? extends AnAction>)((Function1)arg_0 -> CustomActionsSchema.applyIconCustomization$lambda$0(actionManager, arg_0)));
            PresentationFactory.updatePresentation(action2);
        }
    }

    @ApiStatus.Internal
    public final void initActionIcon(@NotNull AnAction anAction, @NotNull String actionId, @NotNull Function1<? super String, ? extends AnAction> actionSupplier) {
        Object object;
        Icon originalIcon;
        Presentation presentation2;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)anAction, (String)"anAction");
                Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
                Intrinsics.checkNotNullParameter(actionSupplier, (String)"actionSupplier");
                CustomActionsSchemaKt.access$getLOG$p().assertTrue(!(anAction instanceof ActionStub));
                Presentation presentation3 = anAction.getTemplatePresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"getTemplatePresentation(...)");
                presentation2 = presentation3;
                originalIcon = presentation2.getIcon();
                if (presentation2.getClientProperty(PROP_ORIGINAL_ICON) == null && anAction.isDefaultIcon() && originalIcon != null) {
                    presentation2.putClientProperty(PROP_ORIGINAL_ICON, (Object)originalIcon);
                }
                if ((object = this.iconCustomizations.get(actionId)) == null) break block4;
                String it = object;
                boolean bl = false;
                Icon icon2 = CustomActionsSchemaKt.getIconForPath(actionSupplier, it);
                object = icon2;
                if (icon2 != null) break block5;
            }
            object = (Icon)presentation2.getClientProperty(PROP_ORIGINAL_ICON);
        }
        Object icon3 = object;
        presentation2.setIcon((Icon)icon3);
        Object object2 = icon3;
        presentation2.setDisabledIcon((Icon)(object2 == null ? null : IconLoader.getDisabledIcon((Icon)object2)));
        anAction.setDefaultIcon(Intrinsics.areEqual((Object)icon3, (Object)originalIcon));
    }

    @JvmOverloads
    public final void initActionIcons() {
        CustomActionsSchema.initActionIcons$default(this, false, 1, null);
    }

    private static final void _init_$lambda$0(LinkedHashMap $idToName, CustomActionsSchema this$0) {
        CustomActionsSchemaKt.access$fillExtGroups($idToName, this$0.extGroupIds);
    }

    private static final AnAction applyIconCustomization$lambda$0(ActionManager $actionManager, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $actionManager.getAction(it);
    }

    @JvmStatic
    public static final void addSettingsGroup(@NotNull String itemId, @NotNull String itemName) {
        Companion.addSettingsGroup(itemId, itemName);
    }

    @JvmStatic
    public static final void removeSettingsGroup(@NotNull String itemId) {
        Companion.removeSettingsGroup(itemId);
    }

    @JvmStatic
    @NotNull
    public static final CustomActionsSchema getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Map access$getIconCustomizations$p(CustomActionsSchema $this) {
        return $this.iconCustomizations;
    }

    public static final /* synthetic */ void access$applyIconCustomization(CustomActionsSchema $this, ActionManager actionManager) {
        $this.applyIconCustomization(actionManager);
    }

    static {
        Key key = Key.create((String)"originalIcon");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PROP_ORIGINAL_ICON = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000b\u0010\u000b\u001a\u00070\n\u00a2\u0006\u0002\b\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0011R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/ui/customization/CustomActionsSchema$Companion;", "", "<init>", "()V", "PROP_ORIGINAL_ICON", "Lcom/intellij/openapi/util/Key;", "Ljavax/swing/Icon;", "addSettingsGroup", "", "itemId", "", "itemName", "Lorg/jetbrains/annotations/Nls;", "removeSettingsGroup", "getInstance", "Lcom/intellij/ide/ui/customization/CustomActionsSchema;", "getInstanceAsync", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nCustomActionsSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomActionsSchema.kt\ncom/intellij/ide/ui/customization/CustomActionsSchema$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,638:1\n55#2:639\n55#2:640\n42#2,3:641\n74#3,10:644\n*S KotlinDebug\n*F\n+ 1 CustomActionsSchema.kt\ncom/intellij/ide/ui/customization/CustomActionsSchema$Companion\n*L\n119#1:639\n130#1:640\n137#1:641,3\n139#1:644,10\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void addSettingsGroup(@NotNull String itemId, @NotNull String itemName) {
            void it;
            LinkedHashMap linkedHashMap;
            Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
            Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
            CustomActionsSchemaKt.access$getAdditionalIdToName$p().put(itemId, itemName);
            boolean $i$f$serviceIfCreated22 = false;
            Application application = ApplicationManager.getApplication();
            CustomActionsSchema customActionsSchema = (CustomActionsSchema)(application != null ? application.getServiceIfCreated(CustomActionsSchema.class) : null);
            if (customActionsSchema == null) {
                return;
            }
            CustomActionsSchema customActionSchema = customActionsSchema;
            LinkedHashMap $i$f$serviceIfCreated22 = linkedHashMap = new LinkedHashMap(customActionSchema.idToName);
            CustomActionsSchema customActionsSchema2 = customActionSchema;
            boolean bl = false;
            it.put(itemId, itemName);
            customActionsSchema2.idToName = linkedHashMap;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void removeSettingsGroup(@NotNull String itemId) {
            void it;
            LinkedHashMap linkedHashMap;
            Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
            CustomActionsSchemaKt.access$getAdditionalIdToName$p().remove(itemId);
            boolean $i$f$serviceIfCreated22 = false;
            Application application = ApplicationManager.getApplication();
            CustomActionsSchema customActionsSchema = (CustomActionsSchema)(application != null ? application.getServiceIfCreated(CustomActionsSchema.class) : null);
            if (customActionsSchema == null) {
                return;
            }
            CustomActionsSchema customActionSchema = customActionsSchema;
            LinkedHashMap $i$f$serviceIfCreated22 = linkedHashMap = new LinkedHashMap(customActionSchema.idToName);
            CustomActionsSchema customActionsSchema2 = customActionSchema;
            boolean bl = false;
            it.remove(itemId);
            customActionsSchema2.idToName = linkedHashMap;
        }

        @JvmStatic
        @NotNull
        public final CustomActionsSchema getInstance() {
            boolean $i$f$service = false;
            Class<CustomActionsSchema> serviceClass$iv = CustomActionsSchema.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CustomActionsSchema)object;
        }

        @Nullable
        public final Object getInstanceAsync(@NotNull Continuation<? super CustomActionsSchema> $completion) {
            boolean $i$f$serviceAsync = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$serviceAsync$iv$iv = (ComponentManager)application;
            boolean $i$f$serviceAsync2 = false;
            return ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(CustomActionsSchema.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

