/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.AsyncDetector;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\u0004H\u0016R\"\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ide/ui/laf/WindowsDetector;", "Lcom/intellij/ide/ui/laf/AsyncDetector;", "syncFunction", "Ljava/util/function/BiConsumer;", "", "<init>", "(Ljava/util/function/BiConsumer;)V", "getSyncFunction", "()Ljava/util/function/BiConsumer;", "detectionSupported", "getDetectionSupported", "()Z", "isDark", "Companion", "intellij.platform.ide.impl"})
final class WindowsDetector
extends AsyncDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BiConsumer<Boolean, Boolean> syncFunction;
    @NonNls
    @NotNull
    public static final String REGISTRY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
    @NonNls
    @NotNull
    public static final String REGISTRY_VALUE = "AppsUseLightTheme";

    public WindowsDetector(@NotNull BiConsumer<Boolean, Boolean> syncFunction) {
        Intrinsics.checkNotNullParameter(syncFunction, (String)"syncFunction");
        this.syncFunction = syncFunction;
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.lightTheme.on", arg_0 -> WindowsDetector._init_$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public BiConsumer<Boolean, Boolean> getSyncFunction() {
        return this.syncFunction;
    }

    @Override
    public boolean getDetectionSupported() {
        return SystemInfo.isWin10OrNewer && JnaLoader.isLoaded();
    }

    @Override
    public boolean isDark() {
        try {
            return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) && Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) == 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static final void lambda$0$0(WindowsDetector this$0, PropertyChangeEvent $e) {
        this$0.getSyncFunction().accept(!Intrinsics.areEqual((Object)$e.getNewValue(), (Object)true), null);
    }

    private static final void _init_$lambda$0(WindowsDetector this$0, PropertyChangeEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ApplicationManager.getApplication().invokeLater(() -> WindowsDetector.lambda$0$0(this$0, e), ModalityState.any());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/ui/laf/WindowsDetector$Companion;", "", "<init>", "()V", "REGISTRY_PATH", "", "REGISTRY_VALUE", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

