/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NonNull;

@ApiStatus.Internal
public final class CommandProcessorImpl
extends CoreCommandProcessor
implements Disposable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishCommand(@NotNull CommandToken command, @Nullable Throwable throwable) {
        if (command == null) {
            CommandProcessorImpl.$$$reportNull$$$0(0);
        }
        if (!this.isCommandTokenActive(command)) {
            return;
        }
        boolean isPCE = throwable instanceof ProcessCanceledException;
        try {
            if (throwable != null && !isPCE) {
                ExceptionUtil.rethrowUnchecked((Throwable)throwable);
                LOG.error(throwable);
            }
        }
        finally {
            try {
                super.finishCommand(command, throwable);
            }
            catch (Throwable e) {
                if (throwable != null && throwable != e) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        if (throwable != null) {
            boolean showTooComplexDialog = !isPCE;
            CommandProcessorImpl.undoLastOperation(command, showTooComplexDialog);
        }
    }

    public void markCurrentCommandAsGlobal(@Nullable Project project2) {
        CommandProcessorImpl.getUndoManager(project2).markCurrentCommandAsGlobal();
    }

    public void dispose() {
    }

    public void addAffectedDocuments(@Nullable Project project2, Document ... docs) {
        if (docs == null) {
            CommandProcessorImpl.$$$reportNull$$$0(1);
        }
        CommandProcessorImpl.getUndoManager(project2).addAffectedDocuments(docs);
    }

    public void addAffectedFiles(@Nullable Project project2, VirtualFile ... files2) {
        if (files2 == null) {
            CommandProcessorImpl.$$$reportNull$$$0(2);
        }
        CommandProcessorImpl.getUndoManager(project2).addAffectedFiles(files2);
    }

    private static void undoLastOperation(@NonNull CommandToken command, boolean showTooComplexDialog) {
        FileEditor editor2;
        UndoManagerImpl undoManager;
        Project project2 = command.getProject();
        if (project2 != null && (undoManager = CommandProcessorImpl.getUndoManager(project2)).isUndoAvailable(editor2 = undoManager.getEditorProvider().getCurrentEditor(project2))) {
            undoManager.undo(editor2);
        }
        if (showTooComplexDialog) {
            Messages.showErrorDialog((Project)project2, (String)IdeBundle.message((String)"dialog.message.cannot.perform.operation.too.complex.sorry", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.failed.to.perform.operation", (Object[])new Object[0]));
        }
    }

    private static UndoManagerImpl getUndoManager(@Nullable Project project2) {
        UndoManager undoManager = project2 != null ? UndoManager.getInstance((Project)project2) : UndoManager.getGlobalInstance();
        return (UndoManagerImpl)undoManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CommandProcessorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "finishCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedDocuments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

