/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.UndoReportHandler;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UndoProblemReport {
    @Nullable
    private final Project project;
    private final boolean isUndo;

    UndoProblemReport(@Nullable Project project2, boolean isUndo) {
        this.project = project2;
        this.isUndo = isUndo;
    }

    void reportNonUndoable(@Nls @NotNull String operationName, @NotNull Collection<? extends DocumentReference> problemFiles) {
        if (operationName == null) {
            UndoProblemReport.$$$reportNull$$$0(0);
        }
        if (problemFiles == null) {
            UndoProblemReport.$$$reportNull$$$0(1);
        }
        UndoProblemReport.doWithReportHandler(handler2 -> handler2.reportNonUndoable(this.project, operationName, problemFiles, this.isUndo));
    }

    void reportClashingDocuments(@NotNull Collection<? extends DocumentReference> problemFiles) {
        if (problemFiles == null) {
            UndoProblemReport.$$$reportNull$$$0(2);
        }
        UndoProblemReport.doWithReportHandler(handler2 -> handler2.reportClashingDocuments(this.project, problemFiles, this.isUndo));
    }

    void reportCannotAdjust(@NotNull Collection<? extends DocumentReference> problemFiles) {
        if (problemFiles == null) {
            UndoProblemReport.$$$reportNull$$$0(3);
        }
        UndoProblemReport.doWithReportHandler(handler2 -> handler2.reportCannotAdjust(this.project, problemFiles, this.isUndo));
    }

    void reportException(@NotNull UnexpectedUndoException e) {
        if (e == null) {
            UndoProblemReport.$$$reportNull$$$0(4);
        }
        UndoProblemReport.doWithReportHandler(handler2 -> handler2.reportException(this.project, e, this.isUndo));
    }

    private static void doWithReportHandler(@NotNull Predicate<? super UndoReportHandler> condition) {
        if (condition == null) {
            UndoProblemReport.$$$reportNull$$$0(5);
        }
        for (UndoReportHandler handler2 : UndoReportHandler.EP_NAME.getExtensionList()) {
            if (!condition.test(handler2)) continue;
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/UndoProblemReport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reportNonUndoable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reportClashingDocuments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportCannotAdjust";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportException";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doWithReportHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

