/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ColorProvider;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.softwrap.ArrowSoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.TextBasedSoftWrapPainter;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeSoftWrapPainter
implements SoftWrapPainter {
    @ApiStatus.Internal
    public static final String CUSTOM_BEFORE_SOFT_WRAP_SIGN_KEY = "idea.editor.wrap.soft.before.code";
    @ApiStatus.Internal
    public static final String CUSTOM_AFTER_SOFT_WRAP_SIGN_KEY = "idea.editor.wrap.soft.after.code";
    private static final Logger LOG;
    private static final List<Map<SoftWrapDrawingType, Character>> SYMBOLS;
    private final EditorEx myEditor;
    private SoftWrapPainter myDelegate;
    private int mySymbolsDrawingIndex = -1;

    public CompositeSoftWrapPainter(EditorEx editor2) {
        this.myEditor = editor2;
    }

    @Nullable
    private static Character parse(String key) {
        int code;
        String value = System.getProperty(key);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        try {
            code = Integer.parseInt(value, 16);
        }
        catch (NumberFormatException e) {
            LOG.info(String.format("Detected invalid code for system property '%s' - '%s'. Expected to find hex number there. Custom soft wraps signs will not be applied", key, value));
            return null;
        }
        return Character.valueOf((char)code);
    }

    @Override
    public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            CompositeSoftWrapPainter.$$$reportNull$$$0(0);
        }
        if (drawingType == null) {
            CompositeSoftWrapPainter.$$$reportNull$$$0(1);
        }
        this.initDelegateIfNecessary();
        return this.myDelegate.paint(g, drawingType, x, y, lineHeight);
    }

    @Override
    public int getDrawingHorizontalOffset(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            CompositeSoftWrapPainter.$$$reportNull$$$0(2);
        }
        if (drawingType == null) {
            CompositeSoftWrapPainter.$$$reportNull$$$0(3);
        }
        this.initDelegateIfNecessary();
        return this.myDelegate.getDrawingHorizontalOffset(g, drawingType, x, y, lineHeight);
    }

    @Override
    public int getMinDrawingWidth(@NotNull SoftWrapDrawingType drawingType) {
        if (drawingType == null) {
            CompositeSoftWrapPainter.$$$reportNull$$$0(4);
        }
        this.initDelegateIfNecessary();
        return this.myDelegate.getMinDrawingWidth(drawingType);
    }

    @Override
    public boolean canUse() {
        return true;
    }

    private void initDelegateIfNecessary() {
        if (this.myDelegate != null && this.myDelegate.canUse()) {
            return;
        }
        if (++this.mySymbolsDrawingIndex < SYMBOLS.size()) {
            TextDrawingCallback callback = this.myEditor.getTextDrawingCallback();
            ColorProvider colorHolder = ColorProvider.byColorScheme(this.myEditor, EditorColors.SOFT_WRAP_SIGN_COLOR);
            this.myDelegate = new TextBasedSoftWrapPainter(SYMBOLS.get(this.mySymbolsDrawingIndex), this.myEditor, callback, colorHolder);
            this.initDelegateIfNecessary();
            return;
        }
        this.myDelegate = new ArrowSoftWrapPainter(this.myEditor);
    }

    @Override
    public void reinit() {
        this.myDelegate = null;
        this.mySymbolsDrawingIndex = -1;
    }

    private static <K, V> Map<K, V> asMap(Iterable<? extends K> keys, Iterable<? extends V> values2) throws IllegalArgumentException {
        HashMap<K, V> result2 = new HashMap<K, V>();
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values2.iterator();
        while (keyIterator.hasNext()) {
            if (!valueIterator.hasNext()) {
                throw new IllegalArgumentException(String.format("Can't build for the given data. Reason: number of keys differs from number of values. Keys: %s, values: %s", keys, values2));
            }
            result2.put(keyIterator.next(), valueIterator.next());
        }
        if (valueIterator.hasNext()) {
            throw new IllegalArgumentException(String.format("Can't build for the given data. Reason: number of keys differs from number of values. Keys: %s, values: %s", keys, values2));
        }
        return result2;
    }

    static {
        Character customAfterSymbol;
        LOG = Logger.getInstance(CompositeSoftWrapPainter.class);
        SYMBOLS = new ArrayList<Map<SoftWrapDrawingType, Character>>();
        Character customBeforeSymbol = CompositeSoftWrapPainter.parse(CUSTOM_BEFORE_SOFT_WRAP_SIGN_KEY);
        if (customBeforeSymbol != null && (customAfterSymbol = CompositeSoftWrapPainter.parse(CUSTOM_AFTER_SOFT_WRAP_SIGN_KEY)) != null) {
            LOG.info(String.format("Picked up custom soft wrap drawing symbols: '%c' and '%c'", customBeforeSymbol, customAfterSymbol));
            SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(customBeforeSymbol, customAfterSymbol)));
        }
        SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\u2926'), Character.valueOf('\u2925'))));
        SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\u21b2'), Character.valueOf('\u21b3'))));
        SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\u2936'), Character.valueOf('\u2937'))));
        SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\u21a9'), Character.valueOf('\u21aa'))));
        SYMBOLS.add(CompositeSoftWrapPainter.asMap(Arrays.asList(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED, SoftWrapDrawingType.AFTER_SOFT_WRAP), Arrays.asList(Character.valueOf('\ue48b'), Character.valueOf('\ue48c'))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawingType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/softwrap/CompositeSoftWrapPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDrawingHorizontalOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinDrawingWidth";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

