/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.zombie;

import com.intellij.openapi.editor.impl.zombie.FingerprintedZombie;
import com.intellij.openapi.editor.impl.zombie.FingerprintedZombieImpl;
import com.intellij.openapi.editor.impl.zombie.Necromancy;
import com.intellij.openapi.editor.impl.zombie.Zombie;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/editor/impl/zombie/FingerprintedExternalizer;", "Z", "Lcom/intellij/openapi/editor/impl/zombie/Zombie;", "Lcom/intellij/util/io/DataExternalizer;", "Lcom/intellij/openapi/editor/impl/zombie/FingerprintedZombie;", "necromancy", "Lcom/intellij/openapi/editor/impl/zombie/Necromancy;", "<init>", "(Lcom/intellij/openapi/editor/impl/zombie/Necromancy;)V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "value", "intellij.platform.ide.impl"})
final class FingerprintedExternalizer<Z extends Zombie>
implements DataExternalizer<FingerprintedZombie<Z>> {
    @NotNull
    private final Necromancy<Z> necromancy;

    public FingerprintedExternalizer(@NotNull Necromancy<Z> necromancy) {
        Intrinsics.checkNotNullParameter(necromancy, (String)"necromancy");
        this.necromancy = necromancy;
    }

    @NotNull
    public FingerprintedZombie<Z> read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long fingerprint = DataInputOutputUtil.readLONG((DataInput)input);
        Z zombie = this.necromancy.exhumeZombie(input);
        return new FingerprintedZombieImpl<Z>(fingerprint, zombie);
    }

    public void save(@NotNull DataOutput output, @NotNull FingerprintedZombie<Z> value) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        DataInputOutputUtil.writeLONG((DataOutput)output, (long)value.fingerprint());
        this.necromancy.buryZombie(output, value.zombie());
    }
}

