/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.state;

import com.intellij.openapi.editor.state.CustomOutValueModifier;
import com.intellij.openapi.editor.state.ObservableState;
import com.intellij.openapi.editor.state.StateProperty;
import com.intellij.openapi.editor.state.SyncDefaultValueCalculator;
import com.intellij.openapi.util.Ref;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B/\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001d\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\u00028\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/editor/state/ObjectStateProperty;", "T", "Lcom/intellij/openapi/editor/state/StateProperty;", "initialValue", "defaultValueCalculator", "Lcom/intellij/openapi/editor/state/SyncDefaultValueCalculator;", "customOutValueModifier", "Lcom/intellij/openapi/editor/state/CustomOutValueModifier;", "<init>", "(Ljava/lang/Object;Lcom/intellij/openapi/editor/state/SyncDefaultValueCalculator;Lcom/intellij/openapi/editor/state/CustomOutValueModifier;)V", "overriddenValue", "Ljava/lang/Object;", "value", "", "isValueOverridden", "()Z", "outValue", "getValue", "()Ljava/lang/Object;", "thisRef", "Lcom/intellij/openapi/editor/state/ObservableState;", "(Lcom/intellij/openapi/editor/state/ObservableState;)Ljava/lang/Object;", "setValue", "", "(Lcom/intellij/openapi/editor/state/ObservableState;Ljava/lang/Object;)V", "clearOverriding", "recalculate", "updateOutValueAndFireEventIfNeed", "calculatedOutValue", "intellij.platform.ide.impl"})
public class ObjectStateProperty<T>
extends StateProperty<T> {
    @NotNull
    private final SyncDefaultValueCalculator<T> defaultValueCalculator;
    @Nullable
    private final CustomOutValueModifier<T> customOutValueModifier;
    @Nullable
    private T overriddenValue;
    private boolean isValueOverridden;
    private T outValue;

    public ObjectStateProperty(T initialValue, @NotNull SyncDefaultValueCalculator<T> defaultValueCalculator, @Nullable CustomOutValueModifier<T> customOutValueModifier) {
        Intrinsics.checkNotNullParameter(defaultValueCalculator, (String)"defaultValueCalculator");
        this.defaultValueCalculator = defaultValueCalculator;
        this.customOutValueModifier = customOutValueModifier;
        this.outValue = initialValue;
    }

    public /* synthetic */ ObjectStateProperty(Object object, SyncDefaultValueCalculator syncDefaultValueCalculator, CustomOutValueModifier customOutValueModifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            customOutValueModifier = null;
        }
        this(object, syncDefaultValueCalculator, customOutValueModifier);
    }

    public final boolean isValueOverridden() {
        return this.isValueOverridden;
    }

    protected final T getValue() {
        return this.outValue;
    }

    @Override
    public T getValue(@NotNull ObservableState thisRef) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        return this.outValue;
    }

    @Override
    public void setValue(@NotNull ObservableState thisRef, T value) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        if (this.isValueOverridden && Intrinsics.areEqual(this.overriddenValue, value)) {
            return;
        }
        this.overriddenValue = value;
        this.isValueOverridden = true;
        this.recalculate(thisRef);
    }

    @Override
    public void clearOverriding(@NotNull ObservableState thisRef) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        if (!this.isValueOverridden) {
            return;
        }
        this.isValueOverridden = false;
        this.overriddenValue = null;
        this.recalculate(thisRef);
    }

    @Override
    public void recalculate(@NotNull ObservableState thisRef) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        if (this.isValueOverridden) {
            this.updateOutValueAndFireEventIfNeed(thisRef, this.overriddenValue);
            return;
        }
        if (this.defaultValueCalculator instanceof SyncDefaultValueCalculator) {
            T newVal = this.defaultValueCalculator.calculate();
            this.updateOutValueAndFireEventIfNeed(thisRef, newVal);
            return;
        }
        throw new IllegalStateException(this.defaultValueCalculator.toString());
    }

    private final void updateOutValueAndFireEventIfNeed(ObservableState thisRef, T calculatedOutValue) {
        CustomOutValueModifier<T> newOutValue;
        CustomOutValueModifier<T> customOutValueModifier = this.customOutValueModifier;
        if (customOutValueModifier == null || (customOutValueModifier = customOutValueModifier.modifyOutValue(calculatedOutValue)) == null) {
            customOutValueModifier = calculatedOutValue;
        }
        if (!Intrinsics.areEqual(newOutValue = customOutValueModifier, this.outValue)) {
            T oldOut = this.outValue;
            this.outValue = newOutValue;
            thisRef.propertyChanged(this.getName(), (Ref<Object>)new Ref(oldOut), newOutValue);
        }
    }
}

