/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.impl.EditorTabs;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0014J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0002R\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/fileEditor/impl/EditorTabLabel;", "Lcom/intellij/ui/tabs/impl/TabLabel;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "tabs", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "<init>", "(Lcom/intellij/ui/tabs/TabInfo;Lcom/intellij/ui/tabs/impl/JBTabsImpl;)V", "getPreferredSize", "Ljava/awt/Dimension;", "updateUI", "", "updateFont", "getPreferredHeight", "", "isShowTabActions", "", "()Z", "isTabActionsOnTheRight", "shouldPaintFadeout", "editLabelForeground", "Ljava/awt/Color;", "baseForeground", "getIconAlpha", "", "paintDimmed", "intellij.platform.ide.impl"})
final class EditorTabLabel
extends TabLabel {
    public EditorTabLabel(@NotNull TabInfo info, @NotNull JBTabsImpl tabs) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)tabs, (String)"tabs");
        super(tabs, info);
        this.updateFont();
    }

    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.getPreferredHeight());
    }

    public void updateUI() {
        super.updateUI();
        this.updateFont();
    }

    private final void updateFont() {
        if (ExperimentalUI.Companion.isNewUI()) {
            Font font = JBUI.CurrentTheme.EditorTabs.font();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font(...)");
            Font font2 = font;
            GuiUtils.iterateChildren((Component)((Component)((Object)this)), arg_0 -> EditorTabLabel.updateFont$lambda$1(arg_0 -> EditorTabLabel.updateFont$lambda$0(font2, arg_0), arg_0), (JComponent[])new JComponent[0]);
        }
    }

    private final int getPreferredHeight() {
        JBTabsImpl jBTabsImpl = this.tabs;
        Intrinsics.checkNotNull((Object)jBTabsImpl, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.EditorTabs");
        Insets insets = ((EditorTabs)jBTabsImpl).getTabLabelInsets().getUnscaled();
        int height = JBUI.scale((int)(28 - insets.top - insets.bottom));
        Insets layoutInsets = this.tabs.getLayoutInsets();
        return height - layoutInsets.top - layoutInsets.bottom;
    }

    protected boolean isShowTabActions() {
        return this.isPinned() || UISettings.Companion.getInstance().getShowCloseButton();
    }

    protected boolean isTabActionsOnTheRight() {
        return UISettings.Companion.getInstance().getCloseTabButtonOnTheRight();
    }

    protected boolean shouldPaintFadeout() {
        return super.shouldPaintFadeout() && Registry.Companion.is("ide.editor.tabs.show.fadeout", true);
    }

    @Nullable
    public Color editLabelForeground(@Nullable Color baseForeground) {
        if (baseForeground != null && this.paintDimmed()) {
            float blendValue = JBUI.CurrentTheme.EditorTabs.unselectedBlend();
            return ColorUtil.blendColorsInRgb((Color)this.getEffectiveBackground(), (Color)baseForeground, (double)blendValue);
        }
        return baseForeground;
    }

    public float getIconAlpha() {
        return this.paintDimmed() ? JBUI.CurrentTheme.EditorTabs.unselectedAlpha() : 1.0f;
    }

    private final boolean paintDimmed() {
        return ExperimentalUI.Companion.isNewUI() && !Intrinsics.areEqual((Object)this.tabs.getSelectedInfo(), (Object)this.getInfo()) && !this.tabs.isHoveredTab((TabLabel)this);
    }

    private static final Unit updateFont$lambda$0(Font $font, Component c) {
        c.setFont($font);
        return Unit.INSTANCE;
    }

    private static final void updateFont$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

