/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.project.IncompleteDependenciesModeStatisticsCollector;
import com.intellij.openapi.project.IncompleteDependenciesService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\bH\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0018\u0010\u0016\u001a\u00060\rR\u00020\u00002\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0003J\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\rR\u00020\u0000H\u0003J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u001a\u0012\b\u0012\u00060\rR\u00020\u00000\fj\f\u0012\b\u0012\u00060\rR\u00020\u0000`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/project/IncompleteDependenciesServiceImpl;", "Lcom/intellij/openapi/project/IncompleteDependenciesService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/openapi/project/IncompleteDependenciesService$DependenciesState;", "getStateFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "tokens", "Ljava/util/HashSet;", "Lcom/intellij/openapi/project/IncompleteDependenciesServiceImpl$IncompleteDependenciesAccessTokenImpl;", "Lkotlin/collections/HashSet;", "incompleteModeActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "getState", "enterIncompleteState", "Lcom/intellij/openapi/project/IncompleteDependenciesService$IncompleteDependenciesAccessToken;", "requestor", "", "issueToken", "Ljava/lang/Class;", "deregisterToken", "", "token", "updateState", "stateBefore", "stateAfter", "IncompleteDependenciesAccessTokenImpl", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIncompleteDependenciesServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncompleteDependenciesServiceImpl.kt\ncom/intellij/openapi/project/IncompleteDependenciesServiceImpl\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,93:1\n230#2,5:94\n*S KotlinDebug\n*F\n+ 1 IncompleteDependenciesServiceImpl.kt\ncom/intellij/openapi/project/IncompleteDependenciesServiceImpl\n*L\n79#1:94,5\n*E\n"})
public final class IncompleteDependenciesServiceImpl
implements IncompleteDependenciesService {
    @NotNull
    private final Project project;
    @NotNull
    private final MutableStateFlow<IncompleteDependenciesService.DependenciesState> stateFlow;
    @NotNull
    private final HashSet<IncompleteDependenciesAccessTokenImpl> tokens;
    @Nullable
    private StructuredIdeActivity incompleteModeActivity;

    public IncompleteDependenciesServiceImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.stateFlow = StateFlowKt.MutableStateFlow((Object)IncompleteDependenciesService.DependenciesState.COMPLETE);
        this.tokens = new HashSet();
    }

    @NotNull
    public MutableStateFlow<IncompleteDependenciesService.DependenciesState> getStateFlow() {
        return this.stateFlow;
    }

    @RequiresReadLock
    @NotNull
    public IncompleteDependenciesService.DependenciesState getState() {
        ThreadingAssertions.assertReadAccess();
        return (IncompleteDependenciesService.DependenciesState)this.getStateFlow().getValue();
    }

    @RequiresWriteLock
    @NotNull
    public IncompleteDependenciesService.IncompleteDependenciesAccessToken enterIncompleteState(@NotNull Object requestor) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        return this.issueToken(requestor.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresWriteLock
    private final IncompleteDependenciesAccessTokenImpl issueToken(Class<?> requestor) {
        ThreadingAssertions.assertWriteAccess();
        HashSet<IncompleteDependenciesAccessTokenImpl> hashSet = this.tokens;
        synchronized (hashSet) {
            boolean bl = false;
            IncompleteDependenciesAccessTokenImpl lastToken = (IncompleteDependenciesAccessTokenImpl)((Object)CollectionsKt.lastOrNull((Iterable)this.tokens));
            IncompleteDependenciesService.DependenciesState stateBefore = lastToken == null ? IncompleteDependenciesService.DependenciesState.COMPLETE : IncompleteDependenciesService.DependenciesState.INCOMPLETE;
            IncompleteDependenciesService.DependenciesState stateAfter = IncompleteDependenciesService.DependenciesState.INCOMPLETE;
            StructuredIdeActivity structuredIdeActivity = this.incompleteModeActivity;
            if (structuredIdeActivity == null) {
                StructuredIdeActivity newActivity;
                boolean bl2;
                IncompleteDependenciesServiceImpl $this$issueToken_u24lambda_u240_u240 = this;
                boolean bl3 = false;
                boolean bl4 = bl2 = stateBefore == IncompleteDependenciesService.DependenciesState.COMPLETE;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                $this$issueToken_u24lambda_u240_u240.incompleteModeActivity = newActivity = IncompleteDependenciesModeStatisticsCollector.INSTANCE.incompleteModeStarted($this$issueToken_u24lambda_u240_u240.project);
                structuredIdeActivity = newActivity;
            }
            StructuredIdeActivity currentIncompleteModeActivity = structuredIdeActivity;
            StructuredIdeActivity subtaskActivity = IncompleteDependenciesModeStatisticsCollector.INSTANCE.incompleteModeSubtaskStarted(this.project, currentIncompleteModeActivity, requestor, stateBefore, stateAfter);
            IncompleteDependenciesAccessTokenImpl token = new IncompleteDependenciesAccessTokenImpl(subtaskActivity, requestor);
            this.tokens.add(token);
            this.updateState(stateBefore, stateAfter);
            IncompleteDependenciesAccessTokenImpl incompleteDependenciesAccessTokenImpl = token;
            return incompleteDependenciesAccessTokenImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresWriteLock
    private final void deregisterToken(IncompleteDependenciesAccessTokenImpl token) {
        ThreadingAssertions.assertWriteAccess();
        HashSet<IncompleteDependenciesAccessTokenImpl> hashSet = this.tokens;
        synchronized (hashSet) {
            boolean bl = false;
            this.tokens.remove((Object)token);
            IncompleteDependenciesService.DependenciesState stateBefore = IncompleteDependenciesService.DependenciesState.INCOMPLETE;
            IncompleteDependenciesService.DependenciesState stateAfter = this.tokens.isEmpty() ? IncompleteDependenciesService.DependenciesState.COMPLETE : IncompleteDependenciesService.DependenciesState.INCOMPLETE;
            IncompleteDependenciesModeStatisticsCollector.INSTANCE.incompleteModeSubtaskFinished(token.getSubtaskActivity(), token.getRequestor(), stateBefore, stateAfter);
            if (stateAfter == IncompleteDependenciesService.DependenciesState.COMPLETE) {
                boolean bl2;
                boolean bl3 = bl2 = this.incompleteModeActivity != null;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                IncompleteDependenciesModeStatisticsCollector.INSTANCE.incompleteModeFinished(this.incompleteModeActivity);
                this.incompleteModeActivity = null;
            }
            this.updateState(stateBefore, stateAfter);
            Unit unit = Unit.INSTANCE;
        }
    }

    @RequiresWriteLock
    private final void updateState(IncompleteDependenciesService.DependenciesState stateBefore, IncompleteDependenciesService.DependenciesState stateAfter) {
        ThreadingAssertions.assertWriteAccess();
        if (stateAfter != stateBefore) {
            IncompleteDependenciesService.DependenciesState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<IncompleteDependenciesService.DependenciesState> $this$update$iv = this.getStateFlow();
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                IncompleteDependenciesService.DependenciesState it = (IncompleteDependenciesService.DependenciesState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = stateAfter)));
            if (stateAfter.isComplete() && !this.project.isDisposed()) {
                PsiManager.getInstance((Project)this.project).dropPsiCaches();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/project/IncompleteDependenciesServiceImpl$IncompleteDependenciesAccessTokenImpl;", "Lcom/intellij/openapi/project/IncompleteDependenciesService$IncompleteDependenciesAccessToken;", "subtaskActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "requestor", "Ljava/lang/Class;", "<init>", "(Lcom/intellij/openapi/project/IncompleteDependenciesServiceImpl;Lcom/intellij/internal/statistic/StructuredIdeActivity;Ljava/lang/Class;)V", "getSubtaskActivity", "()Lcom/intellij/internal/statistic/StructuredIdeActivity;", "getRequestor", "()Ljava/lang/Class;", "finish", "", "intellij.platform.ide.impl"})
    private final class IncompleteDependenciesAccessTokenImpl
    extends IncompleteDependenciesService.IncompleteDependenciesAccessToken {
        @NotNull
        private final StructuredIdeActivity subtaskActivity;
        @NotNull
        private final Class<?> requestor;

        public IncompleteDependenciesAccessTokenImpl(@NotNull StructuredIdeActivity subtaskActivity, Class<?> requestor) {
            Intrinsics.checkNotNullParameter((Object)subtaskActivity, (String)"subtaskActivity");
            Intrinsics.checkNotNullParameter(requestor, (String)"requestor");
            this.subtaskActivity = subtaskActivity;
            this.requestor = requestor;
        }

        @NotNull
        public final StructuredIdeActivity getSubtaskActivity() {
            return this.subtaskActivity;
        }

        @NotNull
        public final Class<?> getRequestor() {
            return this.requestor;
        }

        @RequiresWriteLock
        public void finish() {
            IncompleteDependenciesServiceImpl.this.deregisterToken(this);
        }
    }
}

