/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndexContributor;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetRegistrar;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

final class ExcludeRootsCache {
    private volatile CachedUrls myCache;

    ExcludeRootsCache(@NotNull SimpleMessageBusConnection connection) {
        if (connection == null) {
            ExcludeRootsCache.$$$reportNull$$$0(0);
        }
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExcludeRootsCache.this.myCache = null;
            }

            public void projectClosed(@NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExcludeRootsCache.this.myCache = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/project/impl/ExcludeRootsCache$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    List<String> getExcludedUrls() {
        List list2 = (List)ReadAction.compute(() -> {
            Object[] urls;
            CachedUrls cache2 = this.myCache;
            long actualModCount = Arrays.stream(ProjectManager.getInstance().getOpenProjects()).mapToLong(project2 -> {
                WorkspaceModelInternal workspaceModel = (WorkspaceModelInternal)WorkspaceModel.getInstance((Project)project2);
                return workspaceModel.getEntityStorage().getVersion();
            }).sum();
            if (cache2 != null && actualModCount == cache2.myModificationCount) {
                urls = cache2.myUrls;
            } else {
                HashSet<String> excludedUrls = new HashSet<String>();
                for (Project project3 : ProjectManager.getInstance().getOpenProjects()) {
                    WorkspaceModel workspaceModel = WorkspaceModel.getInstance((Project)project3);
                    ImmutableEntityStorage storage = workspaceModel.getCurrentSnapshot();
                    ExtensionPointName EP_NAME = ExtensionPointName.create((String)"com.intellij.workspaceModel.fileIndexContributor");
                    ExcludedRootsCollector collector = new ExcludedRootsCollector();
                    for (WorkspaceFileIndexContributor contributor : EP_NAME.getExtensionList()) {
                        ExcludeRootsCache.collectExcludedRootsFromContributor(contributor, (EntityStorage)storage, collector);
                    }
                    excludedUrls.addAll(collector.getExcludedUrls());
                    for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)project3)) {
                        for (Module module : ModuleManager.getInstance((Project)project3).getModules()) {
                            Object[] additionalModuleExcludedRoots = policy.getExcludeRootsForModule((ModuleRootModel)ModuleRootManager.getInstance((Module)module));
                            excludedUrls.addAll(ContainerUtil.map((Object[])additionalModuleExcludedRoots, VirtualFilePointer::getUrl));
                        }
                    }
                }
                urls = ArrayUtilRt.toStringArray(excludedUrls);
                Arrays.sort(urls);
                this.myCache = new CachedUrls(actualModCount, (String[])urls);
            }
            return Arrays.asList(urls);
        });
        if (list2 == null) {
            ExcludeRootsCache.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private static <E extends WorkspaceEntity> void collectExcludedRootsFromContributor(WorkspaceFileIndexContributor<E> contributor, EntityStorage storage, ExcludedRootsCollector collector) {
        Iterable entities = SequencesKt.asIterable((Sequence)storage.entities(contributor.getEntityClass()));
        for (WorkspaceEntity entity : entities) {
            contributor.registerFileSets(entity, (WorkspaceFileSetRegistrar)collector, storage);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/impl/ExcludeRootsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/impl/ExcludeRootsCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class CachedUrls {
        private final long myModificationCount;
        private final String @NotNull [] myUrls;

        /*
         * WARNING - void declaration
         */
        private CachedUrls(long count, String @NotNull [] stringArray) {
            void urls;
            if (stringArray == null) {
                CachedUrls.$$$reportNull$$$0(0);
            }
            this.myModificationCount = count;
            this.myUrls = urls;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/openapi/project/impl/ExcludeRootsCache$CachedUrls", "<init>"));
        }
    }

    private static class ExcludedRootsCollector
    implements WorkspaceFileSetRegistrar {
        private final Set<String> excludedUrls = new HashSet<String>();

        private ExcludedRootsCollector() {
        }

        public void registerFileSet(@NotNull VirtualFileUrl root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, WorkspaceFileSetData customData) {
            if (root == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(1);
            }
            if (entity == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(2);
            }
        }

        public void registerFileSet(@NotNull VirtualFile root, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, WorkspaceFileSetData customData) {
            if (root == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(3);
            }
            if (kind == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(4);
            }
            if (entity == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(5);
            }
        }

        public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceEntity entity) {
            if (excludedRoot == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(6);
            }
            if (entity == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(7);
            }
            this.excludedUrls.add(excludedRoot.getUrl());
        }

        public void registerExcludedRoot(@NotNull VirtualFileUrl excludedRoot, @NotNull WorkspaceFileKind excludedFrom, @NotNull WorkspaceEntity entity) {
            if (excludedRoot == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(8);
            }
            if (excludedFrom == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(9);
            }
            if (entity == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(10);
            }
            this.excludedUrls.add(excludedRoot.getUrl());
        }

        public void registerExclusionPatterns(@NotNull VirtualFileUrl root, @NotNull List<String> patterns, @NotNull WorkspaceEntity entity) {
            if (root == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(11);
            }
            if (patterns == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(12);
            }
            if (entity == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(13);
            }
        }

        public void registerExclusionCondition(@NotNull VirtualFileUrl root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull WorkspaceEntity entity) {
            if (root == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(14);
            }
            if (condition == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(15);
            }
            if (entity == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(16);
            }
        }

        public void registerNonRecursiveFileSet(@NotNull VirtualFileUrl file2, @NotNull WorkspaceFileKind kind, @NotNull WorkspaceEntity entity, WorkspaceFileSetData customData) {
            if (file2 == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(17);
            }
            if (kind == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(18);
            }
            if (entity == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(19);
            }
        }

        @NotNull
        Set<String> getExcludedUrls() {
            Set<String> set = this.excludedUrls;
            if (set == null) {
                ExcludedRootsCollector.$$$reportNull$$$0(20);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 20 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 4: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 10: 
                case 13: 
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entity";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "excludedRoot";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "excludedFrom";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/project/impl/ExcludeRootsCache$ExcludedRootsCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/project/impl/ExcludeRootsCache$ExcludedRootsCollector";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExcludedUrls";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "registerFileSet";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "registerExcludedRoot";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "registerExclusionPatterns";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "registerExclusionCondition";
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "registerNonRecursiveFileSet";
                    break;
                }
                case 20: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 20 -> new IllegalStateException(string);
            };
        }
    }
}

