/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IntRef;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.MathUtil;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class GentleFlusherBase
implements Runnable,
Closeable {
    private static final Set<GentleFlusherBase> REGISTERED_FLUSHERS = new HashSet<GentleFlusherBase>(2);
    protected final Logger log;
    protected final long flushingPeriodMs;
    private final long regularCheckingPeriodMs;
    private final long quickReCheckingPeriodMs;
    private final int maxContentionQuota;
    private final int minContentionQuota;
    private int contentionQuotaPerTurn;
    private ScheduledFuture<?> scheduledFuture;
    private final ScheduledExecutorService scheduler;
    private final AtomicInteger totalQuotaSpent;
    private final AtomicLong totalFlushingTimeUs;
    private final AtomicInteger totalFlushes;
    private final AtomicInteger totalFlushesRetried;
    private final BatchCallback otelMonitoringHandle;

    /*
     * WARNING - void declaration
     */
    public GentleFlusherBase(@NotNull String flusherName, @NotNull ScheduledExecutorService scheduler, long flushingPeriodMs, int minContentionQuota, int maxContentionQuota, int initialContentionQuota, @Nullable Meter meter) {
        void otelMeter;
        if (flusherName == null) {
            GentleFlusherBase.$$$reportNull$$$0(0);
        }
        if (scheduler == null) {
            GentleFlusherBase.$$$reportNull$$$0(1);
        }
        this.log = Logger.getInstance(this.getClass());
        this.totalQuotaSpent = new AtomicInteger(0);
        this.totalFlushingTimeUs = new AtomicLong(0L);
        this.totalFlushes = new AtomicInteger(0);
        this.totalFlushesRetried = new AtomicInteger(0);
        if (minContentionQuota < 0) {
            throw new IllegalArgumentException("minContentionQuota(=" + minContentionQuota + ") must be >=0");
        }
        if (maxContentionQuota < 0) {
            throw new IllegalArgumentException("maxContentionQuota(=" + maxContentionQuota + ") must be >=0");
        }
        if (maxContentionQuota <= minContentionQuota) {
            throw new IllegalArgumentException("minContentionQuota(=" + minContentionQuota + ") must be < maxContentionQuota(=" + maxContentionQuota + ")");
        }
        this.contentionQuotaPerTurn = MathUtil.clamp((int)initialContentionQuota, (int)minContentionQuota, (int)maxContentionQuota);
        this.minContentionQuota = minContentionQuota;
        this.maxContentionQuota = maxContentionQuota;
        if (flushingPeriodMs <= 0L) {
            throw new IllegalArgumentException("flushingPeriod(=" + flushingPeriodMs + ") must be >0");
        }
        this.flushingPeriodMs = flushingPeriodMs;
        this.regularCheckingPeriodMs = flushingPeriodMs / 5L;
        this.quickReCheckingPeriodMs = this.regularCheckingPeriodMs / 10L;
        this.scheduler = scheduler;
        this.scheduledFuture = this.scheduler.schedule(this, this.regularCheckingPeriodMs, TimeUnit.MILLISECONDS);
        this.otelMonitoringHandle = otelMeter != null ? this.setupOTelReporting((Meter)otelMeter, flusherName) : null;
        REGISTERED_FLUSHERS.add(this);
    }

    @NotNull
    public static Set<GentleFlusherBase> getRegisteredFlushers() {
        Set<GentleFlusherBase> set = REGISTERED_FLUSHERS;
        if (set == null) {
            GentleFlusherBase.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public synchronized void run() {
        try {
            if (this.betterPostponeFlushNow()) {
                this.log.debug("Flush short-circuit -> schedule next turn earlier");
                this.scheduledFuture = this.scheduler.schedule(this, this.quickReCheckingPeriodMs, TimeUnit.MILLISECONDS);
                return;
            }
            long startedAtNs = System.nanoTime();
            IntRef contentionQuota = new IntRef(this.contentionQuotaPerTurn);
            FlushResult flushResult = this.flushAsMuchAsPossibleWithinQuota(contentionQuota);
            long finishedAtNs = System.nanoTime();
            int unspentQuota = contentionQuota.get();
            int previousQuotaPerTurn = this.contentionQuotaPerTurn;
            this.totalQuotaSpent.addAndGet(previousQuotaPerTurn - unspentQuota);
            switch (flushResult.ordinal()) {
                case 0: {
                    this.totalFlushingTimeUs.addAndGet(TimeUnit.NANOSECONDS.toMicros(finishedAtNs - startedAtNs));
                    this.totalFlushes.incrementAndGet();
                    if (0 < unspentQuota && unspentQuota < previousQuotaPerTurn) {
                        this.contentionQuotaPerTurn = MathUtil.clamp((int)(this.contentionQuotaPerTurn - 1), (int)this.minContentionQuota, (int)this.maxContentionQuota);
                    }
                    this.scheduledFuture = this.scheduler.schedule(this, this.regularCheckingPeriodMs, TimeUnit.MILLISECONDS);
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Flushed everything: contention quota(" + previousQuotaPerTurn + " -> " + unspentQuota + ") -> next turn scheduled regularly, with quota: " + this.contentionQuotaPerTurn);
                    break;
                }
                case 1: {
                    this.totalFlushingTimeUs.addAndGet(TimeUnit.NANOSECONDS.toMicros(finishedAtNs - startedAtNs));
                    this.totalFlushes.incrementAndGet();
                    this.totalFlushesRetried.incrementAndGet();
                    if (unspentQuota < 0) {
                        this.contentionQuotaPerTurn = MathUtil.clamp((int)(this.contentionQuotaPerTurn * 2), (int)this.minContentionQuota, (int)this.maxContentionQuota);
                    }
                    this.scheduledFuture = this.scheduler.schedule(this, this.quickReCheckingPeriodMs, TimeUnit.MILLISECONDS);
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Flush something, but more remains: contention quota(" + previousQuotaPerTurn + " -> " + unspentQuota + ") -> next turn scheduled early, with quota: " + this.contentionQuotaPerTurn);
                    break;
                }
                case 2: {
                    this.scheduledFuture = this.scheduler.schedule(this, this.regularCheckingPeriodMs, TimeUnit.MILLISECONDS);
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Nothing to flush now: contention quota(" + previousQuotaPerTurn + " -> " + unspentQuota + ") -> next turn scheduled regularly, with quota: " + this.contentionQuotaPerTurn + " unchanged");
                }
            }
        }
        catch (InterruptedException e) {
            this.log.error("Flushing thread interrupted -> exiting", (Throwable)e);
        }
        catch (AlreadyDisposedException | RejectedExecutionException e) {
            this.log.warn("Stop flushing: pool is shutting down or whole application is closing", e);
        }
        catch (Throwable t) {
            this.log.warn("Unhandled exception during flush (reschedule regularly)", t);
            this.scheduledFuture = this.scheduler.schedule(this, this.regularCheckingPeriodMs, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void close() {
        REGISTERED_FLUSHERS.remove(this);
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
        if (this.otelMonitoringHandle != null) {
            this.otelMonitoringHandle.close();
        }
    }

    protected abstract boolean betterPostponeFlushNow();

    protected abstract FlushResult flushAsMuchAsPossibleWithinQuota(IntRef var1) throws Exception;

    public abstract boolean hasSomethingToFlush();

    protected BatchCallback setupOTelReporting(@NotNull Meter meter, @NotNull String flusherName) {
        if (meter == null) {
            GentleFlusherBase.$$$reportNull$$$0(3);
        }
        if (flusherName == null) {
            GentleFlusherBase.$$$reportNull$$$0(4);
        }
        ObservableLongMeasurement spentQuotaCounter = meter.counterBuilder(flusherName + ".totalContentionQuotaSpent").setUnit("1").setDescription("How many contention flush met in a period").buildObserver();
        ObservableLongMeasurement flushingTimeCounter = meter.counterBuilder(flusherName + ".totalFlushingTimeUs").setUnit("microseconds").setDescription("Total time spent by flushing in a period").buildObserver();
        ObservableLongMeasurement flushesCounter = meter.counterBuilder(flusherName + ".totalFlushes").setUnit("1").setDescription("How many flushes done in a period (both: regular and retried)").buildObserver();
        ObservableLongMeasurement retriedFlushesCounter = meter.counterBuilder(flusherName + ".totalFlushesRetried").setUnit("1").setDescription("How many flushes retried in a period").buildObserver();
        return meter.batchCallback(() -> {
            spentQuotaCounter.record(this.totalQuotaSpent.longValue());
            flushingTimeCounter.record(this.totalFlushingTimeUs.longValue());
            flushesCounter.record(this.totalFlushes.longValue());
            retriedFlushesCounter.record(this.totalFlushesRetried.longValue());
        }, (ObservableMeasurement)spentQuotaCounter, new ObservableMeasurement[]{flushingTimeCounter, flushesCounter, retriedFlushesCounter});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flusherName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheduler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/GentleFlusherBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/GentleFlusherBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFlushers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupOTelReporting";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    protected static enum FlushResult {
        FLUSHED_ALL,
        HAS_MORE_TO_FLUSH,
        NOTHING_TO_FLUSH_NOW;


        public boolean needsMoreToFlush() {
            return this == HAS_MORE_TO_FLUSH;
        }

        public FlushResult and(FlushResult another) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (another == HAS_MORE_TO_FLUSH) {
                        yield HAS_MORE_TO_FLUSH;
                    }
                    yield FLUSHED_ALL;
                }
                case 1 -> HAS_MORE_TO_FLUSH;
                case 2 -> another;
            };
        }
    }
}

