/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.ContentTooBigException;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.Utf8BomOptionProvider;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.BulkFileListenerBackgroundable;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.CompoundVFileEvent;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileDeletedException;
import com.intellij.openapi.vfs.newvfs.impl.FsRoot;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VfsThreadingUtil;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.BatchingFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecordsImpl;
import com.intellij.openapi.vfs.newvfs.persistent.IPersistentFSRecordsStorage;
import com.intellij.openapi.vfs.newvfs.persistent.ListResult;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFsConnectionListener;
import com.intellij.openapi.vfs.newvfs.persistent.VFSInitException;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSRecoveryInfo;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.Suppressions;
import com.intellij.util.SystemProperties;
import com.intellij.util.UriUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.ReplicatorInputStream;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class PersistentFSImpl
extends PersistentFS
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PersistentFSImpl.class);
    private static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(LOG, TimeUnit.SECONDS.toMillis(30L));
    private static final int READ_ACCESS_CHECK_NONE = 0;
    private static final int READ_ACCESS_CHECK_REQUIRE_RA_SOFT = 1;
    private static final int READ_ACCESS_CHECK_REQUIRE_RA_HARD = 2;
    private static final int READ_ACCESS_CHECK_REQUIRE_NO_RA = 3;
    private static final int READ_ACCESS_CHECK_KIND = SystemProperties.getIntProperty((String)"vfs.read-access-check-kind", (int)0);
    private static final boolean LOG_NON_CACHED_ROOTS_LIST = SystemProperties.getBooleanProperty((String)"PersistentFSImpl.LOG_NON_CACHED_ROOTS_LIST", (boolean)false);
    private final Application app;
    private final Map<String, VirtualFileSystemEntry> rootsByUrl;
    private final IntSet missedRootIds;
    private final AtomicBoolean connected;
    private volatile FSRecordsImpl vfsPeer;
    private volatile VfsData vfsData;
    private final AtomicInteger structureModificationCount;
    private BulkFileListener publisher;
    private BulkFileListenerBackgroundable publisherBackgroundable;
    private final AtomicLong fileByIdCacheHits;
    private final AtomicLong fileByIdCacheMisses;
    private final AtomicLong childByName;
    private final AtomicLong caseSensitivityReads;
    private final BatchCallback otelMonitoringHandle;
    private static final int INNER_ARRAYS_THRESHOLD = 4096;
    private static final Hash.Strategy<VFileCreateEvent> CASE_INSENSITIVE_STRATEGY = new Hash.Strategy<VFileCreateEvent>(){

        public int hashCode(@Nullable VFileCreateEvent object) {
            return object == null ? 0 : Strings.stringHashCodeInsensitive((CharSequence)object.getChildName());
        }

        public boolean equals(VFileCreateEvent o1, VFileCreateEvent o2) {
            if (o1 == o2) {
                return true;
            }
            return o2 != null && o1.getChildName().equalsIgnoreCase(o2.getChildName());
        }
    };

    public PersistentFSImpl(@NotNull Application app) {
        if (app == null) {
            PersistentFSImpl.$$$reportNull$$$0(0);
        }
        this.missedRootIds = IntSets.synchronize((IntSet)new IntOpenHashSet());
        this.connected = new AtomicBoolean(false);
        this.vfsPeer = null;
        this.vfsData = null;
        this.structureModificationCount = new AtomicInteger();
        this.fileByIdCacheHits = new AtomicLong();
        this.fileByIdCacheMisses = new AtomicLong();
        this.childByName = new AtomicLong();
        this.caseSensitivityReads = new AtomicLong();
        this.app = app;
        this.rootsByUrl = SystemInfoRt.isFileSystemCaseSensitive ? new ConcurrentHashMap(10, 0.4f, JobSchedulerImpl.getCPUCoresCount()) : ConcurrentCollectionFactory.createConcurrentMap((int)10, (float)0.4f, (int)JobSchedulerImpl.getCPUCoresCount(), (HashingStrategy)HashingStrategy.caseInsensitive());
        AsyncEventSupport.startListening();
        app.getMessageBus().simpleConnect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                PluginId pluginId = pluginDescriptor.getPluginId();
                String requestor = "unloading [" + String.valueOf(pluginId) + "] plugin";
                HashMap<String, VirtualFileSystemEntry> rootsByUrlCopy = new HashMap<String, VirtualFileSystemEntry>(PersistentFSImpl.this.rootsByUrl);
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                for (Map.Entry<String, VirtualFileSystemEntry> entry : rootsByUrlCopy.entrySet()) {
                    VirtualFileSystemEntry root = entry.getValue();
                    String protocol = root.getFileSystem().getProtocol();
                    if (virtualFileManager.getFileSystem(protocol) != null) continue;
                    LOG.info("Removing [" + String.valueOf((Object)root) + "] root from VFS: is file system[" + protocol + "] is not available, (likely) because plugin [" + String.valueOf(pluginId) + "] is unloaded ");
                    PersistentFSImpl.this.executeDelete(new VFileDeleteEvent((Object)requestor, (VirtualFile)root));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$1", "pluginUnloaded"));
            }
        });
        this.connect();
        ShutDownTracker.getInstance().registerCacheShutdownTask(this::disconnect);
        this.otelMonitoringHandle = this.setupOTelMonitoring(TelemetryManager.getInstance().getMeter(PlatformScopesKt.VFS));
        LOG.info("VFS.MAX_FILE_LENGTH_TO_CACHE: " + PersistentFSConstants.MAX_FILE_LENGTH_TO_CACHE);
    }

    @ApiStatus.Internal
    public synchronized void connect() {
        LOG.assertTrue(!this.connected.get());
        this.vfsData = new VfsData(this.app, this);
        this.doConnect();
        PersistentFsConnectionListener.EP_NAME.getExtensionList().forEach(PersistentFsConnectionListener::connectionOpen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public synchronized void disconnect() {
        if (this.connected.compareAndSet(true, false)) {
            for (PersistentFsConnectionListener listener2 : PersistentFsConnectionListener.EP_NAME.getExtensionList()) {
                listener2.beforeConnectionClosed();
            }
            LOG.info("VFS dispose started");
            long startedAtNs = System.nanoTime();
            try {
                ((LocalFileSystemImpl)LocalFileSystem.getInstance()).onDisconnecting();
                this.rootsByUrl.clear();
                this.missedRootIds.clear();
            }
            finally {
                FSRecordsImpl vfsPeer = this.vfsPeer;
                if (vfsPeer != null && !vfsPeer.isClosed()) {
                    vfsPeer.close();
                }
            }
            this.vfsData.close();
            this.vfsData = null;
            LOG.info("VFS dispose completed in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startedAtNs) + " ms.");
        }
    }

    private void doConnect() {
        if (this.connected.compareAndSet(false, true)) {
            FSRecordsImpl _vfsPeer;
            Activity activity = StartUpMeasurer.startActivity((String)"connect FSRecords");
            this.vfsPeer = _vfsPeer = FSRecords.connect();
            activity.end();
            VFSRecoveryInfo recoveryInfo = _vfsPeer.connection().recoveryInfo();
            List<VFSInitException> recoveredErrors = recoveryInfo.recoveredErrors;
            if (!recoveredErrors.isEmpty()) {
                this.refreshSuspiciousDirectories(recoveryInfo.directoriesIdsToRefresh());
            }
        }
    }

    private void refreshSuspiciousDirectories(@NotNull IntList directoryIdsToRefresh) {
        if (directoryIdsToRefresh == null) {
            PersistentFSImpl.$$$reportNull$$$0(1);
        }
        if (!directoryIdsToRefresh.isEmpty()) {
            try {
                List<NewVirtualFile> directoriesToRefresh = directoryIdsToRefresh.intStream().mapToObj(dirId -> {
                    try {
                        return this.findFileById(dirId);
                    }
                    catch (Throwable t) {
                        LOG.info("Directory to refresh [#" + dirId + "] can't be resolved", t);
                        return null;
                    }
                }).filter(Objects::nonNull).toList();
                RefreshQueue.getInstance().refresh(false, false, null, directoriesToRefresh);
            }
            catch (Throwable t) {
                LOG.warn("Can't refresh recovered directories: " + String.valueOf(directoryIdsToRefresh), t);
            }
        }
    }

    @ApiStatus.Internal
    public boolean isConnected() {
        return this.connected.get();
    }

    @NotNull
    private BulkFileListener getPublisherEdt() {
        BulkFileListener publisher = this.publisher;
        if (publisher == null) {
            this.publisher = publisher = (BulkFileListener)this.app.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
        }
        BulkFileListener bulkFileListener = publisher;
        if (bulkFileListener == null) {
            PersistentFSImpl.$$$reportNull$$$0(2);
        }
        return bulkFileListener;
    }

    @NotNull
    private BulkFileListenerBackgroundable getPublisherBackgroundable() {
        BulkFileListenerBackgroundable publisher = this.publisherBackgroundable;
        if (publisher == null) {
            this.publisherBackgroundable = publisher = (BulkFileListenerBackgroundable)this.app.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES_BG);
        }
        BulkFileListenerBackgroundable bulkFileListenerBackgroundable = publisher;
        if (bulkFileListenerBackgroundable == null) {
            PersistentFSImpl.$$$reportNull$$$0(3);
        }
        return bulkFileListenerBackgroundable;
    }

    public void dispose() {
        try {
            this.disconnect();
        }
        catch (ProcessCanceledException e) {
            LOG.warn("Detected cancellation during dispose of PersistentFS. Application was likely closed before VFS got completely initialized", (Throwable)e);
        }
        this.otelMonitoringHandle.close();
    }

    public boolean areChildrenLoaded(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(4);
        }
        int flags = this.vfsPeer.getFlags(PersistentFSImpl.fileId(dir));
        return FSRecordsImpl.areAllChildrenCached(flags);
    }

    public long getCreationTimestamp() {
        return this.vfsPeer.getCreationTimestamp();
    }

    public VirtualDirectoryImpl getCachedDir(int id2) {
        return this.vfsData.cachedDir(id2);
    }

    @ApiStatus.Internal
    public String getNameByNameId(int nameId) {
        return this.vfsPeer.getNameByNameId(nameId);
    }

    @NotNull
    private static NewVirtualFileSystem fileSystemOf(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(5);
        }
        NewVirtualFileSystem newVirtualFileSystem = (NewVirtualFileSystem)file2.getFileSystem();
        if (newVirtualFileSystem == null) {
            PersistentFSImpl.$$$reportNull$$$0(6);
        }
        return newVirtualFileSystem;
    }

    public boolean wereChildrenAccessed(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(7);
        }
        PersistentFSImpl.checkReadAccess();
        return this.vfsPeer.wereChildrenAccessed(PersistentFSImpl.fileId(dir));
    }

    public String @NotNull [] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(8);
        }
        PersistentFSImpl.checkReadAccess();
        List<? extends ChildInfo> children2 = this.listAll(file2);
        String[] stringArray = (String[])ContainerUtil.map2Array(children2, String.class, info -> info.getName().toString());
        if (stringArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @Override
    public String @NotNull [] listPersisted(@NotNull VirtualFile parent) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(10);
        }
        PersistentFSImpl.checkReadAccess();
        int parentId = PersistentFSImpl.fileId(parent);
        ListResult childrenList = this.vfsPeer.list(parentId);
        String[] stringArray = (String[])ContainerUtil.map2Array(childrenList.children, String.class, info -> info.getName().toString());
        if (stringArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    @Override
    @ApiStatus.Internal
    public @Unmodifiable @NotNull List<? extends ChildInfo> listAll(@NotNull VirtualFile dir) {
        String[] childrenNames;
        Map childrenWithAttributes;
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(12);
        }
        PersistentFSImpl.checkReadAccess();
        int dirId = PersistentFSImpl.fileId(dir);
        ListResult childrenList = this.vfsPeer.list(dirId);
        if (childrenList.allChildrenCached()) {
            List<? extends ChildInfo> list2 = childrenList.children;
            if (list2 == null) {
                PersistentFSImpl.$$$reportNull$$$0(13);
            }
            return list2;
        }
        NewVirtualFileSystem fs = PersistentFSImpl.fileSystemOf(dir);
        boolean caseSensitive = dir.isCaseSensitive();
        if (fs instanceof BatchingFileSystem) {
            BatchingFileSystem batchingFileSystem = (BatchingFileSystem)fs;
            childrenWithAttributes = batchingFileSystem.listWithAttributes(dir);
            childrenNames = VfsUtil.filterNames((String[])ArrayUtil.toStringArray(childrenWithAttributes.keySet()));
        } else {
            childrenWithAttributes = null;
            childrenNames = VfsUtil.filterNames((String[])fs.list(dir));
        }
        ListResult savedChildren = this.vfsPeer.update(dir, dirId, current -> {
            List<? extends ChildInfo> currentChildren = current.children;
            if (childrenNames.length == 0 && !currentChildren.isEmpty()) {
                return current;
            }
            Set childrenNamesToAdd = CollectionFactory.createFilePathSet((String[])childrenNames, (boolean)caseSensitive);
            for (ChildInfo childInfo : currentChildren) {
                childrenNamesToAdd.remove(childInfo.getName().toString());
            }
            if (childrenNamesToAdd.isEmpty()) {
                return current;
            }
            List<ChildInfo> childrenToAdd = childrenWithAttributes != null ? this.createNewChildrenRecords(dir, childrenNamesToAdd, childrenWithAttributes, fs) : this.createNewChildrenRecords(dir, childrenNamesToAdd, fs);
            childrenToAdd.sort(ChildInfo.BY_ID);
            return current.merge(this.vfsPeer, childrenToAdd, caseSensitive);
        }, true);
        List<? extends ChildInfo> list3 = savedChildren.children;
        if (list3 == null) {
            PersistentFSImpl.$$$reportNull$$$0(14);
        }
        return list3;
    }

    @NotNull
    private List<ChildInfo> createNewChildrenRecords(@NotNull VirtualFile dir, @NotNull Set<String> childrenNamesToAdd, @NotNull NewVirtualFileSystem fs) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(15);
        }
        if (childrenNamesToAdd == null) {
            PersistentFSImpl.$$$reportNull$$$0(16);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(17);
        }
        ArrayList<ChildInfo> childrenToAdd = new ArrayList<ChildInfo>(childrenNamesToAdd.size());
        Map justCreated = CollectionFactory.createFilePathMap((int)childrenNamesToAdd.size(), (boolean)dir.isCaseSensitive());
        int dirId = PersistentFSImpl.fileId(dir);
        for (String newChildName : childrenNamesToAdd) {
            Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, dir, newChildName, null, null);
            if (childData == null) continue;
            ChildInfo newChild = justCreated.computeIfAbsent(newChildName, _newChildName -> this.makeChildRecord(dir, dirId, (CharSequence)_newChildName, childData, fs, null));
            childrenToAdd.add(newChild);
        }
        ArrayList<ChildInfo> arrayList = childrenToAdd;
        if (arrayList == null) {
            PersistentFSImpl.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private List<ChildInfo> createNewChildrenRecords(@NotNull VirtualFile dir, @NotNull Set<String> childrenNamesToAdd, @NotNull Map<String, FileAttributes> childrenWithAttributes, @NotNull NewVirtualFileSystem fs) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(19);
        }
        if (childrenNamesToAdd == null) {
            PersistentFSImpl.$$$reportNull$$$0(20);
        }
        if (childrenWithAttributes == null) {
            PersistentFSImpl.$$$reportNull$$$0(21);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(22);
        }
        ArrayList<ChildInfo> childrenToAdd = new ArrayList<ChildInfo>(childrenNamesToAdd.size());
        Map justCreated = CollectionFactory.createFilePathMap((int)childrenNamesToAdd.size(), (boolean)dir.isCaseSensitive());
        int dirId = PersistentFSImpl.fileId(dir);
        for (String newChildName : childrenNamesToAdd) {
            FileAttributes childAttrs = childrenWithAttributes.get(newChildName);
            String symLinkTarget = childAttrs.isSymLink() ? fs.resolveSymLink((VirtualFile)new FakeVirtualFile(dir, newChildName)) : null;
            Pair childData = new Pair((Object)childAttrs, (Object)symLinkTarget);
            ChildInfo newChild = justCreated.computeIfAbsent(newChildName, _newChildName -> this.makeChildRecord(dir, dirId, (CharSequence)_newChildName, (Pair<FileAttributes, String>)childData, fs, null));
            childrenToAdd.add(newChild);
        }
        ArrayList<ChildInfo> arrayList = childrenToAdd;
        if (arrayList == null) {
            PersistentFSImpl.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @Nullable
    public AttributeInputStream readAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(24);
        }
        if (att == null) {
            PersistentFSImpl.$$$reportNull$$$0(25);
        }
        PersistentFSImpl.checkReadAccess();
        return this.vfsPeer.readAttribute(PersistentFSImpl.fileId(file2), att);
    }

    @NotNull
    public AttributeOutputStream writeAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute attribute) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(26);
        }
        if (attribute == null) {
            PersistentFSImpl.$$$reportNull$$$0(27);
        }
        AttributeOutputStream attributeOutputStream = this.vfsPeer.writeAttribute(PersistentFSImpl.fileId(file2), attribute);
        if (attributeOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(28);
        }
        return attributeOutputStream;
    }

    @NotNull
    private InputStream readContentById(int contentId) {
        InputStream inputStream = this.vfsPeer.readContentById(contentId);
        if (inputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(29);
        }
        return inputStream;
    }

    @NotNull
    private OutputStream writeContent(@NotNull VirtualFile file2, boolean contentOfFixedSize) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(30);
        }
        ThreadingAssertions.assertWriteAccess();
        DataOutputStream dataOutputStream = this.vfsPeer.writeContent(PersistentFSImpl.fileId(file2), contentOfFixedSize);
        if (dataOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(31);
        }
        return dataOutputStream;
    }

    @Override
    public int storeUnlinkedContent(byte @NotNull [] bytes) throws ContentTooBigException {
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(32);
        }
        return this.vfsPeer.writeContentRecord(new ByteArraySequence(bytes));
    }

    public int getModificationCount(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(33);
        }
        return this.vfsPeer.getModCount(PersistentFSImpl.fileId(file2));
    }

    public int getStructureModificationCount() {
        return this.structureModificationCount.get();
    }

    public void incStructuralModificationCount() {
        this.structureModificationCount.incrementAndGet();
    }

    @TestOnly
    public int getFilesystemModificationCount() {
        return this.vfsPeer.getPersistentModCount();
    }

    private int writeRootFields(int rootId, @NotNull String name2, boolean caseSensitive, @NotNull FileAttributes attributes) {
        int flags;
        if (name2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(34);
        }
        if (attributes == null) {
            PersistentFSImpl.$$$reportNull$$$0(35);
        }
        assert (rootId > 0) : rootId;
        if (!name2.isEmpty() ? Comparing.equal((String)name2, (String)this.vfsPeer.getName(rootId), (boolean)caseSensitive) : FSRecordsImpl.areAllChildrenCached(flags = this.vfsPeer.getFlags(rootId))) {
            return -1;
        }
        return this.vfsPeer.updateRecordFields(rootId, 0, attributes, name2, false);
    }

    @Override
    public @PersistentFS.Attributes int getFileAttributes(int id2) {
        assert (id2 > 0);
        return this.vfsPeer.getFlags(id2);
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(36);
        }
        return PersistentFSImpl.isDirectory(this.getFileAttributes(PersistentFSImpl.fileId(file2)));
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            PersistentFSImpl.$$$reportNull$$$0(37);
        }
        return fileOrDirectory.exists();
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(38);
        }
        return this.vfsPeer.getTimestamp(PersistentFSImpl.fileId(file2));
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long modStamp) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(39);
        }
        int id2 = PersistentFSImpl.fileId(file2);
        this.vfsPeer.setTimestamp(id2, modStamp);
        PersistentFSImpl.fileSystemOf(file2).setTimeStamp(file2, modStamp);
    }

    private static int fileId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(40);
        }
        return ((VirtualFileWithId)file2).getId();
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(41);
        }
        return PersistentFSImpl.isSymLink(this.getFileAttributes(PersistentFSImpl.fileId(file2)));
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(42);
        }
        return this.vfsPeer.readSymlinkTarget(PersistentFSImpl.fileId(file2));
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(43);
        }
        return !BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.fileId(file2)), (int)4);
    }

    @Override
    public boolean isHidden(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(44);
        }
        return BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.fileId(file2)), (int)64);
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(45);
        }
        ThreadingAssertions.assertWriteAccess();
        PersistentFSImpl.fileSystemOf(file2).setWritable(file2, writableFlag);
        boolean oldWritable = this.isWritable(file2);
        if (oldWritable != writableFlag) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent((Object)this, file2, "writable", (Object)oldWritable, (Object)writableFlag));
        }
    }

    @Override
    @ApiStatus.Internal
    public ChildInfo findChildInfo(@NotNull VirtualFile parent, @NotNull String childName, @NotNull NewVirtualFileSystem fs) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(46);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(47);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(48);
        }
        PersistentFSImpl.checkReadAccess();
        int parentId = PersistentFSImpl.fileId(parent);
        Ref foundChildRef = new Ref();
        Function<ListResult, ListResult> convertor = children2 -> {
            String canonicalName;
            ChildInfo child = this.findExistingChildInfo(children2.children, childName, parent.isCaseSensitive());
            if (child != null) {
                foundChildRef.set((Object)child);
                return children2;
            }
            Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, parent, childName, null, null);
            if (childData == null) {
                return children2;
            }
            if (parent.isCaseSensitive()) {
                canonicalName = childName;
            } else {
                canonicalName = fs.getCanonicallyCasedName((VirtualFile)new FakeVirtualFile(parent, childName));
                if (Strings.isEmptyOrSpaces((CharSequence)canonicalName)) {
                    return children2;
                }
                if (!childName.equals(canonicalName)) {
                    child = this.findExistingChildInfo(children2.children, canonicalName, false);
                }
            }
            if (child == null) {
                child = this.makeChildRecord(parent, parentId, canonicalName, childData, fs, null);
                foundChildRef.set((Object)child);
                return children2.insert(child);
            }
            foundChildRef.set((Object)child);
            return children2;
        };
        this.vfsPeer.update(parent, parentId, convertor, false);
        return (ChildInfo)foundChildRef.get();
    }

    private ChildInfo findExistingChildInfo(@NotNull List<? extends ChildInfo> children2, @NotNull String childName, boolean caseSensitive) {
        if (children2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(49);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(50);
        }
        if (children2.isEmpty()) {
            return null;
        }
        FSRecordsImpl vfs = this.vfsPeer;
        int nameId = vfs.getNameId(childName);
        for (ChildInfo childInfo : children2) {
            if (nameId != childInfo.getNameId()) continue;
            return childInfo;
        }
        if (!caseSensitive) {
            for (ChildInfo childInfo : children2) {
                if (!Comparing.equal((String)childName, (String)vfs.getNameByNameId(childInfo.getNameId()), (boolean)false)) continue;
                return childInfo;
            }
        }
        return null;
    }

    public long getLength(@NotNull VirtualFile file2) {
        int fileId;
        long length;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(51);
        }
        if ((length = this.vfsPeer.readRecordFields(fileId = PersistentFSImpl.fileId(file2), record -> {
            int flags = record.getFlags();
            boolean mustReloadLength = BitUtil.isSet((int)flags, (int)128);
            long cachedLength = record.getLength();
            if (!mustReloadLength && cachedLength >= 0L) {
                return cachedLength;
            }
            return -1L;
        }).longValue()) >= 0L) {
            return length;
        }
        NewVirtualFileSystem fileSystem = PersistentFSImpl.fileSystemOf(file2);
        long actualLength = fileSystem.getLength(file2);
        long[] lengthRef = new long[1];
        this.vfsPeer.updateRecordFields(fileId, record -> {
            int flags = record.getFlags();
            boolean mustReloadLength = BitUtil.isSet((int)flags, (int)128);
            long cachedLength = record.getLength();
            if (!mustReloadLength && cachedLength >= 0L) {
                lengthRef[0] = cachedLength;
                return false;
            }
            record.setLength(actualLength);
            record.removeFlags(128);
            lengthRef[0] = actualLength;
            return true;
        });
        return lengthRef[0];
    }

    @Override
    public long getLastRecordedLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(52);
        }
        int id2 = PersistentFSImpl.fileId(file2);
        return this.vfsPeer.getLength(id2);
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile parent, @NotNull String name2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(53);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(54);
        }
        if (name2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(55);
        }
        ThreadingAssertions.assertWriteAccess();
        PersistentFSImpl.fileSystemOf(file2).copyFile(requestor, file2, parent, name2);
        this.processEvent((VFileEvent)new VFileCopyEvent(requestor, file2, parent, name2));
        VirtualFile child = parent.findChild(name2);
        if (child == null) {
            throw new IOException("Cannot create child");
        }
        VirtualFile virtualFile2 = child;
        if (virtualFile2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(56);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String childDirectoryName) throws IOException {
        VirtualFile child;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(57);
        }
        if (childDirectoryName == null) {
            PersistentFSImpl.$$$reportNull$$$0(58);
        }
        ThreadingAssertions.assertWriteAccess();
        PersistentFSImpl.fileSystemOf(parent).createChildDirectory(requestor, parent, childDirectoryName);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, childDirectoryName, true, null, null, ChildInfo.EMPTY_ARRAY));
        VFilePropertyChangeEvent caseSensitivityEvent = this.determineCaseSensitivityAndPrepareUpdate(parent, childDirectoryName);
        if (caseSensitivityEvent != null) {
            this.processEvent((VFileEvent)caseSensitivityEvent);
        }
        if ((child = parent.findChild(childDirectoryName)) == null) {
            throw new IOException("Cannot create child directory '" + childDirectoryName + "' at " + parent.getPath());
        }
        VirtualFile virtualFile2 = child;
        if (virtualFile2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(59);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String childName) throws IOException {
        VirtualFile child;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(60);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(61);
        }
        ThreadingAssertions.assertWriteAccess();
        PersistentFSImpl.fileSystemOf(parent).createChildFile(requestor, parent, childName);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, childName, false, null, null, null));
        VFilePropertyChangeEvent caseSensitivityEvent = this.determineCaseSensitivityAndPrepareUpdate(parent, childName);
        if (caseSensitivityEvent != null) {
            this.processEvent((VFileEvent)caseSensitivityEvent);
        }
        if ((child = parent.findChild(childName)) == null) {
            throw new IOException("Cannot create child file '" + childName + "' at " + parent.getPath());
        }
        if (child.getCharset().equals(StandardCharsets.UTF_8) && !(child.getFileType() instanceof InternalFileType) && PersistentFSImpl.isUtf8BomRequired(child)) {
            child.setBOM(CharsetToolkit.UTF8_BOM);
        }
        VirtualFile virtualFile2 = child;
        if (virtualFile2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(62);
        }
        return virtualFile2;
    }

    private static boolean isUtf8BomRequired(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(63);
        }
        for (Utf8BomOptionProvider encodingProvider : Utf8BomOptionProvider.EP_NAME.getIterable()) {
            if (!encodingProvider.shouldAddBOMForNewUtf8File(file2)) continue;
            return true;
        }
        Project project2 = ProjectLocator.getInstance().guessProjectForFile(file2);
        EncodingManager encodingManager = project2 == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project2);
        return encodingManager.shouldAddBOMForNewUtf8File();
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(64);
        }
        ThreadingAssertions.assertWriteAccess();
        NewVirtualFileSystem fs = PersistentFSImpl.fileSystemOf(file2);
        fs.deleteFile(requestor, file2);
        if (!fs.exists(file2)) {
            this.processEvent((VFileEvent)new VFileDeleteEvent(requestor, file2));
        }
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(65);
        }
        if (newName == null) {
            PersistentFSImpl.$$$reportNull$$$0(66);
        }
        ThreadingAssertions.assertWriteAccess();
        PersistentFSImpl.fileSystemOf(file2).renameFile(requestor, file2, newName);
        String oldName = file2.getName();
        if (!newName.equals(oldName)) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent(requestor, file2, "name", (Object)oldName, (Object)newName));
        }
    }

    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(67);
        }
        boolean cacheContent = !PersistentFSImpl.fileSystemOf(file2).isReadOnly();
        byte[] byArray = this.contentsToByteArray(file2, cacheContent);
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(68);
        }
        return byArray;
    }

    /*
     * Loose catch block
     */
    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2, boolean mayCacheContent) throws IOException {
        byte[] byArray;
        InputStream contentStream;
        block15: {
            block14: {
                if (file2 == null) {
                    PersistentFSImpl.$$$reportNull$$$0(69);
                }
                PersistentFSImpl.checkReadAccess();
                int fileId = PersistentFSImpl.fileId(file2);
                LengthAndContentIdReader reader = this.vfsPeer.readRecordFields(fileId, new LengthAndContentIdReader());
                long length = reader.length;
                int contentRecordId = reader.contentRecordId;
                if (contentRecordId <= 0) {
                    NewVirtualFileSystem fs = PersistentFSImpl.fileSystemOf(file2);
                    byte[] content2 = fs.contentsToByteArray(file2);
                    if (mayCacheContent && PersistentFSImpl.shouldCacheFileContentInVFS(content2.length)) {
                        this.updateContentForFile(fileId, new ByteArraySequence(content2));
                    } else {
                        this.vfsPeer.updateRecordFields(fileId, record -> {
                            boolean lengthChanged = record.setLength(content2.length);
                            int oldFlags = record.getFlags();
                            int flags = oldFlags & 0xFFFFFF7F;
                            boolean flagsChanged = record.setFlags(flags);
                            return lengthChanged || flagsChanged;
                        });
                    }
                    if (content2 == null) {
                        PersistentFSImpl.$$$reportNull$$$0(70);
                    }
                    return content2;
                }
                contentStream = this.vfsPeer.readContentById(contentRecordId);
                assert (length >= 0L) : file2;
                byArray = contentStream.readNBytes((int)length);
                if (contentStream == null) break block14;
                contentStream.close();
            }
            if (byArray != null) break block15;
            PersistentFSImpl.$$$reportNull$$$0(71);
        }
        return byArray;
        {
            catch (Throwable throwable) {
                try {
                    if (contentStream != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw this.vfsPeer.handleError(e);
                }
            }
        }
    }

    private void updateContentId(int fileId, int newContentRecordId, int newContentLength) {
        this.vfsPeer.updateRecordFields(fileId, record -> {
            record.removeFlags(136);
            record.setContentRecordId(newContentRecordId);
            record.setLength(newContentLength);
            return true;
        });
    }

    @Override
    public byte @NotNull [] contentsToByteArray(int contentId) throws IOException {
        byte[] byArray = this.readContentById(contentId).readAllBytes();
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(72);
        }
        return byArray;
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        InputStream contentStream;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(73);
        }
        PersistentFSImpl.checkReadAccess();
        int fileId = PersistentFSImpl.fileId(file2);
        NewVirtualFileSystem fs = PersistentFSImpl.fileSystemOf(file2);
        final class Result {
            private long actualFileLength;
            private boolean mustReloadContent;
            private int contentRecordId;

            Result(PersistentFSImpl this$0) {
            }
        }
        Result result2 = new Result(this);
        this.vfsPeer.updateRecordFields(fileId, record -> {
            long vfsStoredLength = record.getLength();
            int contentRecordId = record.getContentRecordId();
            int flags = record.getFlags();
            boolean mustReloadLength = BitUtil.isSet((int)flags, (int)128);
            boolean mustReloadContent = BitUtil.isSet((int)flags, (int)8);
            boolean lengthIsInvalid = mustReloadLength || vfsStoredLength == -1L;
            result2.mustReloadContent = mustReloadContent;
            result2.contentRecordId = contentRecordId;
            result2.actualFileLength = vfsStoredLength;
            if (lengthIsInvalid) {
                result2.actualFileLength = fs.getLength(file2);
                record.setLength(result2.actualFileLength);
                record.removeFlags(128);
                return true;
            }
            return false;
        });
        if (result2.contentRecordId <= 0 || result2.mustReloadContent) {
            InputStream fileStream = fs.getInputStream(file2);
            contentStream = PersistentFSImpl.shouldCacheFileContentInVFS(result2.actualFileLength) ? this.createReplicatorAndStoreContent(file2, fileStream, result2.actualFileLength) : fileStream;
        } else {
            contentStream = this.vfsPeer.readContentById(result2.contentRecordId);
        }
        InputStream inputStream = contentStream;
        if (inputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(74);
        }
        return inputStream;
    }

    private static boolean shouldCacheFileContentInVFS(long fileLength) {
        return fileLength <= (long)PersistentFSConstants.MAX_FILE_LENGTH_TO_CACHE;
    }

    @NotNull
    private InputStream createReplicatorAndStoreContent(final @NotNull VirtualFile file2, @NotNull InputStream nativeStream, final long fileLength) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(75);
        }
        if (nativeStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(76);
        }
        if (nativeStream instanceof BufferExposingByteArrayInputStream) {
            BufferExposingByteArrayInputStream byteStream = (BufferExposingByteArrayInputStream)nativeStream;
            byte[] bytes = byteStream.getInternalBuffer();
            this.storeContentToStorage(fileLength, file2, bytes, bytes.length);
            InputStream inputStream = nativeStream;
            if (inputStream == null) {
                PersistentFSImpl.$$$reportNull$$$0(77);
            }
            return inputStream;
        }
        final BufferExposingByteArrayOutputStream cache2 = new BufferExposingByteArrayOutputStream((int)fileLength);
        return new ReplicatorInputStream(nativeStream, cache2){
            boolean isClosed;

            public void close() throws IOException {
                if (!this.isClosed) {
                    try {
                        boolean isEndOfFileReached;
                        try {
                            isEndOfFileReached = this.available() < 0 || this.read() == -1;
                        }
                        catch (IOException ignored) {
                            isEndOfFileReached = false;
                        }
                        super.close();
                        if (isEndOfFileReached) {
                            PersistentFSImpl.this.storeContentToStorage(fileLength, file2, cache2.getInternalBuffer(), cache2.size());
                        }
                    }
                    finally {
                        this.isClosed = true;
                    }
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void storeContentToStorage(long fileLength, @NotNull VirtualFile file2, byte @NotNull [] bytes, int n) throws IOException, ContentTooBigException {
        void byteLength;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(78);
        }
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(79);
        }
        int fileId = PersistentFSImpl.fileId(file2);
        if ((long)byteLength == fileLength) {
            ByteArraySequence newContent = new ByteArraySequence(bytes, 0, (int)byteLength);
            this.updateContentForFile(fileId, newContent);
        } else {
            this.doCleanPersistedContent(fileId);
        }
    }

    private void updateContentForFile(int fileId, @NotNull ByteArraySequence newContent) throws ContentTooBigException {
        int newContentId;
        if (newContent == null) {
            PersistentFSImpl.$$$reportNull$$$0(80);
        }
        try {
            newContentId = this.vfsPeer.writeContentRecord(newContent);
        }
        catch (ContentTooBigException e) {
            LOG.warn("file[" + fileId + "]: content[" + newContent.length() + "b uncompressed] is too big -- don't store it in VFS", (Throwable)e);
            newContentId = 0;
        }
        this.updateContentId(fileId, newContentId, newContent.length());
    }

    @TestOnly
    @ApiStatus.Obsolete
    public static byte @Nullable [] getContentHashIfStored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(81);
        }
        return FSRecords.getInstance().getContentHash(PersistentFSImpl.fileId(file2));
    }

    @TestOnly
    public byte @Nullable [] contentHashIfStored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(82);
        }
        return FSRecords.getInstance().getContentHash(PersistentFSImpl.fileId(file2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, final Object requestor, final long modStamp, long l) {
        void timeStamp;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(83);
        }
        return new ByteArrayOutputStream((long)timeStamp){
            private boolean closed;
            final /* synthetic */ long val$timeStamp;
            {
                this.val$timeStamp = l2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                block11: {
                    if (this.closed) {
                        return;
                    }
                    super.close();
                    ThreadingAssertions.assertWriteAccess();
                    long oldLength = PersistentFSImpl.this.getLastRecordedLength(file2);
                    VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, file2, file2.getModificationStamp(), modStamp, file2.getTimeStamp(), -1L, oldLength, (long)this.count);
                    List<VFileContentChangeEvent> events = List.of(event);
                    PersistentFSImpl.fireBeforeEvents(PersistentFSImpl.this.getPublisherEdt(), PersistentFSImpl.this.getPublisherBackgroundable(), events);
                    NewVirtualFileSystem fs = PersistentFSImpl.fileSystemOf(file2);
                    try {
                        if (PersistentFSImpl.shouldCacheFileContentInVFS(this.count)) {
                            try (OutputStream persistenceStream = PersistentFSImpl.this.writeContent(file2, fs.isReadOnly());){
                                persistenceStream.write(this.buf, 0, this.count);
                                break block11;
                            }
                        }
                        PersistentFSImpl.this.cleanPersistedContent(PersistentFSImpl.fileId(file2));
                    }
                    finally {
                        this.writeToDisk(fs, event, events);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeToDisk(@NotNull NewVirtualFileSystem fs, @NotNull VFileContentChangeEvent event, @NotNull List<VFileEvent> events) throws IOException {
                if (fs == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (events == null) {
                    3.$$$reportNull$$$0(2);
                }
                try {
                    try (OutputStream ioFileStream = fs.getOutputStream(file2, requestor, modStamp, this.val$timeStamp);){
                        ioFileStream.write(this.buf, 0, this.count);
                    }
                    this.closed = true;
                }
                catch (Throwable throwable) {
                    this.closed = true;
                    FileAttributes attributes = fs.getAttributes(file2);
                    long newTimestamp = attributes != null ? attributes.lastModified : 0L;
                    long newLength = attributes != null ? attributes.length : 0L;
                    PersistentFSImpl.this.executeTouch(file2, false, event.getModificationStamp(), newLength, newTimestamp);
                    PersistentFSImpl.fireAfterEvents(PersistentFSImpl.this.getPublisherEdt(), PersistentFSImpl.this.getPublisherBackgroundable(), Collections.emptyList(), events);
                    throw throwable;
                }
                FileAttributes attributes = fs.getAttributes(file2);
                long newTimestamp = attributes != null ? attributes.lastModified : 0L;
                long newLength = attributes != null ? attributes.length : 0L;
                PersistentFSImpl.this.executeTouch(file2, false, event.getModificationStamp(), newLength, newTimestamp);
                PersistentFSImpl.fireAfterEvents(PersistentFSImpl.this.getPublisherEdt(), PersistentFSImpl.this.getPublisherBackgroundable(), Collections.emptyList(), events);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fs";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "events";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$3";
                objectArray[2] = "writeToDisk";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public int acquireContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(84);
        }
        return this.vfsPeer.acquireFileContent(PersistentFSImpl.fileId(file2));
    }

    @Override
    public void releaseContent(int contentId) {
        this.vfsPeer.releaseContent(contentId);
    }

    @Override
    public int getCurrentContentId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(85);
        }
        return this.vfsPeer.getContentRecordId(PersistentFSImpl.fileId(file2));
    }

    @ApiStatus.Internal
    public boolean isOwnData(@NotNull VfsData data2) {
        if (data2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(86);
        }
        return data2 == this.vfsData;
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(87);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(88);
        }
        PersistentFSImpl.fileSystemOf(file2).moveFile(requestor, file2, newParent);
        this.processEvent((VFileEvent)new VFileMoveEvent(requestor, file2, newParent));
    }

    private void processEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(89);
        }
        ThreadingAssertions.assertWriteAccess();
        if (!event.isValid()) {
            return;
        }
        ArrayList<VFileEvent> outValidatedEvents = new ArrayList<VFileEvent>();
        outValidatedEvents.add(event);
        ArrayList<Runnable> outApplyActions = new ArrayList<Runnable>();
        List jarDeleteEvents = VfsImplUtil.getJarInvalidationEvents((VFileEvent)event, outApplyActions);
        BulkFileListener publisher = this.getPublisherEdt();
        BulkFileListenerBackgroundable publisherBackgroundable = this.getPublisherBackgroundable();
        if (jarDeleteEvents.isEmpty() && outApplyActions.isEmpty()) {
            PersistentFSImpl.runSuppressing(() -> PersistentFSImpl.fireBeforeEvents(publisher, publisherBackgroundable, outValidatedEvents), () -> this.applyEvent(event), () -> PersistentFSImpl.fireAfterEvents(publisher, publisherBackgroundable, Collections.emptyList(), outValidatedEvents), EmptyRunnable.INSTANCE, EmptyRunnable.INSTANCE);
        } else {
            outApplyActions.add(() -> this.applyEvent(event));
            for (VFileEvent jarDeleteEvent : jarDeleteEvents) {
                outApplyActions.add(() -> this.applyEvent(jarDeleteEvent));
                outValidatedEvents.add(jarDeleteEvent);
            }
            PersistentFSImpl.applyMultipleEvents(publisher, publisherBackgroundable, Collections.emptyList(), outApplyActions, outValidatedEvents, false);
        }
    }

    private static void runSuppressing(@NotNull Runnable r1, @NotNull Runnable r2, @NotNull Runnable r3, @NotNull Runnable r4, @NotNull Runnable r5) {
        if (r1 == null) {
            PersistentFSImpl.$$$reportNull$$$0(90);
        }
        if (r2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(91);
        }
        if (r3 == null) {
            PersistentFSImpl.$$$reportNull$$$0(92);
        }
        if (r4 == null) {
            PersistentFSImpl.$$$reportNull$$$0(93);
        }
        if (r5 == null) {
            PersistentFSImpl.$$$reportNull$$$0(94);
        }
        Throwable t = null;
        try {
            r1.run();
        }
        catch (Throwable e) {
            t = Suppressions.addSuppressed(t, (Throwable)e);
        }
        try {
            r2.run();
        }
        catch (Throwable e) {
            t = Suppressions.addSuppressed((Throwable)t, (Throwable)e);
        }
        try {
            r3.run();
        }
        catch (Throwable e) {
            t = Suppressions.addSuppressed((Throwable)t, (Throwable)e);
        }
        if (r4 != EmptyRunnable.INSTANCE) {
            try {
                r4.run();
            }
            catch (Throwable e) {
                t = Suppressions.addSuppressed((Throwable)t, (Throwable)e);
            }
        }
        if (r5 != EmptyRunnable.INSTANCE) {
            try {
                r5.run();
            }
            catch (Throwable e) {
                t = Suppressions.addSuppressed((Throwable)t, (Throwable)e);
            }
        }
        if (t != null) {
            ExceptionUtilRt.rethrowUnchecked((Throwable)t);
        }
    }

    private static int groupByPath(@NotNull List<CompoundVFileEvent> events, int startIndex, @NotNull MostlySingularMultiMap<String, VFileEvent> filesInvolved, @NotNull Set<? super String> middleDirsInvolved, @NotNull Set<? super VirtualFile> deleted, @NotNull Map<VirtualDirectoryImpl, Object> toCreate, @NotNull Set<? super VFileEvent> eventsToRemove) {
        int i2;
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(95);
        }
        if (filesInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(96);
        }
        if (middleDirsInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(97);
        }
        if (deleted == null) {
            PersistentFSImpl.$$$reportNull$$$0(98);
        }
        if (toCreate == null) {
            PersistentFSImpl.$$$reportNull$$$0(99);
        }
        if (eventsToRemove == null) {
            PersistentFSImpl.$$$reportNull$$$0(100);
        }
        for (i2 = startIndex; i2 < events.size(); ++i2) {
            String path2;
            VFileEvent event = events.get(i2).getFileEvent();
            String path = event.getPath();
            if (event instanceof VFileDeleteEvent && PersistentFSImpl.removeNestedDelete(((VFileDeleteEvent)event).getFile(), deleted)) {
                eventsToRemove.add((VFileEvent)event);
                continue;
            }
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent createEvent = (VFileCreateEvent)event;
                VirtualDirectoryImpl parent = (VirtualDirectoryImpl)createEvent.getParent();
                LinkedHashSet<VFileCreateEvent> createEvents = toCreate.get((Object)parent);
                if (createEvents == null) {
                    toCreate.put(parent, createEvent);
                } else {
                    Collection children2;
                    if (createEvents instanceof VFileCreateEvent) {
                        VFileCreateEvent prevEvent = (VFileCreateEvent)createEvents;
                        LinkedHashSet<VFileCreateEvent> children3 = parent.isCaseSensitive() ? new LinkedHashSet<VFileCreateEvent>() : new ObjectLinkedOpenCustomHashSet(CASE_INSENSITIVE_STRATEGY);
                        children3.add(prevEvent);
                        toCreate.put(parent, children3);
                        createEvents = children3;
                    }
                    if (!(children2 = (Collection)createEvents).add(createEvent)) {
                        eventsToRemove.add((VFileEvent)createEvent);
                        continue;
                    }
                }
            }
            if (PersistentFSImpl.eventConflictsWithPrevious(event, path, filesInvolved, middleDirsInvolved) || (path2 = PersistentFSImpl.getAlternativePath(event)) != null && !(!SystemInfoRt.isFileSystemCaseSensitive ? path2.equalsIgnoreCase(path) : path2.equals(path)) && PersistentFSImpl.eventConflictsWithPrevious(event, path2, filesInvolved, middleDirsInvolved)) break;
        }
        return i2;
    }

    private static String getAlternativePath(@NotNull VFileEvent event) {
        VFilePropertyChangeEvent pce;
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(101);
        }
        if (event instanceof VFilePropertyChangeEvent && (pce = (VFilePropertyChangeEvent)event).getPropertyName().equals("name")) {
            VirtualFile parent = pce.getFile().getParent();
            String newName = (String)pce.getNewValue();
            return parent == null ? newName : parent.getPath() + "/" + newName;
        }
        if (event instanceof VFileCopyEvent) {
            return ((VFileCopyEvent)event).getFile().getPath();
        }
        if (event instanceof VFileMoveEvent) {
            VFileMoveEvent vme = (VFileMoveEvent)event;
            String newName = vme.getFile().getName();
            return vme.getNewParent().getPath() + "/" + newName;
        }
        return null;
    }

    private static boolean removeNestedDelete(@NotNull VirtualFile file2, @NotNull Set<? super VirtualFile> deleted) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(102);
        }
        if (deleted == null) {
            PersistentFSImpl.$$$reportNull$$$0(103);
        }
        if (!deleted.add((VirtualFile)file2)) {
            return true;
        }
        while ((file2 = file2.getParent()) != null) {
            if (!deleted.contains(file2)) continue;
            return true;
        }
        return false;
    }

    private static boolean eventConflictsWithPrevious(@NotNull VFileEvent event, @NotNull String path, @NotNull MostlySingularMultiMap<String, VFileEvent> files2, @NotNull Set<? super String> middleDirs) {
        int liPrev;
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(104);
        }
        if (path == null) {
            PersistentFSImpl.$$$reportNull$$$0(105);
        }
        if (files2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(106);
        }
        if (middleDirs == null) {
            PersistentFSImpl.$$$reportNull$$$0(107);
        }
        boolean canReconcileEvents = true;
        for (VFileEvent prev : files2.get((Object)path)) {
            if (PersistentFSImpl.isContentChangeLikeHarmlessEvent(event) && PersistentFSImpl.isContentChangeLikeHarmlessEvent(prev)) continue;
            canReconcileEvents = false;
            break;
        }
        if (!canReconcileEvents) {
            return true;
        }
        if (middleDirs.contains(path)) {
            return true;
        }
        files2.add((Object)path, (Object)event);
        int li = path.length();
        while ((liPrev = path.lastIndexOf(47, li - 1)) != -1) {
            String parentDir = path.substring(0, liPrev);
            if (files2.containsKey((Object)parentDir)) {
                return true;
            }
            if (!middleDirs.add(parentDir)) break;
            li = liPrev;
        }
        return false;
    }

    private static boolean isContentChangeLikeHarmlessEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(108);
        }
        if (event instanceof VFileContentChangeEvent) {
            return true;
        }
        if (event instanceof VFilePropertyChangeEvent) {
            String p = ((VFilePropertyChangeEvent)event).getPropertyName();
            return p.equals("writable") || p.equals("encoding") || p.equals("CHILDREN_CASE_SENSITIVITY");
        }
        return false;
    }

    private int groupAndValidate(@NotNull List<CompoundVFileEvent> events, int startIndex, @NotNull List<? super Runnable> outApplyActions, @NotNull List<? super VFileEvent> outValidatedEvents, @NotNull MostlySingularMultiMap<String, VFileEvent> filesInvolved, @NotNull Set<? super String> middleDirsInvolved, @NotNull Map<VirtualDirectoryImpl, Object> toCreate, @NotNull Set<VFileEvent> toIgnore, @NotNull Set<? super VirtualFile> toDelete, boolean excludeAsyncListeners) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(109);
        }
        if (outApplyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(110);
        }
        if (outValidatedEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(111);
        }
        if (filesInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(112);
        }
        if (middleDirsInvolved == null) {
            PersistentFSImpl.$$$reportNull$$$0(113);
        }
        if (toCreate == null) {
            PersistentFSImpl.$$$reportNull$$$0(114);
        }
        if (toIgnore == null) {
            PersistentFSImpl.$$$reportNull$$$0(115);
        }
        if (toDelete == null) {
            PersistentFSImpl.$$$reportNull$$$0(116);
        }
        int endIndex = PersistentFSImpl.groupByPath(events, startIndex, filesInvolved, middleDirsInvolved, toDelete, toCreate, toIgnore);
        assert (endIndex > startIndex) : String.valueOf(events.get(startIndex)) + "; files: " + String.valueOf(filesInvolved) + "; middleDirs: " + String.valueOf(middleDirsInvolved);
        this.groupCreations(outValidatedEvents, outApplyActions, toCreate);
        this.groupDeletions(events, startIndex, endIndex, outValidatedEvents, outApplyActions, toIgnore);
        this.groupOthers(events, startIndex, endIndex, outValidatedEvents, outApplyActions);
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            CompoundVFileEvent event = events.get(i2);
            outApplyActions.addAll(event.getApplyActions());
            if (excludeAsyncListeners && !event.areInducedEventsCalculated()) {
                LOG.error("Nested file events must be processed by async file listeners! Event: " + String.valueOf(event));
            }
            for (VFileEvent jarDeleteEvent : event.getInducedEvents()) {
                outApplyActions.add(() -> this.applyEvent(jarDeleteEvent));
                outValidatedEvents.add((VFileEvent)jarDeleteEvent);
            }
        }
        return endIndex;
    }

    private void groupCreations(@NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyActions, @NotNull Map<VirtualDirectoryImpl, Object> created2) {
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(117);
        }
        if (outApplyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(118);
        }
        if (created2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(119);
        }
        if (!created2.isEmpty()) {
            boolean hasValidEvents = false;
            for (Map.Entry<VirtualDirectoryImpl, Object> entry : created2.entrySet()) {
                VirtualDirectoryImpl directory = entry.getKey();
                Object value = entry.getValue();
                Set<Object> createEvents = value instanceof VFileCreateEvent ? new HashSet<VFileCreateEvent>(List.of((VFileCreateEvent)value)) : (Set)value;
                directory.validateChildrenToCreate(createEvents);
                hasValidEvents |= !createEvents.isEmpty();
                outValidated.addAll(createEvents);
                entry.setValue(createEvents);
            }
            if (hasValidEvents) {
                Map<VirtualDirectoryImpl, Object> finalGrouped = created2;
                outApplyActions.add(() -> {
                    this.applyCreations(finalGrouped);
                    this.incStructuralModificationCount();
                });
            }
        }
    }

    private void groupDeletions(@NotNull List<CompoundVFileEvent> events, int start2, int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyActions, @NotNull Set<? extends VFileEvent> toIgnore) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(120);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(121);
        }
        if (outApplyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(122);
        }
        if (toIgnore == null) {
            PersistentFSImpl.$$$reportNull$$$0(123);
        }
        MultiMap grouped = null;
        boolean hasValidEvents = false;
        for (int i2 = start2; i2 < end; ++i2) {
            VFileEvent event = events.get(i2).getFileEvent();
            if (!(event instanceof VFileDeleteEvent)) continue;
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            if (toIgnore.contains(event) || !event.isValid()) continue;
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)de.getFile().getParent();
            if (grouped == null) {
                grouped = new MultiMap(end - start2);
            }
            grouped.putValue((Object)parent, (Object)de);
            outValidated.add((VFileEvent)event);
            hasValidEvents = true;
        }
        if (hasValidEvents) {
            MultiMap finalGrouped = grouped;
            outApplyActions.add(() -> {
                this.applyDeletions((MultiMap<VirtualDirectoryImpl, VFileDeleteEvent>)finalGrouped);
                this.incStructuralModificationCount();
            });
        }
    }

    private void groupOthers(@NotNull List<CompoundVFileEvent> events, int start2, int end, @NotNull List<? super VFileEvent> outValidated, @NotNull List<? super Runnable> outApplyActions) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(124);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(125);
        }
        if (outApplyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(126);
        }
        for (int i2 = start2; i2 < end; ++i2) {
            VFileEvent event = events.get(i2).getFileEvent();
            if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || !event.isValid()) continue;
            outValidated.add((VFileEvent)event);
            outApplyActions.add(() -> this.applyEvent(event));
        }
    }

    @ApiStatus.Internal
    public void processEventsImpl(@NotNull List<CompoundVFileEvent> events, @NotNull List<AsyncFileListener.ChangeApplier> earlyAfterEventChangeAppliers, boolean excludeAsyncListeners) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(127);
        }
        if (earlyAfterEventChangeAppliers == null) {
            PersistentFSImpl.$$$reportNull$$$0(128);
        }
        ThreadingAssertions.assertWriteAccess();
        int startIndex = 0;
        int cappedInitialSize = Math.min(events.size(), 4096);
        ArrayList applyActions = new ArrayList(cappedInitialSize);
        MostlySingularMultiMap files2 = new MostlySingularMultiMap(CollectionFactory.createFilePathMap((int)cappedInitialSize));
        Set middleDirs = CollectionFactory.createFilePathSet((int)cappedInitialSize);
        ArrayList validated = new ArrayList(cappedInitialSize);
        BulkFileListener publisherEdt = this.getPublisherEdt();
        BulkFileListenerBackgroundable publisherBackgroundable = this.getPublisherBackgroundable();
        LinkedHashMap<VirtualDirectoryImpl, Object> toCreate = new LinkedHashMap<VirtualDirectoryImpl, Object>();
        ReferenceOpenHashSet toIgnore = new ReferenceOpenHashSet();
        Set toDelete = CollectionFactory.createSmallMemoryFootprintSet();
        while (startIndex != events.size()) {
            PingProgress.interactWithEdtProgress();
            applyActions.clear();
            files2.clear();
            middleDirs.clear();
            validated.clear();
            toCreate.clear();
            toIgnore.clear();
            toDelete.clear();
            startIndex = this.groupAndValidate(events, startIndex, applyActions, validated, (MostlySingularMultiMap<String, VFileEvent>)files2, middleDirs, toCreate, (Set<VFileEvent>)toIgnore, toDelete, excludeAsyncListeners);
            if (validated.isEmpty()) continue;
            PersistentFSImpl.applyMultipleEvents(publisherEdt, publisherBackgroundable, earlyAfterEventChangeAppliers, applyActions, validated, excludeAsyncListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyMultipleEvents(@NotNull BulkFileListener publisher, @NotNull BulkFileListenerBackgroundable publisherBackgroundable, @NotNull List<AsyncFileListener.ChangeApplier> earlyAfterEventChangeAppliers, @NotNull @NotNull List<? extends @NotNull Runnable> applyActions, @NotNull @NotNull List<? extends @NotNull VFileEvent> applyEvents, boolean excludeAsyncListeners) {
        if (publisher == null) {
            PersistentFSImpl.$$$reportNull$$$0(129);
        }
        if (publisherBackgroundable == null) {
            PersistentFSImpl.$$$reportNull$$$0(130);
        }
        if (earlyAfterEventChangeAppliers == null) {
            PersistentFSImpl.$$$reportNull$$$0(131);
        }
        if (applyActions == null) {
            PersistentFSImpl.$$$reportNull$$$0(132);
        }
        if (applyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(133);
        }
        PingProgress.interactWithEdtProgress();
        List<VFileEvent> toSend = List.of(applyEvents.toArray(new VFileEvent[0]));
        Throwable x = null;
        try {
            if (excludeAsyncListeners) {
                AsyncEventSupport.markAsynchronouslyProcessedEvents(toSend);
            }
            try {
                PersistentFSImpl.fireBeforeEvents(publisher, publisherBackgroundable, toSend);
            }
            catch (Throwable t) {
                x = t;
            }
            PingProgress.interactWithEdtProgress();
            for (Runnable runnable2 : applyActions) {
                try {
                    runnable2.run();
                }
                catch (Throwable t) {
                    if (x != null) {
                        t.addSuppressed(x);
                    }
                    x = t;
                }
            }
            PingProgress.interactWithEdtProgress();
            try {
                PersistentFSImpl.fireAfterEvents(publisher, publisherBackgroundable, earlyAfterEventChangeAppliers, toSend);
            }
            catch (Throwable t) {
                if (x != null) {
                    t.addSuppressed(x);
                }
                x = t;
            }
        }
        finally {
            if (excludeAsyncListeners) {
                AsyncEventSupport.unmarkAsynchronouslyProcessedEvents(toSend);
            }
            if (x != null) {
                ExceptionUtil.rethrow((Throwable)x);
            }
        }
    }

    private static void fireBeforeEvents(@NotNull BulkFileListener publisherEdt, @NotNull BulkFileListenerBackgroundable publisherBackgroundable, @NotNull List<? extends VFileEvent> toSend) {
        if (publisherEdt == null) {
            PersistentFSImpl.$$$reportNull$$$0(134);
        }
        if (publisherBackgroundable == null) {
            PersistentFSImpl.$$$reportNull$$$0(135);
        }
        if (toSend == null) {
            PersistentFSImpl.$$$reportNull$$$0(136);
        }
        PersistentFSImpl.runSuppressing(() -> publisherBackgroundable.before(toSend), () -> VfsThreadingUtil.runActionOnEdtRegardlessOfCurrentThread(() -> publisherEdt.before(toSend)), () -> ((BulkFileListener)VirtualFilePointerManager.getInstance()).before(toSend), EmptyRunnable.INSTANCE, EmptyRunnable.INSTANCE);
    }

    private static void fireAfterEvents(@NotNull BulkFileListener publisherEdt, @NotNull BulkFileListenerBackgroundable publisherBackgroundable, @NotNull List<AsyncFileListener.ChangeApplier> earlyAfterEventChangeAppliers, @NotNull List<? extends VFileEvent> toSend) {
        if (publisherEdt == null) {
            PersistentFSImpl.$$$reportNull$$$0(137);
        }
        if (publisherBackgroundable == null) {
            PersistentFSImpl.$$$reportNull$$$0(138);
        }
        if (earlyAfterEventChangeAppliers == null) {
            PersistentFSImpl.$$$reportNull$$$0(139);
        }
        if (toSend == null) {
            PersistentFSImpl.$$$reportNull$$$0(140);
        }
        PersistentFSImpl.runSuppressing(() -> CachedFileType.clearCache(), () -> AsyncEventSupport.afterVfsChange(earlyAfterEventChangeAppliers), () -> ((BulkFileListener)VirtualFilePointerManager.getInstance()).after(toSend), () -> VfsThreadingUtil.runActionOnEdtRegardlessOfCurrentThread(() -> publisherEdt.after(toSend)), () -> publisherBackgroundable.after(toSend));
    }

    private void applyDeletions(@NotNull MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> deletions) {
        if (deletions == null) {
            PersistentFSImpl.$$$reportNull$$$0(141);
        }
        for (Map.Entry entry : deletions.entrySet()) {
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)((Object)entry.getKey());
            Collection deleteEvents = (Collection)entry.getValue();
            if (parent == null || !parent.isValid()) {
                deleteEvents.forEach(this::applyEvent);
                return;
            }
            int parentId = PersistentFSImpl.fileId((VirtualFile)parent);
            ArrayList<CharSequence> childrenNamesDeleted = new ArrayList<CharSequence>(deleteEvents.size());
            IntOpenHashSet childrenIdsDeleted = new IntOpenHashSet(deleteEvents.size());
            ArrayList<ChildInfoImpl> deleted = new ArrayList<ChildInfoImpl>(deleteEvents.size());
            for (VFileDeleteEvent event : deleteEvents) {
                VirtualFile file2 = event.getFile();
                int id2 = PersistentFSImpl.fileId(file2);
                childrenNamesDeleted.add(file2.getNameSequence());
                childrenIdsDeleted.add(id2);
                this.vfsPeer.deleteRecordRecursively(id2);
                PersistentFSImpl.invalidateSubtree(file2, "Bulk file deletions", event);
                deleted.add(new ChildInfoImpl(id2, -238, null, null, null));
            }
            deleted.sort(ChildInfo.BY_ID);
            this.vfsPeer.update((VirtualFile)parent, parentId, oldChildren -> oldChildren.subtract(deleted), false);
            parent.removeChildren((IntSet)childrenIdsDeleted, childrenNamesDeleted);
        }
    }

    private void applyCreations(@NotNull Map<VirtualDirectoryImpl, Set<VFileCreateEvent>> creations) {
        if (creations == null) {
            PersistentFSImpl.$$$reportNull$$$0(142);
        }
        for (Map.Entry<VirtualDirectoryImpl, Set<VFileCreateEvent>> entry : creations.entrySet()) {
            VirtualDirectoryImpl parent = entry.getKey();
            Collection createEvents = entry.getValue();
            this.applyCreateEventsInDirectory(parent, createEvents);
        }
    }

    private void applyCreateEventsInDirectory(@NotNull VirtualDirectoryImpl parent, @NotNull Collection<VFileCreateEvent> createEvents) {
        int parentId;
        NewVirtualFile vf;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(143);
        }
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(144);
        }
        if (!((vf = this.findFileById(parentId = PersistentFSImpl.fileId((VirtualFile)parent))) instanceof VirtualDirectoryImpl)) {
            return;
        }
        parent = (VirtualDirectoryImpl)vf;
        NewVirtualFileSystem fs = PersistentFSImpl.fileSystemOf((VirtualFile)parent);
        ArrayList<ChildInfo> childrenAdded = new ArrayList<ChildInfo>(createEvents.size());
        for (VFileCreateEvent createEvent : createEvents) {
            createEvent.resetCache();
            String name2 = createEvent.getChildName();
            Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, createEvent.getParent(), name2, createEvent.getAttributes(), createEvent.getSymlinkTarget());
            if (childData == null) continue;
            ChildInfo child = this.makeChildRecord((VirtualFile)parent, parentId, name2, childData, fs, createEvent.getChildren());
            childrenAdded.add(child);
        }
        childrenAdded.sort(ChildInfo.BY_ID);
        boolean caseSensitive = parent.isCaseSensitive();
        this.vfsPeer.update((VirtualFile)parent, parentId, oldChildren -> oldChildren.merge(this.vfsPeer, childrenAdded, caseSensitive), false);
        parent.initializeAndAddChildren(childrenAdded, false, (__, ___) -> {});
        this.saveScannedChildrenRecursively(createEvents, fs, parent.isCaseSensitive());
    }

    private void saveScannedChildrenRecursively(@NotNull Collection<VFileCreateEvent> createEvents, @NotNull NewVirtualFileSystem fs, boolean isCaseSensitive) {
        if (createEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(145);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(146);
        }
        for (VFileCreateEvent createEvent : createEvents) {
            VirtualFile createdDir;
            ChildInfo[] children2 = createEvent.getChildren();
            if (children2 == null || !createEvent.isDirectory() || !((createdDir = createEvent.getFile()) instanceof VirtualDirectoryImpl)) continue;
            ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
            queue.add(new Pair((Object)((VirtualDirectoryImpl)createdDir), (Object)children2));
            while (!queue.isEmpty()) {
                Pair queued = (Pair)queue.remove();
                VirtualDirectoryImpl directory = (VirtualDirectoryImpl)((Object)queued.first);
                List<ChildInfo> scannedChildren = Arrays.asList((ChildInfo[])queued.second);
                int directoryId = directory.getId();
                ArrayList<ChildInfo> added = new ArrayList<ChildInfo>(scannedChildren.size());
                for (ChildInfo childInfo2 : scannedChildren) {
                    CharSequence childName = childInfo2.getName();
                    Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, (VirtualFile)directory, childName.toString(), childInfo2.getFileAttributes(), childInfo2.getSymlinkTarget());
                    if (childData == null) continue;
                    added.add(this.makeChildRecord((VirtualFile)directory, directoryId, childName, childData, fs, childInfo2.getChildren()));
                }
                added.sort(ChildInfo.BY_ID);
                this.vfsPeer.update((VirtualFile)directory, directoryId, oldChildren -> oldChildren.merge(this.vfsPeer, added, isCaseSensitive), true);
                directory.initializeAndAddChildren(added, true, (childCreated, childInfo) -> {
                    if (childCreated instanceof VirtualDirectoryImpl && childInfo.getChildren() != null) {
                        queue.add(new Pair((Object)((VirtualDirectoryImpl)((Object)childCreated)), (Object)childInfo.getChildren()));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFileSystemEntry findRoot(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        boolean markModified;
        FsRoot newRoot;
        FileAttributes attributes;
        String rootPath;
        String rootName;
        if (path == null) {
            PersistentFSImpl.$$$reportNull$$$0(147);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(148);
        }
        if (!this.connected.get()) {
            LOG.info("VFS disconnected. Can't provide root for " + path + " in " + String.valueOf(fs));
            return null;
        }
        if (path.isEmpty()) {
            LOG.error("Invalid root, fs=" + String.valueOf(fs));
            return null;
        }
        String rootUrl = UriUtil.trimTrailingSlashes((String)VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)path));
        VirtualFileSystemEntry root = this.rootsByUrl.get(rootUrl);
        if (root != null) {
            return root;
        }
        if (fs instanceof ArchiveFileSystem) {
            ArchiveFileSystem afs = (ArchiveFileSystem)fs;
            VirtualFile localFile = afs.findLocalByRootPath(path);
            if (localFile == null) {
                return null;
            }
            rootName = localFile.getName();
            rootPath = afs.getRootPathByLocal(localFile);
            rootUrl = UriUtil.trimTrailingSlashes((String)VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)rootPath));
            attributes = afs.getArchiveRootAttributes((VirtualFile)new StubVirtualFile((VirtualFileSystem)fs){

                @NotNull
                public String getPath() {
                    String string = rootPath;
                    if (string == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Nullable
                public VirtualFile getParent() {
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$4", "getPath"));
                }
            });
        } else {
            rootName = rootPath = path;
            attributes = PersistentFSImpl.loadAttributes(fs, rootPath);
        }
        PersistentFSImpl.failIfPathIsLocalButNotLocalRoot(fs, path, rootPath, rootUrl);
        if (attributes == null || !attributes.isDirectory()) {
            return null;
        }
        attributes = attributes.withCaseSensitivity(FileAttributes.CaseSensitivity.fromBoolean((boolean)fs.isCaseSensitive()));
        FSRecordsImpl vfsPeer = this.vfsPeer;
        int rootId = vfsPeer.findOrCreateRootRecord(rootUrl);
        vfsPeer.loadRootData(rootId, path, fs);
        Map<String, VirtualFileSystemEntry> map2 = this.rootsByUrl;
        synchronized (map2) {
            root = this.rootsByUrl.get(rootUrl);
            if (root != null) {
                return root;
            }
            String pathBeforeSlash = UriUtil.trimTrailingSlashes((String)rootPath);
            boolean offlineByDefault = PersistentFSImpl.isOfflineByDefault(this.getFileAttributes(rootId));
            VfsData.Segment segment = this.vfsData.segmentForFileId(rootId, true);
            newRoot = FsRoot.create(rootId, segment, fs, pathBeforeSlash, attributes, offlineByDefault, path);
            this.incStructuralModificationCount();
            markModified = this.writeRootFields(rootId, rootName, fs.isCaseSensitive(), attributes) != -1;
            this.rootsByUrl.put(rootUrl, newRoot);
            this.missedRootIds.remove(rootId);
        }
        if (!markModified && attributes.lastModified != vfsPeer.getTimestamp(rootId)) {
            newRoot.markDirtyRecursively();
        }
        return newRoot;
    }

    private static void failIfPathIsLocalButNotLocalRoot(@NotNull NewVirtualFileSystem fs, @NotNull String path, String rootPath, String rootUrl) {
        FileAttributes parentAttributes;
        String parentPath;
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(149);
        }
        if (path == null) {
            PersistentFSImpl.$$$reportNull$$$0(150);
        }
        if (fs instanceof LocalFileSystem && !(parentPath = PathUtil.getParentPath((String)rootPath)).isEmpty() && (parentAttributes = PersistentFSImpl.loadAttributes(fs, parentPath)) != null) {
            throw new IllegalArgumentException("Must pass FS root path, but got: '" + path + "' (url: '" + rootUrl + "'), which has a parent '" + parentPath + "'. Use NewVirtualFileSystem.extractRootPath() for obtaining root path");
        }
    }

    @Nullable
    private static FileAttributes loadAttributes(@NotNull NewVirtualFileSystem fs, final @NotNull String path) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(151);
        }
        if (path == null) {
            PersistentFSImpl.$$$reportNull$$$0(152);
        }
        return fs.getAttributes((VirtualFile)new StubVirtualFile((VirtualFileSystem)fs){

            @NotNull
            public String getPath() {
                String string = path;
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public VirtualFile getParent() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$5", "getPath"));
            }
        });
    }

    @Override
    public void clearIdCache() {
        THROTTLED_LOG.warn(".clearIdCache() method is doing nothing now -> please, remove it's usage");
    }

    @Nullable
    public NewVirtualFile findFileById(int fileId) {
        if (fileId == 0) {
            this.fileByIdCacheHits.incrementAndGet();
            return null;
        }
        VfsData vfsData = this.vfsData;
        if (vfsData == null) {
            throw new AlreadyDisposedException("VFS is disconnected");
        }
        VirtualDirectoryImpl cached = vfsData.cachedDir(fileId);
        if (cached != null) {
            this.fileByIdCacheHits.incrementAndGet();
            return cached.isValid() ? cached : null;
        }
        this.fileByIdCacheMisses.incrementAndGet();
        NewVirtualFile file2 = new FileByIdResolver().resolve(fileId);
        return file2 != null && file2.isValid() ? file2 : null;
    }

    private void cacheMissedRootFromPersistence(int rootId) {
        String missedRootName;
        if (this.missedRootIds.contains(rootId)) {
            THROTTLED_LOG.warn("Can't find root[#" + rootId + "] in persistence");
            return;
        }
        Ref missedRootUrlRef = new Ref();
        this.vfsPeer.forEachRoot((rootFileId, rootUrlId) -> {
            if (rootId == rootFileId) {
                missedRootUrlRef.set((Object)this.getNameByNameId(rootUrlId));
                return false;
            }
            return true;
        });
        if (missedRootUrlRef.isNull()) {
            this.missedRootIds.add(rootId);
            THROTTLED_LOG.warn("Can't find root[#" + rootId + "] in persistence");
            return;
        }
        String missedRootUrl = (String)missedRootUrlRef.get();
        String missedRootPath = PersistentFSImpl.getRootPath(missedRootUrl, missedRootName = this.vfsPeer.getName(rootId));
        NewVirtualFile root = this.ensureRootCached(missedRootPath, missedRootUrl);
        if (root != null && root.getId() != rootId) {
            throw new IllegalStateException("root[#" + rootId + "]{rootName: '" + missedRootName + "', rootPath: '" + missedRootPath + "'} cached to something else: cached [#" + root.getId() + "]{rootName: '" + root.getName() + "', rootPath: '" + root.getPath() + "', rootUrl: '" + root.getUrl() + "'}, defaultCaseSensitivity: " + SystemInfoRt.isFileSystemCaseSensitive);
        }
    }

    @NotNull
    private static String getRootPath(@NotNull String rootUrl, @NotNull String rootName) {
        NewVirtualFileSystem fs;
        if (rootUrl == null) {
            PersistentFSImpl.$$$reportNull$$$0(153);
        }
        if (rootName == null) {
            PersistentFSImpl.$$$reportNull$$$0(154);
        }
        if ((fs = PersistentFSImpl.detectFileSystem(rootUrl)) instanceof ArchiveFileSystem) {
            String path = VirtualFileManager.extractPath((String)rootUrl);
            String string = StringUtil.trimEnd((String)path, (String)"!");
            if (string == null) {
                PersistentFSImpl.$$$reportNull$$$0(155);
            }
            return string;
        }
        String string = rootName;
        if (string == null) {
            PersistentFSImpl.$$$reportNull$$$0(156);
        }
        return string;
    }

    private NewVirtualFile ensureRootCached(@NotNull String missedRootPath, @NotNull String missedRootUrl) {
        NewVirtualFileSystem fs;
        if (missedRootPath == null) {
            PersistentFSImpl.$$$reportNull$$$0(157);
        }
        if (missedRootUrl == null) {
            PersistentFSImpl.$$$reportNull$$$0(158);
        }
        if ((fs = PersistentFSImpl.detectFileSystem(missedRootUrl)) == null) {
            return null;
        }
        try {
            VirtualFileSystemEntry cachedRoot = this.findRoot(missedRootPath, fs);
            if (LOG.isTraceEnabled()) {
                LOG.trace("\tforce caching " + missedRootUrl + " (protocol: " + fs.getProtocol() + ", path: " + missedRootPath + ") -> " + String.valueOf((Object)cachedRoot));
            }
            return cachedRoot;
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            StringBuilder sb = new StringBuilder();
            this.vfsPeer.forEachRoot((rootUrl, rootFileId) -> sb.append("[#").append(rootFileId).append("]: '").append((String)rootUrl).append("'\n"));
            LOG.warn("Can't cache root[url: " + missedRootUrl + "][path: " + missedRootPath + "]. \nAll roots: " + String.valueOf(sb), t);
            return null;
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @Nullable
    public static NewVirtualFileSystem detectFileSystem(@NotNull String rootUrl) {
        if (rootUrl == null) {
            PersistentFSImpl.$$$reportNull$$$0(159);
        }
        if (((String)rootUrl).endsWith(":")) {
            if (OSAgnosticPathUtil.startsWithWindowsDrive((String)rootUrl) && ((String)rootUrl).length() == 2) {
                throw new IllegalArgumentException("detectFileSystem(rootUrl='" + (String)rootUrl + "'): root URL is not an URL, but Win drive path");
            }
            rootUrl = (String)rootUrl + "///";
        }
        String protocol = VirtualFileManager.extractProtocol((String)rootUrl);
        VirtualFileSystem fs = VirtualFileManager.getInstance().getFileSystem(protocol);
        if (fs instanceof NewVirtualFileSystem) {
            return (NewVirtualFileSystem)fs;
        }
        if (fs == null) {
            THROTTLED_LOG.warn("\tdetectFileSystem(" + (String)rootUrl + ") -> protocol [" + protocol + "] is not registered (yet?)");
        } else {
            THROTTLED_LOG.warn("\tdetectFileSystem(" + (String)rootUrl + ") -> protocol [" + protocol + "] -> " + String.valueOf(fs) + " is not NewVirtualFileSystem");
        }
        return null;
    }

    public VirtualFile @NotNull [] getRoots() {
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.rootsByUrl.values());
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(160);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getRoots(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(161);
        }
        ArrayList<NewVirtualFile> roots = new ArrayList<NewVirtualFile>();
        for (NewVirtualFile newVirtualFile : this.rootsByUrl.values()) {
            if (newVirtualFile.getFileSystem() != fs) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(162);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getLocalRoots() {
        SmartList roots = new SmartList();
        for (NewVirtualFile newVirtualFile : this.rootsByUrl.values()) {
            if (!newVirtualFile.isInLocalFileSystem() || newVirtualFile.getFileSystem() instanceof TempFileSystem) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(163);
        }
        return virtualFileArray;
    }

    private void applyEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(164);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Applying " + String.valueOf(event));
        }
        try {
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent ce = (VFileCreateEvent)event;
                this.executeCreateChild(ce.getParent(), ce.getChildName(), ce.getAttributes(), ce.getSymlinkTarget(), ce.isEmptyDirectory());
            } else if (event instanceof VFileDeleteEvent) {
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)event;
                this.executeDelete(deleteEvent);
            } else if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent contentUpdateEvent = (VFileContentChangeEvent)event;
                VirtualFile file2 = contentUpdateEvent.getFile();
                long length = contentUpdateEvent.getNewLength();
                long timestamp = contentUpdateEvent.getNewTimestamp();
                if (!contentUpdateEvent.isLengthAndTimestampDiffProvided()) {
                    NewVirtualFileSystem fs = PersistentFSImpl.fileSystemOf(file2);
                    FileAttributes attributes = fs.getAttributes(file2);
                    length = attributes != null ? attributes.length : 0L;
                    timestamp = attributes != null ? attributes.lastModified : 0L;
                }
                boolean reloadContent = contentUpdateEvent.isFromRefresh() || contentUpdateEvent.getRequestor() == StorageUtilKt.RELOADING_STORAGE_WRITE_REQUESTOR;
                this.executeTouch(file2, reloadContent, contentUpdateEvent.getModificationStamp(), length, timestamp);
            } else if (event instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)event;
                this.executeCreateChild(ce.getNewParent(), ce.getNewChildName(), null, null, ce.getFile().getChildren().length == 0);
            } else if (event instanceof VFileMoveEvent) {
                VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                this.executeMove(moveEvent.getFile(), moveEvent.getNewParent());
            } else if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
                VirtualFile file3 = propertyChangeEvent.getFile();
                Object newValue = propertyChangeEvent.getNewValue();
                switch (propertyChangeEvent.getPropertyName()) {
                    case "name": {
                        this.executeRename(file3, (String)newValue);
                        break;
                    }
                    case "writable": {
                        this.executeSetWritable(file3, (Boolean)newValue);
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("File " + String.valueOf(file3) + " writable=" + file3.isWritable() + " id=" + PersistentFSImpl.fileId(file3));
                        break;
                    }
                    case "HIDDEN": {
                        this.executeSetHidden(file3, (Boolean)newValue);
                        break;
                    }
                    case "symlink": {
                        this.executeSetTarget(file3, (String)newValue);
                        break;
                    }
                    case "CHILDREN_CASE_SENSITIVITY": {
                        this.executeChangeCaseSensitivity((VirtualDirectoryImpl)file3, ((FileAttributes.CaseSensitivity)newValue).toBooleanOrFail());
                    }
                }
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @ApiStatus.Internal
    public void executeChangeCaseSensitivity(@NotNull VirtualDirectoryImpl directory, boolean newIsCaseSensitive) {
        if (directory == null) {
            PersistentFSImpl.$$$reportNull$$$0(165);
        }
        int fileId = PersistentFSImpl.fileId((VirtualFile)directory);
        this.vfsPeer.updateRecordFields(fileId, record -> {
            boolean sensitivityChanged = newIsCaseSensitive ? record.addFlags(256) : record.removeFlags(256);
            return record.addFlags(512) || sensitivityChanged;
        });
        directory.setCaseSensitivityFlag(newIsCaseSensitive);
    }

    @ApiStatus.Internal
    @Nullable
    public VFilePropertyChangeEvent determineCaseSensitivityAndPrepareUpdate(@NotNull VirtualFile parent, @NotNull String childName) {
        VirtualDirectoryImpl vDirectory;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(166);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(167);
        }
        if ((vDirectory = (VirtualDirectoryImpl)parent).getChildrenCaseSensitivity().isKnown()) {
            return null;
        }
        FileAttributes.CaseSensitivity actualDirCaseSensitivity = this.determineCaseSensitivity((VirtualFile)vDirectory, childName);
        if (actualDirCaseSensitivity.isUnknown()) {
            return null;
        }
        return this.prepareCaseSensitivityUpdateIfNeeded(vDirectory, actualDirCaseSensitivity.toBooleanOrFail());
    }

    @NotNull
    private FileAttributes.CaseSensitivity determineCaseSensitivity(@NotNull VirtualFile parent, @NotNull String childName) {
        VirtualFileSystem fileSystem;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(168);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(169);
        }
        if (!((fileSystem = parent.getFileSystem()) instanceof LocalFileSystemBase)) {
            FileAttributes.CaseSensitivity caseSensitivity = FileAttributes.CaseSensitivity.UNKNOWN;
            if (caseSensitivity == null) {
                PersistentFSImpl.$$$reportNull$$$0(170);
            }
            return caseSensitivity;
        }
        FileAttributes.CaseSensitivity actualDirCaseSensitivity = ((LocalFileSystemBase)fileSystem).fetchCaseSensitivity(parent, childName);
        this.caseSensitivityReads.incrementAndGet();
        FileAttributes.CaseSensitivity caseSensitivity = actualDirCaseSensitivity;
        if (caseSensitivity == null) {
            PersistentFSImpl.$$$reportNull$$$0(171);
        }
        return caseSensitivity;
    }

    @ApiStatus.Internal
    public VFilePropertyChangeEvent prepareCaseSensitivityUpdateIfNeeded(@NotNull VirtualDirectoryImpl dir, boolean actualIsCaseSensitive) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(172);
        }
        FileAttributes.CaseSensitivity currentCaseSensitivity = dir.getChildrenCaseSensitivity();
        boolean currentIsCaseSensitive = dir.isCaseSensitive();
        if (currentIsCaseSensitive == actualIsCaseSensitive) {
            if (currentCaseSensitivity.isUnknown()) {
                this.executeChangeCaseSensitivity(dir, actualIsCaseSensitive);
            }
            return null;
        }
        return new VFilePropertyChangeEvent(VFileEvent.REFRESH_REQUESTOR, (VirtualFile)dir, "CHILDREN_CASE_SENSITIVITY", (Object)currentCaseSensitivity, (Object)FileAttributes.CaseSensitivity.fromBoolean((boolean)actualIsCaseSensitive));
    }

    public String toString() {
        return "PersistentFSImpl[connected: " + this.isConnected() + ", ownData: " + String.valueOf(this.vfsData) + "]";
    }

    private void executeCreateChild(final @NotNull VirtualFile parent, final @NotNull String name2, @Nullable FileAttributes attributes, @Nullable String symlinkTarget, boolean isEmptyDirectory) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(173);
        }
        if (name2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(174);
        }
        assert (parent instanceof VirtualDirectoryImpl) : parent;
        final NewVirtualFileSystem fs = PersistentFSImpl.fileSystemOf(parent);
        VirtualDirectoryImpl parentDir = (VirtualDirectoryImpl)parent;
        final int parentId = PersistentFSImpl.fileId(parent);
        final Pair<@NotNull FileAttributes, String> childData = PersistentFSImpl.getChildData(fs, parent, name2, attributes, symlinkTarget);
        if (childData == null) {
            return;
        }
        class ChildInserter
        implements Function<ListResult, ListResult> {
            ChildInfo insertedChildInfo = null;

            ChildInserter() {
            }

            @Override
            @NotNull
            public ListResult apply(@NotNull ListResult children2) {
                ChildInfo duplicate;
                if (children2 == null) {
                    ChildInserter.$$$reportNull$$$0(0);
                }
                if ((duplicate = PersistentFSImpl.this.findExistingChildInfo(children2.children, name2, parent.isCaseSensitive())) != null) {
                    ListResult listResult = children2;
                    if (listResult == null) {
                        ChildInserter.$$$reportNull$$$0(1);
                    }
                    return listResult;
                }
                this.insertedChildInfo = PersistentFSImpl.this.makeChildRecord(parent, parentId, name2, (Pair<FileAttributes, String>)childData, fs, null);
                ListResult listResult = children2.insert(this.insertedChildInfo);
                if (listResult == null) {
                    ChildInserter.$$$reportNull$$$0(2);
                }
                return listResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "children";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$1ChildInserter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$1ChildInserter";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "apply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "apply";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }
        ChildInserter inserter = new ChildInserter();
        this.vfsPeer.update(parent, parentId, inserter, isEmptyDirectory);
        if (inserter.insertedChildInfo == null) {
            return;
        }
        int childId = inserter.insertedChildInfo.getId();
        int nameId = inserter.insertedChildInfo.getNameId();
        VirtualFileSystemEntry child = parentDir.initializeChildDataIfNotYet(childId, nameId, PersistentFSImpl.fileAttributesToFlags((FileAttributes)childData.first), isEmptyDirectory);
        parentDir.addChild(child);
        this.incStructuralModificationCount();
    }

    @NotNull
    private ChildInfo makeChildRecord(@NotNull VirtualFile parentFile, int parentId, @NotNull CharSequence name2, @NotNull @NotNull Pair<@NotNull FileAttributes, String> childData, @NotNull NewVirtualFileSystem fs, @NotNull ChildInfo @Nullable [] children2) {
        if (parentFile == null) {
            PersistentFSImpl.$$$reportNull$$$0(175);
        }
        if (name2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(176);
        }
        if (childData == null) {
            PersistentFSImpl.$$$reportNull$$$0(177);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(178);
        }
        assert (parentId > 0) : parentId;
        FileAttributes attributes = (FileAttributes)childData.first;
        String symLinkTarget = (String)childData.second;
        int newChildId = this.vfsPeer.createRecord();
        int nameId = this.vfsPeer.updateRecordFields(newChildId, parentId, attributes, name2.toString(), true);
        if (attributes.isDirectory()) {
            this.vfsPeer.loadDirectoryData(newChildId, parentFile, name2, fs);
        }
        return new ChildInfoImpl(newChildId, nameId, attributes, children2, symLinkTarget);
    }

    public void moveChildren(int fromParentId, int toParentId) {
        if (fromParentId == -1) {
            return;
        }
        if (fromParentId == 0) {
            throw new AssertionError((Object)("Move(" + fromParentId + " -> " + toParentId + "): can't move root to become non-root"));
        }
        this.vfsPeer.moveChildren(fromParentId, toParentId);
    }

    private static @Nullable Pair<@NotNull FileAttributes, String> getChildData(@NotNull NewVirtualFileSystem fs, @NotNull VirtualFile parent, @NotNull String name2, @Nullable FileAttributes attributes, @Nullable String symlinkTarget) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(179);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(180);
        }
        if (name2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(181);
        }
        if (attributes == null) {
            if (".".equals(name2) || "..".equals(name2)) {
                return null;
            }
            FakeVirtualFile virtualFile2 = new FakeVirtualFile(parent, name2);
            attributes = fs.getAttributes((VirtualFile)virtualFile2);
            symlinkTarget = attributes != null && attributes.isSymLink() ? fs.resolveSymLink((VirtualFile)virtualFile2) : null;
        }
        return attributes == null ? null : new Pair((Object)attributes, (Object)symlinkTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(@NotNull VFileDeleteEvent event) {
        int parentId;
        VirtualFile file2;
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(182);
        }
        if (!(file2 = event.getFile()).exists()) {
            LOG.error("Deleting a file which does not exist in VFS: #" + ((VirtualFileWithId)file2).getId() + ", path: " + file2.getPath());
            return;
        }
        int fileIdToDelete = PersistentFSImpl.fileId(file2);
        VirtualFile parent = file2.getParent();
        int n = parentId = parent != null ? PersistentFSImpl.fileId(parent) : 0;
        if (parentId == 0) {
            String rootUrl = UriUtil.trimTrailingSlashes((String)file2.getUrl());
            Map<String, VirtualFileSystemEntry> map2 = this.rootsByUrl;
            synchronized (map2) {
                this.rootsByUrl.remove(rootUrl);
                this.vfsPeer.deleteRootRecord(fileIdToDelete);
            }
        } else {
            this.vfsPeer.update(parent, parentId, children2 -> children2.remove(fileIdToDelete), false);
            ((VirtualDirectoryImpl)parent).removeChild((VirtualFileSystemEntry)file2);
        }
        this.vfsPeer.deleteRecordRecursively(fileIdToDelete);
        PersistentFSImpl.invalidateSubtree(file2, "File deleted", event);
        this.incStructuralModificationCount();
    }

    private static void invalidateSubtree(@NotNull VirtualFile file2, @NotNull Object source, @NotNull Object reason) {
        VirtualFileSystemEntry root;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(183);
        }
        if (source == null) {
            PersistentFSImpl.$$$reportNull$$$0(184);
        }
        if (reason == null) {
            PersistentFSImpl.$$$reportNull$$$0(185);
        }
        if ((root = (VirtualFileSystemEntry)file2).isDirectory()) {
            ArrayDeque queue = new ArrayDeque(root.getCachedChildren());
            while (!queue.isEmpty()) {
                VirtualFileSystemEntry child = (VirtualFileSystemEntry)((Object)queue.remove());
                queue.addAll(child.getCachedChildren());
                PersistentFSImpl.doInvalidate(child, source, reason);
            }
        }
        PersistentFSImpl.doInvalidate(root, source, reason);
    }

    private static void doInvalidate(@NotNull VirtualFileSystemEntry file2, @NotNull Object source, @NotNull Object reason) {
        NewVirtualFileSystem fs;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(186);
        }
        if (source == null) {
            PersistentFSImpl.$$$reportNull$$$0(187);
        }
        if (reason == null) {
            PersistentFSImpl.$$$reportNull$$$0(188);
        }
        if (file2.is(VFileProperty.SYMLINK) && (fs = file2.getFileSystem()) instanceof LocalFileSystemImpl) {
            ((LocalFileSystemImpl)fs).symlinkRemoved(file2.getId());
        }
        file2.invalidate(source, reason);
    }

    private void executeRename(@NotNull VirtualFile file2, @NotNull String newName) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(189);
        }
        if (newName == null) {
            PersistentFSImpl.$$$reportNull$$$0(190);
        }
        ((VirtualFileSystemEntry)file2).setNewName(newName);
    }

    private void executeSetWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(191);
        }
        this.setFlag(file2, 4, !writableFlag);
        ((VirtualFileSystemEntry)file2).setWritableFlag(writableFlag);
    }

    private void executeSetHidden(@NotNull VirtualFile file2, boolean hiddenFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(192);
        }
        this.setFlag(file2, 64, hiddenFlag);
        ((VirtualFileSystemEntry)file2).setHiddenFlag(hiddenFlag);
    }

    @ApiStatus.Experimental
    @ApiStatus.Obsolete
    public static void setOfflineByDefault(@NotNull VirtualFile file2, boolean offlineByDefaultFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(193);
        }
        ((PersistentFSImpl)PersistentFSImpl.getInstance()).offlineByDefault(file2, offlineByDefaultFlag);
    }

    @ApiStatus.Experimental
    public void offlineByDefault(@NotNull VirtualFile file2, boolean offlineByDefaultFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(194);
        }
        this.setFlag(file2, 2048, offlineByDefaultFlag);
        if (offlineByDefaultFlag) {
            ((VirtualFileSystemEntry)file2).setOffline(true);
        }
    }

    private void executeSetTarget(@NotNull VirtualFile file2, @Nullable String target) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(195);
        }
        int id2 = PersistentFSImpl.fileId(file2);
        this.vfsPeer.storeSymlinkTarget(id2, target);
        VirtualFileSystem fs = file2.getFileSystem();
        if (fs instanceof LocalFileSystemImpl) {
            ((LocalFileSystemImpl)fs).symlinkUpdated(id2, file2.getParent(), file2.getNameSequence(), file2.getPath(), target);
        }
    }

    private void setFlag(@NotNull VirtualFile file2, @PersistentFS.Attributes int flagsMask, boolean value) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(196);
        }
        int fileId = PersistentFSImpl.fileId(file2);
        this.vfsPeer.updateRecordFields(fileId, record -> {
            if (value) {
                return record.addFlags(flagsMask);
            }
            return record.removeFlags(flagsMask);
        });
    }

    /*
     * WARNING - void declaration
     */
    private void executeTouch(@NotNull VirtualFile file2, boolean reloadContentFromFS, long newModificationStamp, long newLength, long l) {
        void newTimestamp;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(197);
        }
        int fileId = PersistentFSImpl.fileId(file2);
        this.vfsPeer.updateRecordFields(fileId, arg_0 -> PersistentFSImpl.lambda$executeTouch$41(reloadContentFromFS, newLength, (long)newTimestamp, arg_0));
        ((VirtualFileSystemEntry)file2).setModificationStamp(newModificationStamp);
    }

    private void executeMove(@NotNull VirtualFile file2, @NotNull VirtualFile newParent) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(198);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(199);
        }
        int childToMoveId = PersistentFSImpl.fileId(file2);
        int newParentId = PersistentFSImpl.fileId(newParent);
        VirtualFile oldParent = file2.getParent();
        int oldParentId = PersistentFSImpl.fileId(oldParent);
        this.vfsPeer.moveChild(() -> ((VirtualFile)newParent).isCaseSensitive(), oldParentId, newParentId, childToMoveId);
        ((VirtualFileSystemEntry)file2).setParent(newParent);
    }

    @Override
    @NotNull
    public String getName(int fileId) {
        assert (fileId > 0);
        String string = this.vfsPeer.getName(fileId);
        if (string == null) {
            PersistentFSImpl.$$$reportNull$$$0(200);
        }
        return string;
    }

    @TestOnly
    public void cleanPersistedContent(int fileId) {
        this.doCleanPersistedContent(fileId);
    }

    @TestOnly
    public void cleanPersistedContents() {
        IntArrayList ids = new IntArrayList(this.vfsPeer.listRoots());
        while (!ids.isEmpty()) {
            int id2 = ids.popInt();
            if (PersistentFSImpl.isDirectory(this.getFileAttributes(id2))) {
                this.vfsPeer.forEachChildOf(id2, childId -> {
                    ids.add(childId);
                    return false;
                });
                continue;
            }
            this.doCleanPersistedContent(id2);
        }
    }

    private void doCleanPersistedContent(int id2) {
        this.vfsPeer.updateRecordFields(id2, record -> record.addFlags(136));
    }

    @Override
    public boolean mayHaveChildren(int id2) {
        try {
            return this.vfsPeer.maybeHaveChildren(id2);
        }
        catch (IllegalArgumentException e) {
            this.vfsPeer.handleError(e);
            throw e;
        }
    }

    @ApiStatus.Internal
    public FSRecordsImpl peer() {
        return this.vfsPeer;
    }

    @ApiStatus.Internal
    public void incrementFindChildByNameCount() {
        this.childByName.incrementAndGet();
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public Iterable<? extends VirtualFileSystemEntry> getDirCache() {
        Iterable<? extends VirtualFileSystemEntry> iterable = this.vfsData.getCachedDirs();
        if (iterable == null) {
            PersistentFSImpl.$$$reportNull$$$0(201);
        }
        return iterable;
    }

    static @PersistentFS.Attributes int fileAttributesToFlags(@NotNull FileAttributes attributes) {
        if (attributes == null) {
            PersistentFSImpl.$$$reportNull$$$0(202);
        }
        FileAttributes.CaseSensitivity sensitivity = attributes.areChildrenCaseSensitive();
        return PersistentFSImpl.fileAttributesToFlags(attributes.isDirectory(), attributes.isWritable(), attributes.isSymLink(), attributes.isSpecial(), attributes.isHidden(), sensitivity.isKnown(), sensitivity.isSensitive());
    }

    public static @PersistentFS.Attributes int fileAttributesToFlags(boolean isDirectory, boolean isWritable, boolean isSymLink, boolean isSpecial, boolean isHidden, boolean isChildrenCaseSensitivityCached, boolean areChildrenCaseSensitive) {
        return (isDirectory ? 2 : 0) | (isWritable ? 0 : 4) | (isSymLink ? 16 : 0) | (isSpecial ? 32 : 0) | (isHidden ? 64 : 0) | (isChildrenCaseSensitivityCached ? 512 : 0) | (areChildrenCaseSensitive ? 256 : 0);
    }

    private static void checkReadAccess() {
        switch (READ_ACCESS_CHECK_KIND) {
            case 1: {
                ThreadingAssertions.softAssertReadAccess();
                break;
            }
            case 2: {
                ThreadingAssertions.assertReadAccess();
                break;
            }
            case 3: {
                ThreadingAssertions.assertNoReadAccess();
                break;
            }
        }
    }

    private BatchCallback setupOTelMonitoring(@NotNull Meter meter) {
        if (meter == null) {
            PersistentFSImpl.$$$reportNull$$$0(203);
        }
        ObservableLongMeasurement fileByIdCacheHitsCounter = meter.counterBuilder("VFS.fileByIdCache.hits").buildObserver();
        ObservableLongMeasurement fileByIdCacheMissesCounter = meter.counterBuilder("VFS.fileByIdCache.misses").buildObserver();
        ObservableLongMeasurement fileChildByNameCounter = meter.counterBuilder("VFS.fileChildByName").buildObserver();
        ObservableLongMeasurement caseSensitivityReadsCounter = meter.counterBuilder("VFS.folderCaseSensitivityReads").buildObserver();
        ObservableDoubleMeasurement rootsCounter = meter.gaugeBuilder("VFS.rootsCount").buildObserver();
        ObservableLongMeasurement invertedFileNameIndexRequestsCount = meter.counterBuilder("VFS.invertedFileNameIndex.requests").buildObserver();
        return meter.batchCallback(() -> {
            fileByIdCacheHitsCounter.record(this.fileByIdCacheHits.get());
            fileByIdCacheMissesCounter.record(this.fileByIdCacheMisses.get());
            fileChildByNameCounter.record(this.childByName.get());
            caseSensitivityReadsCounter.record(this.caseSensitivityReads.get());
            rootsCounter.record((double)this.rootsByUrl.size());
            FSRecordsImpl vfs = this.vfsPeer;
            if (vfs != null) {
                invertedFileNameIndexRequestsCount.record(vfs.invertedNameIndexRequestsServed());
            }
        }, (ObservableMeasurement)fileByIdCacheHitsCounter, new ObservableMeasurement[]{fileByIdCacheMissesCounter, fileChildByNameCounter, caseSensitivityReadsCounter, rootsCounter, invertedFileNameIndexRequestsCount});
    }

    private static /* synthetic */ boolean lambda$executeTouch$41(boolean reloadContentFromFS, long newLength, long newTimestamp, IPersistentFSRecordsStorage.RecordForUpdate record) throws IOException {
        if (reloadContentFromFS) {
            record.addFlags(8);
        }
        record.setLength(newLength);
        record.removeFlags(128);
        record.setTimestamp(newTimestamp);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 9, 11, 13, 14, 18, 23, 28, 29, 31, 56, 59, 62, 68, 70, 71, 72, 74, 77, 155, 156, 160, 162, 163, 170, 171, 200, 201 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryIdsToRefresh";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 28: 
            case 29: 
            case 31: 
            case 56: 
            case 59: 
            case 62: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 77: 
            case 155: 
            case 156: 
            case 160: 
            case 162: 
            case 163: 
            case 170: 
            case 171: 
            case 200: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 19: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 8: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 51: 
            case 52: 
            case 53: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 73: 
            case 75: 
            case 78: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 102: 
            case 183: 
            case 186: 
            case 189: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 46: 
            case 54: 
            case 57: 
            case 60: 
            case 143: 
            case 166: 
            case 168: 
            case 173: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenNamesToAdd";
                break;
            }
            case 17: 
            case 22: 
            case 48: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 161: 
            case 178: 
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenWithAttributes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "att";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 32: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 34: 
            case 55: 
            case 174: 
            case 176: 
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 47: 
            case 50: 
            case 61: 
            case 167: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childDirectoryName";
                break;
            }
            case 66: 
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeStream";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContent";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 88: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 89: 
            case 101: 
            case 104: 
            case 108: 
            case 164: 
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r1";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r2";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r3";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r4";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r5";
                break;
            }
            case 95: 
            case 109: 
            case 120: 
            case 124: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 96: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesInvolved";
                break;
            }
            case 97: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleDirsInvolved";
                break;
            }
            case 98: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 99: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCreate";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventsToRemove";
                break;
            }
            case 105: 
            case 147: 
            case 150: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleDirs";
                break;
            }
            case 110: 
            case 118: 
            case 122: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outApplyActions";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidatedEvents";
                break;
            }
            case 115: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
            case 117: 
            case 121: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidated";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 128: 
            case 131: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "earlyAfterEventChangeAppliers";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publisher";
                break;
            }
            case 130: 
            case 135: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publisherBackgroundable";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyActions";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyEvents";
                break;
            }
            case 134: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publisherEdt";
                break;
            }
            case 136: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSend";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletions";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creations";
                break;
            }
            case 144: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createEvents";
                break;
            }
            case 153: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootName";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missedRootPath";
                break;
            }
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missedRootUrl";
                break;
            }
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childData";
                break;
            }
            case 184: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 185: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisherEdt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisherBackgroundable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fileSystemOf";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "listPersisted";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "listAll";
                break;
            }
            case 18: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewChildrenRecords";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentById";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "writeContent";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildFile";
                break;
            }
            case 68: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplicatorAndStoreContent";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 160: 
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRoots";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "determineCaseSensitivity";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshSuspiciousDirectories";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 28: 
            case 29: 
            case 31: 
            case 56: 
            case 59: 
            case 62: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 77: 
            case 155: 
            case 156: 
            case 160: 
            case 162: 
            case 163: 
            case 170: 
            case 171: 
            case 200: 
            case 201: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "areChildrenLoaded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileSystemOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wereChildrenAccessed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "listPersisted";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "listAll";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createNewChildrenRecords";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "storeUnlinkedContent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getModificationCount";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "writeRootFields";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "fileId";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findChildInfo";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findExistingChildInfo";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getLastRecordedLength";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isUtf8BomRequired";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 67: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createReplicatorAndStoreContent";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "storeContentToStorage";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "updateContentForFile";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getContentHashIfStored";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "contentHashIfStored";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "acquireContent";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentContentId";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isOwnData";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "runSuppressing";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "groupByPath";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativePath";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "removeNestedDelete";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "eventConflictsWithPrevious";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "isContentChangeLikeHarmlessEvent";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "groupAndValidate";
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "groupCreations";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "groupDeletions";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "groupOthers";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "processEventsImpl";
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "applyMultipleEvents";
                break;
            }
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeEvents";
                break;
            }
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterEvents";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "applyDeletions";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "applyCreations";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "applyCreateEventsInDirectory";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "saveScannedChildrenRecursively";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "failIfPathIsLocalButNotLocalRoot";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "loadAttributes";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "getRootPath";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "ensureRootCached";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "detectFileSystem";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "applyEvent";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "executeChangeCaseSensitivity";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "determineCaseSensitivityAndPrepareUpdate";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "determineCaseSensitivity";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "prepareCaseSensitivityUpdateIfNeeded";
                break;
            }
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "executeCreateChild";
                break;
            }
            case 175: 
            case 176: 
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "makeChildRecord";
                break;
            }
            case 179: 
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "getChildData";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "executeDelete";
                break;
            }
            case 183: 
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "invalidateSubtree";
                break;
            }
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "doInvalidate";
                break;
            }
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "executeRename";
                break;
            }
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "executeSetWritable";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "executeSetHidden";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "setOfflineByDefault";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "offlineByDefault";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "executeSetTarget";
                break;
            }
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "setFlag";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "executeTouch";
                break;
            }
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "executeMove";
                break;
            }
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "fileAttributesToFlags";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "setupOTelMonitoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 9, 11, 13, 14, 18, 23, 28, 29, 31, 56, 59, 62, 68, 70, 71, 72, 74, 77, 155, 156, 160, 162, 163, 170, 171, 200, 201 -> new IllegalStateException(string);
        };
    }

    private static class LengthAndContentIdReader
    implements IPersistentFSRecordsStorage.RecordReader<LengthAndContentIdReader> {
        private long length;
        private int contentRecordId;

        private LengthAndContentIdReader() {
        }

        @Override
        public LengthAndContentIdReader readRecord(@NotNull IPersistentFSRecordsStorage.RecordForRead record) throws IOException {
            if (record == null) {
                LengthAndContentIdReader.$$$reportNull$$$0(0);
            }
            int flags = record.getFlags();
            boolean mustReloadLength = BitUtil.isSet((int)flags, (int)128);
            boolean mustReloadContent = BitUtil.isSet((int)flags, (int)8);
            this.length = mustReloadLength ? -1L : record.getLength();
            boolean contentOutdated = this.length == -1L || mustReloadContent;
            this.contentRecordId = contentOutdated ? -1 : record.getContentRecordId();
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$LengthAndContentIdReader", "readRecord"));
        }
    }

    final class FileByIdResolver {
        @Nullable
        private IntList nonCachedAncestorsIds;

        FileByIdResolver() {
        }

        public NewVirtualFile resolve(int fileId) {
            VirtualDirectoryImpl cachedAncestorOrSelf;
            assert (fileId != 0) : "fileId=NULL_ID(0) must not be passed into resolve()";
            try {
                cachedAncestorOrSelf = this.lookupCachedAncestorOrSelf(fileId);
                if (cachedAncestorOrSelf == null) {
                    return null;
                }
                if (cachedAncestorOrSelf.getId() == fileId) {
                    return cachedAncestorOrSelf;
                }
            }
            catch (Exception e) {
                throw PersistentFSImpl.this.vfsPeer.handleError(e);
            }
            return FileByIdResolver.resolveDescending(cachedAncestorOrSelf, this.nonCachedAncestorsIds, fileId);
        }

        @Nullable
        private VirtualDirectoryImpl lookupCachedAncestorOrSelf(int fileId) {
            int currentId = fileId;
            while (true) {
                int parentId;
                if ((parentId = PersistentFSImpl.this.vfsPeer.getParent(currentId)) != 0) {
                    VirtualDirectoryImpl cachedParent = PersistentFSImpl.this.vfsData.cachedDir(parentId);
                    if (cachedParent != null) {
                        return cachedParent.isValid() ? cachedParent : null;
                    }
                } else {
                    PersistentFSImpl.this.cacheMissedRootFromPersistence(currentId);
                    VirtualDirectoryImpl cachedRoot = PersistentFSImpl.this.vfsData.cachedDir(currentId);
                    if (cachedRoot != null) {
                        if (!cachedRoot.isValid()) {
                            return null;
                        }
                        if (this.nonCachedAncestorsIds != null && !this.nonCachedAncestorsIds.isEmpty()) {
                            this.nonCachedAncestorsIds.removeInt(this.nonCachedAncestorsIds.size() - 1);
                        } else {
                            this.nonCachedAncestorsIds = null;
                        }
                        return cachedRoot;
                    }
                    this.logVeryDetailedErrorMessageAboutParentNotFound(currentId, fileId);
                    return null;
                }
                if (this.nonCachedAncestorsIds != null && this.nonCachedAncestorsIds.size() % 128 == 0 && this.nonCachedAncestorsIds.contains(parentId)) {
                    throw new AssertionError((Object)("Cyclic parent-child relations: fileId: " + fileId + ", current parentId: " + parentId + ", path: " + String.valueOf(this.nonCachedAncestorsIds)));
                }
                if (this.nonCachedAncestorsIds == null) {
                    this.nonCachedAncestorsIds = new IntArrayList(10);
                }
                this.nonCachedAncestorsIds.add(parentId);
                currentId = parentId;
            }
        }

        @Nullable
        private static VirtualFileSystemEntry resolveDescending(@NotNull VirtualDirectoryImpl cachedRoot, @Nullable IntList nonCachedAncestorsIds, int fileId) {
            if (cachedRoot == null) {
                FileByIdResolver.$$$reportNull$$$0(0);
            }
            VirtualDirectoryImpl currentDir = cachedRoot;
            if (nonCachedAncestorsIds != null) {
                for (int i2 = nonCachedAncestorsIds.size() - 1; i2 >= 0; --i2) {
                    if ((currentDir = (VirtualDirectoryImpl)FileByIdResolver.findChild(currentDir, nonCachedAncestorsIds.getInt(i2))) != null) continue;
                    return null;
                }
            }
            return FileByIdResolver.findChild(currentDir, fileId);
        }

        @Nullable
        private static VirtualFileSystemEntry findChild(@NotNull VirtualDirectoryImpl parent, int childId) {
            if (parent == null) {
                FileByIdResolver.$$$reportNull$$$0(1);
            }
            try {
                return parent.findChildById(childId);
            }
            catch (FileDeletedException e) {
                return null;
            }
        }

        private void logVeryDetailedErrorMessageAboutParentNotFound(int currentId, int startingFileId) {
            String preRootFileName = PersistentFSImpl.this.vfsPeer.getName(currentId);
            int preRootIdFlags = PersistentFSImpl.this.vfsPeer.getFlags(currentId);
            int startingFileFlags = PersistentFSImpl.this.vfsPeer.getFlags(startingFileId);
            THROTTLED_LOG.warn(() -> {
                IntOpenHashSet cachedRootsIds = new IntOpenHashSet();
                IntOpenHashSet rootIds = new IntOpenHashSet();
                for (VirtualFile root : PersistentFSImpl.this.getRoots()) {
                    rootIds.add(((VirtualFileWithId)root).getId());
                }
                int[] nonCachedRoots = rootIds.intStream().filter(rootId -> !cachedRootsIds.contains(rootId)).toArray();
                int[] cachedNonRoots = cachedRootsIds.intStream().filter(rootId -> !rootIds.contains(rootId)).toArray();
                int[] fsRootsNonPFSRoots = Arrays.stream(PersistentFSImpl.this.vfsPeer.listRoots()).filter(rootId -> !rootIds.contains(rootId)).toArray();
                boolean fsRootsHasCurrentId = Arrays.stream(PersistentFSImpl.this.vfsPeer.listRoots()).anyMatch(rootId -> rootId == currentId);
                StringBuilder nonCachedRootsPerLine = new StringBuilder();
                if (LOG_NON_CACHED_ROOTS_LIST) {
                    PersistentFSImpl.this.vfsPeer.forEachRoot((rootUrl, rootFileId) -> {
                        if (PersistentFSImpl.this.vfsData.cachedDir(rootFileId) == null) {
                            String rootName = PersistentFSImpl.this.vfsPeer.getName(rootFileId);
                            nonCachedRootsPerLine.append("\t").append(rootFileId).append(": [name:'").append(rootName).append("'][url:'").append((String)rootUrl).append("']\n");
                        }
                    });
                }
                StringBuilder relativePath = new StringBuilder();
                if (this.nonCachedAncestorsIds != null) {
                    for (int i2 = this.nonCachedAncestorsIds.size() - 1; i2 >= 0; --i2) {
                        int fileId = this.nonCachedAncestorsIds.getInt(i2);
                        String fileName = PersistentFSImpl.this.vfsPeer.getName(fileId);
                        relativePath.append('/').append(fileName);
                    }
                }
                return "file[" + startingFileId + ", flags: " + startingFileFlags + "]: top parent (id: " + currentId + ", name: '" + preRootFileName + "', flags: " + preRootIdFlags + " parent: 0), is still not in the idToDirCache. path: " + String.valueOf(this.nonCachedAncestorsIds) + " [" + String.valueOf(relativePath) + "], cachedRoots.size(=" + cachedRootsIds.size() + "), roots.size(=" + rootIds.size() + "), pfs.roots.contains(" + currentId + ")=" + rootIds.contains(currentId) + ", fs.roots.contains(" + currentId + ")=" + fsRootsHasCurrentId + ", non-cached roots: " + nonCachedRoots.length + ", cached non-roots: " + cachedNonRoots.length + ", FS roots not PFS roots: " + fsRootsNonPFSRoots.length + ": \n" + String.valueOf(nonCachedRootsPerLine);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedRoot";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$FileByIdResolver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveDescending";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findChild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

