/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.mapped.content;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSContentAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.mapped.content.ContentStorageAdapterKt;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.storage.IStorage;
import com.intellij.util.io.storage.RecordIdIterator;
import com.intellij.util.io.storage.RefCountingContentStorage;
import com.intellij.util.io.storage.VFSContentStorage;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u001cH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001cH\u0016J\b\u0010,\u001a\u00020\u0016H\u0016J\b\u0010-\u001a\u00020\u0016H\u0016J\b\u0010.\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/mapped/content/ContentStorageAdapter;", "Lcom/intellij/util/io/storage/VFSContentStorage;", "contentStorage", "Lcom/intellij/util/io/storage/RefCountingContentStorage;", "hashesEnumeratorSupplier", "Lcom/intellij/openapi/util/ThrowableComputable;", "Lcom/intellij/util/hash/ContentHashEnumerator;", "Ljava/io/IOException;", "<init>", "(Lcom/intellij/util/io/storage/RefCountingContentStorage;Lcom/intellij/openapi/util/ThrowableComputable;)V", "hashesEnumerator", "lock", "Ljava/util/concurrent/locks/ReadWriteLock;", "totalContentBytesStored", "", "totalContentBytesReused", "totalContentRecordsStored", "", "totalContentRecordsReused", "totalHashCalculationTimeNs", "tryRebuildHashesStorageByContentStorage", "fillHashesEnumeratorByContentStorage", "", "Lcom/intellij/util/io/storage/IStorage;", "hashesEnumeratorToFill", "createRecordIdIterator", "Lcom/intellij/util/io/storage/RecordIdIterator;", "isEmpty", "", "getRecordsCount", "getVersion", "setVersion", "expectedVersion", "checkRecord", "recordId", "fastCheck", "contentHash", "", "readStream", "Ljava/io/DataInputStream;", "storeRecord", "contentBytes", "Lcom/intellij/openapi/util/io/ByteArraySequence;", "isDirty", "force", "close", "closeAndClean", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nContentStorageAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentStorageAdapter.kt\ncom/intellij/openapi/vfs/newvfs/persistent/mapped/content/ContentStorageAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class ContentStorageAdapter
implements VFSContentStorage {
    @NotNull
    private final RefCountingContentStorage contentStorage;
    @NotNull
    private final ContentHashEnumerator hashesEnumerator;
    @NotNull
    private final ReadWriteLock lock;
    private long totalContentBytesStored;
    private long totalContentBytesReused;
    private int totalContentRecordsStored;
    private int totalContentRecordsReused;
    private long totalHashCalculationTimeNs;

    public ContentStorageAdapter(@NotNull RefCountingContentStorage contentStorage, @NotNull ThrowableComputable<ContentHashEnumerator, IOException> hashesEnumeratorSupplier) {
        Intrinsics.checkNotNullParameter((Object)contentStorage, (String)"contentStorage");
        Intrinsics.checkNotNullParameter(hashesEnumeratorSupplier, (String)"hashesEnumeratorSupplier");
        this.contentStorage = contentStorage;
        this.lock = new ReentrantReadWriteLock();
        ContentHashEnumerator hashesEnumerator = (ContentHashEnumerator)hashesEnumeratorSupplier.compute();
        int hashRecordsCount = hashesEnumerator.recordsCount();
        int recordsCount = contentStorage.getRecordsCount();
        if (hashRecordsCount != recordsCount) {
            ContentStorageAdapterKt.access$getLOG$p().warn("Content storage is not match content hash enumerator: contents.records(=" + recordsCount + ") != contentHashes.records(=" + hashRecordsCount + ") -> trying rebuild hashesEnumerator from content storage");
            hashesEnumerator.closeAndClean();
            this.hashesEnumerator = this.tryRebuildHashesStorageByContentStorage(hashesEnumeratorSupplier);
        } else {
            Intrinsics.checkNotNull((Object)hashesEnumerator);
            this.hashesEnumerator = hashesEnumerator;
        }
    }

    private final ContentHashEnumerator tryRebuildHashesStorageByContentStorage(ThrowableComputable<ContentHashEnumerator, IOException> hashesEnumeratorSupplier) throws IOException {
        ContentHashEnumerator recoveringHashesEnumerator = (ContentHashEnumerator)hashesEnumeratorSupplier.compute();
        try {
            IStorage iStorage = (IStorage)this.contentStorage;
            Intrinsics.checkNotNull((Object)recoveringHashesEnumerator);
            this.fillHashesEnumeratorByContentStorage(iStorage, recoveringHashesEnumerator);
            return recoveringHashesEnumerator;
        }
        catch (Throwable t) {
            recoveringHashesEnumerator.closeAndClean();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fillHashesEnumeratorByContentStorage(IStorage contentStorage, ContentHashEnumerator hashesEnumeratorToFill) throws IOException {
        RecordIdIterator it = contentStorage.createRecordIdIterator();
        while (it.hasNextId()) {
            int contentRecordId = it.nextId();
            Closeable closeable = contentStorage.readStream(contentRecordId);
            Throwable throwable = null;
            try {
                byte[] hash;
                DataInputStream stream = (DataInputStream)closeable;
                boolean bl = false;
                byte[] content2 = stream.readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)PersistentFSContentAccessor.calculateHash(content2, 0, content2.length), (String)"calculateHash(...)");
                int contentHashId = hashesEnumeratorToFill.enumerate(hash);
                if (contentHashId != contentRecordId) {
                    throw new IOException("Content enumerator recovery fails (content id: #" + contentRecordId + " hashed to different id: #" + contentHashId + ")");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RecordIdIterator createRecordIdIterator() throws IOException {
        RecordIdIterator recordIdIterator;
        Lock lock = this.lock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"readLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            RecordIdIterator recordIdIterator2 = this.contentStorage.createRecordIdIterator();
            recordIdIterator = recordIdIterator2;
        }
        finally {
            lock2.unlock();
        }
        Intrinsics.checkNotNullExpressionValue((Object)recordIdIterator, (String)"withLock(...)");
        return recordIdIterator;
    }

    public boolean isEmpty() throws IOException {
        return this.contentStorage.getRecordsCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordsCount() throws IOException {
        int n;
        Lock lock = this.lock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"readLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            n = this.contentStorage.getRecordsCount();
        }
        finally {
            lock2.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() throws IOException {
        int n;
        Lock lock = this.lock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"readLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            n = this.contentStorage.getVersion();
        }
        finally {
            lock2.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(int expectedVersion) throws IOException {
        Lock lock = this.lock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"writeLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            this.contentStorage.setVersion(expectedVersion);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRecord(int recordId, boolean fastCheck) {
        Lock lock = this.lock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"readLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            byte[] contentHash = this.hashesEnumerator.valueOf(recordId);
            if (contentHash == null) {
                throw new IOException("contentHash[#" + recordId + "] does not exist (null)! -> content hashes enumerator is inconsistent (broken?)");
            }
            if (!fastCheck) {
                Closeable closeable = this.contentStorage.readStream(recordId);
                Throwable throwable = null;
                try {
                    DataInputStream stream = (DataInputStream)closeable;
                    boolean bl2 = false;
                    byte[] byArray = stream.readAllBytes();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] contentHash(int recordId) {
        Lock lock = this.lock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"readLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            byte[] byArray = this.hashesEnumerator.valueOf(recordId);
            Intrinsics.checkNotNull((Object)byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DataInputStream readStream(int recordId) throws IOException {
        DataInputStream dataInputStream;
        Lock lock = this.lock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"readLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            DataInputStream dataInputStream2 = this.contentStorage.readStream(recordId);
            dataInputStream = dataInputStream2;
        }
        finally {
            lock2.unlock();
        }
        Intrinsics.checkNotNullExpressionValue((Object)dataInputStream, (String)"withLock(...)");
        return dataInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int storeRecord(@NotNull ByteArraySequence contentBytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)contentBytes, (String)"contentBytes");
        Lock lock = this.lock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"writeLock(...)");
        Lock lock2 = lock;
        lock2.lock();
        try {
            int n;
            int hashId;
            boolean bl = false;
            int length = contentBytes.length();
            long hashStartedNs = System.nanoTime();
            byte[] byArray = PersistentFSContentAccessor.calculateHash(contentBytes);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"calculateHash(...)");
            byte[] contentHash = byArray;
            this.totalHashCalculationTimeNs += System.nanoTime() - hashStartedNs;
            if ((this.totalContentRecordsStored & 0x3FFF) == 0) {
                ContentStorageAdapterKt.access$getLOG$p().info("Contents: " + this.totalContentRecordsStored + " records of " + this.totalContentBytesStored + "b total were actually stored, " + this.totalContentRecordsReused + " records of " + this.totalContentBytesReused + "b were reused, for " + TimeUnit.NANOSECONDS.toSeconds(this.totalHashCalculationTimeNs) + " ms spent on hashing");
            }
            if ((hashId = this.hashesEnumerator.enumerateEx(contentHash)) < 0) {
                int alreadyExistingContentRecordId;
                int n2 = this.totalContentRecordsReused;
                this.totalContentRecordsReused = n2 + 1;
                this.totalContentBytesReused += (long)length;
                int n3 = alreadyExistingContentRecordId = -hashId;
                return n3;
            }
            int newContentRecordId = this.contentStorage.acquireNewRecord();
            int n4 = n = hashId == newContentRecordId ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl2 = false;
                String string = "Unexpected content storage modification: contentHashId=" + hashId + "; newContentRecord=" + newContentRecordId;
                throw new AssertionError((Object)string);
            }
            this.contentStorage.writeBytes(newContentRecordId, contentBytes, true);
            n = this.totalContentRecordsStored;
            this.totalContentRecordsStored = n + 1;
            this.totalContentBytesStored += (long)length;
            int n5 = newContentRecordId;
            return n5;
        }
        finally {
            lock2.unlock();
        }
    }

    public boolean isDirty() {
        return this.contentStorage.isDirty();
    }

    public void force() throws IOException {
        this.hashesEnumerator.force();
        this.contentStorage.force();
    }

    public void close() throws IOException {
        this.hashesEnumerator.close();
        Disposer.dispose((Disposable)((Disposable)this.contentStorage));
    }

    public void closeAndClean() throws IOException {
        this.hashesEnumerator.closeAndClean();
        this.contentStorage.closeAndClean();
    }
}

