/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.rd.GraphicsExKt;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ContentLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.content.Content;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ContentComboLabel
extends ContentLabel {
    private final ActiveIcon myComboIcon;
    private final Point myComboIconPoint;
    private final ComboContentLayout myLayout;

    ContentComboLabel(@NotNull ComboContentLayout layout2) {
        if (layout2 == null) {
            ContentComboLabel.$$$reportNull$$$0(0);
        }
        super(layout2.ui, true);
        this.myComboIcon = new ActiveIcon(ExperimentalUI.isNewUI() ? AllIcons.General.LinkDropTriangle : AllIcons.General.ArrowDown);
        this.myComboIconPoint = new Point();
        this.myLayout = layout2;
        this.addMouseListener(new MouseAdapter(this){});
        if (ScreenReader.isActive()) {
            this.setFocusable(true);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getModifiers() == 0 && e.getKeyCode() == 32) {
                        ToolWindowContentUi.toggleContentPopup(ContentComboLabel.this.myUi, ContentComboLabel.this.myUi.getContentManager());
                    }
                    super.keyPressed(e);
                }
            });
        }
    }

    @Override
    @Nullable
    protected String getOriginalText() {
        Content content2 = this.getContent();
        return content2 != null ? content2.getDisplayName() : null;
    }

    @Override
    protected void handleMouseClick(@NotNull MouseEvent e) {
        if (e == null) {
            ContentComboLabel.$$$reportNull$$$0(1);
        }
        if (e.getID() == 502) {
            this.handleActionsClick(e);
        }
        if (e.getID() == 501) {
            if (this.findHoveredIcon() != null) {
                return;
            }
            if (UIUtil.isActionClick((MouseEvent)e) && this.isToDrawCombo()) {
                ToolWindowContentUi.toggleContentPopup(this.myUi, this.myUi.getContentManager());
            }
        }
    }

    void update() {
        if (this.isToDrawCombo()) {
            this.myBorder.setBorderInsets(0, JBUI.scale((int)8), 0, JBUI.scale((int)8));
        } else {
            this.myBorder.setBorderInsets(0, 0, 0, 0);
        }
        this.updateTextAndIcon(this.getContent(), true, ExperimentalUI.isNewUI());
        this.updateAdditionalActions();
    }

    @Override
    protected boolean allowEngravement() {
        return this.myUi == null || this.myUi.window.isActive();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size2 = super.getMinimumSize();
        if (!this.isMinimumSizeSet()) {
            Insets insets;
            size2.width = this.isToDrawCombo() ? this.myComboIcon.getIconWidth() : 0;
            Icon icon2 = this.getIcon();
            if (icon2 != null) {
                size2.width += icon2.getIconWidth() + this.getIconTextGap();
            }
            if ((insets = this.getInsets()) != null) {
                size2.width += insets.left + insets.right;
            }
        }
        return size2;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size2 = super.getPreferredSize();
        int iconsGap = JBUI.scale((int)3);
        if (!this.isPreferredSizeSet() && this.isToDrawCombo()) {
            if (this.hasActiveIcons()) {
                size2.width -= iconsGap;
            }
            this.myComboIconPoint.x = size2.width;
            size2.width += this.myComboIcon.getIconWidth();
        }
        if (ExperimentalUI.isNewUI()) {
            if (this.myLayout.shouldShowId()) {
                this.myBorder.setBorderInsets(0, JBUI.CurrentTheme.ToolWindow.headerTabLeftRightInsets().left, 0, iconsGap);
            } else {
                this.myBorder.setBorderInsets(0, JBUI.CurrentTheme.ToolWindow.headerLabelLeftRightInsets().left, 0, iconsGap);
            }
        }
        return size2;
    }

    private boolean isToDrawCombo() {
        return this.myLayout.isToDrawCombo();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color bgColor = this.getTabColor();
        if (bgColor != null) {
            int borderThickness = JBUIScale.scale((int)1);
            Dimension size2 = this.getSize();
            Rectangle rect = new Rectangle(0, borderThickness, size2.width, size2.height - 2 * borderThickness);
            GraphicsExKt.fill2DRect((Graphics2D)((Graphics2D)g), (Rectangle)rect, (Color)bgColor);
        }
        super.paintComponent(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.isToDrawCombo()) {
            this.myComboIcon.setActive(this.myUi.window.isActive());
            this.myComboIconPoint.y = this.getHeight() / 2 - this.myComboIcon.getIconHeight() / 2 + 1;
            this.myComboIcon.paintIcon((Component)this, g, this.myComboIconPoint.x, this.myComboIconPoint.y);
            g.setColor(Gray._255.withAlpha(100));
        }
    }

    @Override
    @Nullable
    public Content getContent() {
        return this.myUi.getContentManager().getSelectedContent();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleContentComboLabel();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/content/ContentComboLabel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleMouseClick";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class AccessibleContentComboLabel
    extends BaseLabel.AccessibleBaseLabel
    implements AccessibleAction {
        private AccessibleContentComboLabel() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int index) {
            return index == 0 ? UIManager.getString("ComboBox.togglePopupText") : null;
        }

        @Override
        public boolean doAccessibleAction(int index) {
            if (index == 0) {
                ToolWindowContentUi.toggleContentPopup(ContentComboLabel.this.myUi, ContentComboLabel.this.myUi.getContentManager());
                return true;
            }
            return false;
        }
    }
}

