/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.headertoolbar;

import com.intellij.openapi.wm.impl.headertoolbar.MainToolbarKt;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0015R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tRA\u0010\n\u001a2\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r \u000f*\u0017\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r0\u000e\u00a2\u0006\u0002\b\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/wm/impl/headertoolbar/HeaderIconUpdater;", "", "<init>", "()V", "iconCache", "Ljava/util/WeakHashMap;", "Ljavax/swing/Icon;", "Ljava/lang/ref/WeakReference;", "getIconCache", "()Ljava/util/WeakHashMap;", "alreadyUpdated", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "getAlreadyUpdated", "()Ljava/util/Set;", "updateIcon", "sourceIcon", "clearCache", "", "intellij.platform.ide.impl"})
final class HeaderIconUpdater {
    @NotNull
    private final WeakHashMap<Icon, WeakReference<Icon>> iconCache = new WeakHashMap();
    @NotNull
    private final Set<Icon> alreadyUpdated;

    public HeaderIconUpdater() {
        Set set = ContainerUtil.createWeakSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createWeakSet(...)");
        this.alreadyUpdated = set;
    }

    @NotNull
    public final WeakHashMap<Icon, WeakReference<Icon>> getIconCache() {
        return this.iconCache;
    }

    @NotNull
    public final Set<Icon> getAlreadyUpdated() {
        return this.alreadyUpdated;
    }

    @NotNull
    public final Icon updateIcon(@NotNull Icon sourceIcon) {
        Icon cached;
        Intrinsics.checkNotNullParameter((Object)sourceIcon, (String)"sourceIcon");
        if (this.alreadyUpdated.contains(sourceIcon)) {
            return sourceIcon;
        }
        WeakReference<Icon> weakReference = this.iconCache.get(sourceIcon);
        Icon icon2 = cached = weakReference != null ? (Icon)weakReference.get() : null;
        if (cached != null) {
            return cached;
        }
        Icon replaceIcon = MainToolbarKt.access$adjustIconForHeader(sourceIcon);
        ((Map)this.iconCache).put(sourceIcon, new WeakReference<Icon>(replaceIcon));
        this.alreadyUpdated.add(replaceIcon);
        return replaceIcon;
    }

    public final void clearCache() {
        this.iconCache.clear();
        this.alreadyUpdated.clear();
    }
}

