/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.ChildStatusBarWidget;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImplKt;
import com.intellij.openapi.wm.impl.status.Position;
import com.intellij.openapi.wm.impl.status.StatusBarWidgetWrapper;
import com.intellij.openapi.wm.impl.status.WidgetBean;
import com.intellij.openapi.wm.impl.status.WidgetRegistry;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EDT;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentSet;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0007J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003J\u001e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010 \u001a\u00020\u00172\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170\"J\u000e\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/wm/impl/status/ChildStatusBarManager;", "", "parent", "Lcom/intellij/openapi/wm/impl/status/IdeStatusBarImpl;", "widgetRegistry", "Lcom/intellij/openapi/wm/impl/status/WidgetRegistry;", "<init>", "(Lcom/intellij/openapi/wm/impl/status/IdeStatusBarImpl;Lcom/intellij/openapi/wm/impl/status/WidgetRegistry;)V", "children", "Lkotlinx/collections/immutable/PersistentSet;", "size", "", "getSize", "()I", "isEmpty", "", "createChild", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "currentFileEditorFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "propagateWidgetToChild", "", "widget", "Lcom/intellij/openapi/wm/StatusBarWidget;", "position", "Lcom/intellij/openapi/wm/impl/status/Position;", "anchor", "Lcom/intellij/openapi/extensions/LoadingOrder;", "child", "propagateToAll", "updateAll", "action", "Lkotlin/Function1;", "setVisibilityForAll", "visible", "intellij.platform.ide.impl"})
public final class ChildStatusBarManager {
    @NotNull
    private final IdeStatusBarImpl parent;
    @NotNull
    private final WidgetRegistry widgetRegistry;
    @NotNull
    private volatile PersistentSet<? extends IdeStatusBarImpl> children;

    public ChildStatusBarManager(@NotNull IdeStatusBarImpl parent, @NotNull WidgetRegistry widgetRegistry) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)widgetRegistry, (String)"widgetRegistry");
        this.parent = parent;
        this.widgetRegistry = widgetRegistry;
        this.children = ExtensionsKt.persistentHashSetOf();
    }

    public final int getSize() {
        return this.children.size();
    }

    public final boolean isEmpty() {
        return this.children.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    @NotNull
    public final IdeStatusBarImpl createChild(@NotNull CoroutineScope coroutineScope, @NotNull StateFlow<? extends FileEditor> currentFileEditorFlow) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(currentFileEditorFlow, (String)"currentFileEditorFlow");
        EDT.assertIsEdt();
        IdeStatusBarImpl bar2 = new IdeStatusBarImpl(coroutineScope, (Function0<? extends Project>)((Function0)new PropertyReference0Impl(this.parent){

            public Object get() {
                return ((IdeStatusBarImpl)this.receiver).getProject();
            }
        }), false, currentFileEditorFlow);
        bar2.setVisible(this.parent.isVisible());
        IdeStatusBarImpl ideStatusBarImpl = this.parent;
        synchronized (ideStatusBarImpl) {
            boolean bl = false;
            this.children = this.children.add((Object)bar2);
            Unit unit = Unit.INSTANCE;
        }
        JobKt.getJob((CoroutineContext)coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> ChildStatusBarManager.createChild$lambda$1(this, bar2, arg_0));
        for (WidgetBean bean : this.widgetRegistry.getAllBeans()) {
            this.propagateWidgetToChild(bean.widget, bean.position, bean.getOrder(), bar2);
        }
        return bar2;
    }

    public final void propagateWidgetToChild(@NotNull StatusBarWidget widget2, @NotNull Position position2, @NotNull LoadingOrder anchor, @NotNull IdeStatusBarImpl child) {
        StatusBarWidget statusBarWidget;
        Intrinsics.checkNotNullParameter((Object)widget2, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)((Object)position2), (String)"position");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        StatusBarWidget statusBarWidget2 = widget2;
        if (statusBarWidget2 instanceof ChildStatusBarWidget) {
            statusBarWidget = ((ChildStatusBarWidget)widget2).createForChild(child);
        } else if (statusBarWidget2 instanceof StatusBarWidget.Multiframe) {
            statusBarWidget = ((StatusBarWidget.Multiframe)widget2).copy();
        } else {
            return;
        }
        StatusBarWidget childWidget = statusBarWidget;
        JComponent component2 = IdeStatusBarImplKt.wrap(childWidget);
        if (component2 instanceof StatusBarWidgetWrapper) {
            ((StatusBarWidgetWrapper)((Object)component2)).beforeUpdate();
        }
        IdeStatusBarImpl.addWidgetToSelf$intellij_platform_ide_impl$default(child, new WidgetBean(childWidget, position2, component2, anchor), null, 2, null);
    }

    public final void propagateToAll(@NotNull StatusBarWidget widget2, @NotNull Position position2, @NotNull LoadingOrder anchor) {
        Intrinsics.checkNotNullParameter((Object)widget2, (String)"widget");
        Intrinsics.checkNotNullParameter((Object)((Object)position2), (String)"position");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        for (IdeStatusBarImpl child : this.children) {
            this.propagateWidgetToChild(widget2, position2, anchor, child);
        }
    }

    public final void updateAll(@NotNull Function1<? super IdeStatusBarImpl, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        for (IdeStatusBarImpl child : this.children) {
            action2.invoke((Object)child);
        }
    }

    public final void setVisibilityForAll(boolean visible) {
        for (IdeStatusBarImpl child : this.children) {
            child.setVisible(visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit createChild$lambda$1(ChildStatusBarManager this$0, IdeStatusBarImpl $bar, Throwable it) {
        IdeStatusBarImpl ideStatusBarImpl = this$0.parent;
        synchronized (ideStatusBarImpl) {
            boolean bl = false;
            this$0.children = this$0.children.remove((Object)$bar);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

